/*
 * Decompiled with CFR 0.152.
 */
package base.drawable;

import base.drawable.DrawnBox;
import javax.swing.JTree;

public class DrawnBoxSet {
    private JTree tree_view;
    private DrawnBox[] last_arrow_pos;
    private DrawnBox[] last_state_pos;
    private DrawnBox[] last_event_pos;
    private int num_rows;

    public DrawnBoxSet(JTree in_tree_view) {
        this.tree_view = in_tree_view;
        this.last_arrow_pos = null;
        this.last_state_pos = null;
        this.last_event_pos = null;
        this.num_rows = 0;
    }

    public void initialize() {
        this.num_rows = this.tree_view.getRowCount();
        this.last_arrow_pos = new DrawnBox[this.num_rows * this.num_rows];
        this.last_state_pos = new DrawnBox[this.num_rows];
        this.last_event_pos = new DrawnBox[this.num_rows];
        int idx = -1;
        for (int ii = 0; ii < this.num_rows; ++ii) {
            if (!this.tree_view.isExpanded(ii)) {
                this.last_state_pos[ii] = new DrawnBox();
                this.last_event_pos[ii] = new DrawnBox();
            } else {
                this.last_state_pos[ii] = null;
                this.last_event_pos[ii] = null;
            }
            for (int jj = 0; jj < this.num_rows; ++jj) {
                this.last_arrow_pos[++idx] = !this.tree_view.isExpanded(ii) && !this.tree_view.isExpanded(jj) ? new DrawnBox() : null;
            }
        }
    }

    public void reset() {
        int idx = -1;
        for (int ii = 0; ii < this.num_rows; ++ii) {
            if (this.last_state_pos[ii] != null) {
                this.last_state_pos[ii].reset();
                this.last_event_pos[ii].reset();
            }
            for (int jj = 0; jj < this.num_rows; ++jj) {
                if (this.last_arrow_pos[++idx] == null) continue;
                this.last_arrow_pos[idx].reset();
            }
        }
    }

    public void finish() {
        int idx = -1;
        for (int ii = 0; ii < this.num_rows; ++ii) {
            if (this.last_state_pos[ii] != null) {
                this.last_state_pos[ii] = null;
                this.last_event_pos[ii] = null;
            }
            for (int jj = 0; jj < this.num_rows; ++jj) {
                if (this.last_arrow_pos[++idx] == null) continue;
                this.last_arrow_pos[idx] = null;
            }
        }
    }

    public DrawnBox getLastArrowPos(int ii, int jj) {
        return this.last_arrow_pos[this.num_rows * ii + jj];
    }

    public DrawnBox getLastStatePos(int ii) {
        return this.last_state_pos[ii];
    }

    public DrawnBox getLastEventPos(int ii) {
        return this.last_event_pos[ii];
    }
}

