/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import viewer.common.LogFileChooser;
import viewer.convertor.ConvertorPanel;

public class ConvertorDialog
extends JDialog {
    private static String in_filename;
    private ConvertorPanel top_panel;

    public ConvertorDialog(JFrame ancestor_frame, LogFileChooser file_chooser) {
        super(ancestor_frame, "Logfile Convertor", true);
        super.setDefaultCloseOperation(0);
        this.top_panel = new ConvertorPanel(file_chooser);
        super.setContentPane(this.top_panel);
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConvertorDialog.this.setVisible(false);
                ConvertorDialog.this.dispose();
            }
        });
    }

    public void init(String trace_filename) {
        this.top_panel.init(trace_filename);
    }

    public static String convertLogFile(JFrame frame, LogFileChooser chooser, String filename) {
        ConvertorDialog conv_dialog = new ConvertorDialog(frame, chooser);
        CloseToRetrieveAction logname_fetcher = new CloseToRetrieveAction(conv_dialog);
        conv_dialog.top_panel.addActionListenerForOkayButton(logname_fetcher);
        CloseAction win_closer = new CloseAction(conv_dialog);
        conv_dialog.top_panel.addActionListenerForCancelButton(win_closer);
        conv_dialog.pack();
        conv_dialog.init(filename);
        conv_dialog.setVisible(true);
        return logname_fetcher.getFilename();
    }

    private static class CloseToRetrieveAction
    implements ActionListener {
        private ConvertorDialog convertor;
        private String filename;

        public CloseToRetrieveAction(ConvertorDialog convertor_dialog) {
            this.convertor = convertor_dialog;
            this.filename = null;
        }

        public String getFilename() {
            return this.filename;
        }

        public void actionPerformed(ActionEvent evt) {
            this.filename = this.convertor.top_panel.getOutputSLOG2Name();
            this.convertor.setVisible(false);
            this.convertor.dispose();
        }
    }

    private static class CloseAction
    implements ActionListener {
        private ConvertorDialog convertor;

        public CloseAction(ConvertorDialog convertor_dialog) {
            this.convertor = convertor_dialog;
        }

        public void actionPerformed(ActionEvent evt) {
            this.convertor.setVisible(false);
            this.convertor.dispose();
        }
    }
}

