/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import base.drawable.DrawnBox;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class Event {
    private static int Base_Half_Width = 6;
    private static int Base_Width = 3;
    private static double Max_LineSeg2Pt_DistSQ = 10.0;

    public static void setBaseWidth(int new_width) {
        Base_Half_Width = new_width / 2;
        if (Base_Half_Width < 0) {
            Base_Half_Width = 0;
        }
        Base_Width = Base_Half_Width + Base_Half_Width;
    }

    public static void setPixelClosenessTolerance(int pix_dist) {
        Max_LineSeg2Pt_DistSQ = pix_dist * pix_dist + 1;
    }

    public static int draw(Graphics2D g, Color color, Stroke stroke, CoordPixelXform coord_xform, DrawnBox last_drawn_pos, double point_time, float point_ypos, float start_ypos, float final_ypos) {
        boolean isPointVtxInImg;
        int iPoint = coord_xform.convertTimeToPixel(point_time);
        if (last_drawn_pos.coversEvent(iPoint)) {
            return 0;
        }
        last_drawn_pos.set(iPoint);
        boolean bl = isPointVtxInImg = iPoint > 0 && iPoint < coord_xform.getImageWidth();
        if (!isPointVtxInImg) {
            return 0;
        }
        int jPoint = coord_xform.convertRowToPixel(point_ypos);
        int jStart = coord_xform.convertRowToPixel(start_ypos);
        int jFinal = coord_xform.convertRowToPixel(final_ypos);
        Stroke orig_stroke = null;
        if (stroke != null) {
            orig_stroke = g.getStroke();
            g.setStroke(stroke);
        }
        int iCorner = 0;
        int jHeight = 0;
        g.setColor(color);
        g.drawLine(iPoint, jPoint, iPoint, jFinal);
        if (jStart != jPoint) {
            iCorner = iPoint - Base_Half_Width;
            jHeight = jPoint - jStart - 1;
            g.fillArc(iCorner, jStart, Base_Width, jHeight, 0, 360);
        }
        g.setColor(Color.white);
        if (jPoint != jFinal) {
            g.drawArc(iCorner, jStart, Base_Width, jHeight, 0, 360);
        } else {
            g.drawLine(iPoint - Base_Half_Width, jStart, iPoint + Base_Half_Width, jStart);
        }
        if (stroke != null) {
            g.setStroke(orig_stroke);
        }
        return 1;
    }

    public static boolean containsPixel(CoordPixelXform coord_xform, Point pt, double point_time, float start_ypos, float final_ypos) {
        double yPt;
        double xPt;
        double yFinal;
        double yStart;
        double xPoint = coord_xform.convertTimeToPixel(point_time);
        double distSQ = Line2D.ptSegDistSq(xPoint, yStart = (double)coord_xform.convertRowToPixel(start_ypos), xPoint, yFinal = (double)coord_xform.convertRowToPixel(final_ypos), xPt = (double)pt.x, yPt = (double)pt.y);
        return distSQ < Max_LineSeg2Pt_DistSQ;
    }
}

