/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.pipe;

import base.drawable.Category;
import base.drawable.Composite;
import base.drawable.Drawable;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import logformat.slog2.CategoryMap;
import logformat.slog2.LineIDMap;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TraceName;
import logformat.slog2.output.OutputLog;
import logformat.slog2.output.TreeTrunk;
import logformat.slog2.pipe.PipedInputLog;

public class Slog2ToSlog2 {
    private static short num_children_per_node = 0;
    private static int leaf_bytesize = 0;
    private static String in_filename;
    private static String out_filename;
    private static boolean enable_endtime_check;
    private static boolean continue_when_violation;
    private static int[] del_iobjdefs;
    private static String help_msg;

    public static final void main(String[] args) {
        Kind next_kind;
        String err_msg;
        double prev_dobj_endtime = Double.NEGATIVE_INFINITY;
        long offended_Nobjs = Integer.MIN_VALUE;
        Drawable offended_dobj = null;
        out_filename = null;
        del_iobjdefs = null;
        Slog2ToSlog2.parseCmdLineArgs(args);
        if (out_filename == null) {
            out_filename = TraceName.getDefaultSLOG2Name(in_filename);
        }
        CategoryMap objdefs = new CategoryMap();
        HashMap<Topology, Category> shadefs = new HashMap<Topology, Category>();
        LineIDMapList lineIDmaps = new LineIDMapList();
        long Nobjs = 0L;
        PipedInputLog dobj_ins = new PipedInputLog(in_filename);
        if (dobj_ins == null) {
            System.err.println("Null input logfile!");
            System.exit(1);
        }
        if (!dobj_ins.isSLOG2()) {
            System.err.println(in_filename + " is NOT SLOG-2 file!.");
            System.exit(1);
        }
        if ((err_msg = dobj_ins.getCompatibleHeader()) != null) {
            System.err.print(err_msg);
            PipedInputLog.stdoutConfirmation();
        }
        dobj_ins.initialize();
        Date time1 = new Date();
        OutputLog slog_outs = new OutputLog(out_filename);
        if (leaf_bytesize > 0) {
            slog_outs.setTreeLeafByteSize(leaf_bytesize);
        } else {
            slog_outs.setTreeLeafByteSize(dobj_ins.getTreeLeafByteSize());
        }
        if (num_children_per_node > 0) {
            slog_outs.setNumChildrenPerNode(num_children_per_node);
        } else {
            slog_outs.setNumChildrenPerNode(dobj_ins.getNumChildrenPerNode());
        }
        TreeTrunk treetrunk = new TreeTrunk(slog_outs, shadefs);
        Date time2 = new Date();
        while ((next_kind = dobj_ins.peekNextKind()) != Kind.EOF) {
            double curr_dobj_endtime;
            Category objdef;
            if (next_kind == Kind.TOPOLOGY) {
                Topology topo = dobj_ins.getNextTopology();
                objdef = Category.getShadowCategory(topo);
                objdefs.put(new Integer(objdef.getIndex()), objdef);
                shadefs.put(topo, objdef);
                continue;
            }
            if (next_kind == Kind.YCOORDMAP) {
                LineIDMap lineIDmap = new LineIDMap(dobj_ins.getNextYCoordMap());
                lineIDmaps.add(lineIDmap);
                continue;
            }
            if (next_kind == Kind.CATEGORY) {
                objdef = dobj_ins.getNextCategory();
                if (objdef.isShadowCategory()) {
                    objdefs.put(new Integer(objdef.getIndex()), objdef);
                    shadefs.put(objdef.getTopology(), objdef);
                }
                objdefs.put(new Integer(objdef.getIndex()), objdef);
                objdef.setUsed(false);
                continue;
            }
            if (next_kind == Kind.PRIMITIVE) {
                Primitive prime_obj = dobj_ins.getNextPrimitive();
                prime_obj.releaseCategory();
                if (Slog2ToSlog2.isCategoryToBeRemoved(prime_obj.getCategoryIndex())) continue;
                prime_obj.resolveCategory(objdefs);
                ++Nobjs;
                if (enable_endtime_check) {
                    if (!prime_obj.isTimeOrdered()) {
                        System.out.println("**** Primitive Time Error ****");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    if (prev_dobj_endtime > (curr_dobj_endtime = prime_obj.getLatestTime())) {
                        System.err.println("**** Violation of Increasing Endtime Order ****\n\t Offended Drawable -> " + offended_Nobjs + " : " + offended_dobj + "\n" + "\t Offending Primitive -> " + Nobjs + " : " + prime_obj + "\n" + "   previous drawable endtime ( " + prev_dobj_endtime + " ) " + " > current drawable endtiime ( " + curr_dobj_endtime + " ) ");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    offended_Nobjs = Nobjs;
                    offended_dobj = prime_obj;
                    prev_dobj_endtime = curr_dobj_endtime;
                }
                treetrunk.addDrawable(prime_obj);
                continue;
            }
            if (next_kind == Kind.COMPOSITE) {
                Composite cmplx_obj = dobj_ins.getNextComposite();
                cmplx_obj.releaseCategory();
                if (Slog2ToSlog2.isCategoryToBeRemoved(cmplx_obj.getCategoryIndex())) continue;
                cmplx_obj.resolveCategory(objdefs);
                ++Nobjs;
                if (enable_endtime_check) {
                    if (!cmplx_obj.isTimeOrdered()) {
                        System.out.println("**** Composite Time Error ****");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    if (prev_dobj_endtime > (curr_dobj_endtime = cmplx_obj.getLatestTime())) {
                        System.err.println("***** Violation of Increasing Endtime Order! *****\n\t Offended Drawable -> " + offended_Nobjs + " : " + offended_dobj + "\n" + "\t Offending Composite -> " + Nobjs + " : " + cmplx_obj + "\n" + "   previous drawable endtime ( " + prev_dobj_endtime + " ) " + " > current drawable endtiime ( " + curr_dobj_endtime + " ) ");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    offended_Nobjs = Nobjs;
                    offended_dobj = cmplx_obj;
                    prev_dobj_endtime = curr_dobj_endtime;
                }
                treetrunk.addDrawable(cmplx_obj);
                continue;
            }
            System.err.println("Slog2ToSlog2: Unrecognized return from peekNextKind() = " + next_kind);
        }
        treetrunk.flushToFile();
        objdefs.removeUnusedCategories();
        slog_outs.writeCategoryMap(objdefs);
        slog_outs.writeLineIDMapList(lineIDmaps);
        slog_outs.close();
        dobj_ins.close();
        Date time3 = new Date();
        System.out.println("\n");
        System.out.println("Number of Drawables = " + Nobjs);
        System.out.println("timeElapsed between 1 & 2 = " + (time2.getTime() - time1.getTime()) + " msec");
        System.out.println("timeElapsed between 2 & 3 = " + (time3.getTime() - time2.getTime()) + " msec");
    }

    private static int parseByteSize(String size_str) {
        int idxOfKilo = Math.max(size_str.indexOf(107), size_str.indexOf(75));
        int idxOfMega = Math.max(size_str.indexOf(109), size_str.indexOf(77));
        if (idxOfKilo > 0) {
            return Integer.parseInt(size_str.substring(0, idxOfKilo)) * 1024;
        }
        if (idxOfMega > 0) {
            return Integer.parseInt(size_str.substring(0, idxOfMega)) * 1024 * 1024;
        }
        return Integer.parseInt(size_str);
    }

    private static void parseCmdLineArgs(String[] argv) {
        StringBuffer err_msg = new StringBuffer();
        in_filename = null;
        enable_endtime_check = false;
        continue_when_violation = false;
        int idx = 0;
        try {
            while (idx < argv.length) {
                if (argv[idx].startsWith("-")) {
                    String arg_str;
                    if (argv[idx].equals("-h") || argv[idx].equals("--h") || argv[idx].equals("-help") || argv[idx].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (argv[idx].equals("-tc")) {
                        enable_endtime_check = true;
                        continue_when_violation = false;
                        err_msg.append("\n endtime_order_check_exit = true");
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-tcc")) {
                        enable_endtime_check = true;
                        continue_when_violation = true;
                        err_msg.append("\n endtime_order_check_stay = true");
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-nc")) {
                        arg_str = argv[++idx];
                        num_children_per_node = Short.parseShort(arg_str);
                        err_msg.append("\n number_of_children_per_node = " + arg_str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-ls")) {
                        arg_str = argv[++idx];
                        leaf_bytesize = Slog2ToSlog2.parseByteSize(arg_str);
                        err_msg.append("\n max_byte_size_of_leaf_node = " + arg_str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-r")) {
                        arg_str = argv[++idx];
                        Slog2ToSlog2.parseRemovalCategoryIndexes(arg_str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].equals("-o")) {
                        out_filename = argv[++idx].trim();
                        err_msg.append("\n output_filename = " + out_filename);
                        ++idx;
                        if (out_filename.endsWith(".slog2")) continue;
                        System.err.println("Warning: The suffix of the output filename is NOT \".slog2\".");
                        continue;
                    }
                    System.err.println("Unrecognized option, " + argv[idx] + ", at " + Slog2ToSlog2.indexOrderStr(idx + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = argv[idx];
                ++idx;
            }
        }
        catch (ArrayIndexOutOfBoundsException idxerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + Slog2ToSlog2.indexOrderStr(idx) + " command line argument.");
            idxerr.printStackTrace();
        }
        catch (NumberFormatException numerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            String idx_order_str = Slog2ToSlog2.indexOrderStr(idx);
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + Slog2ToSlog2.indexOrderStr(idx) + " command line argument.  It needs a number.");
            numerr.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("This program needs a SLOG2 filename as part of the command line arguments.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int idx) {
        switch (idx) {
            case 1: {
                return Integer.toString(idx) + "st";
            }
            case 2: {
                return Integer.toString(idx) + "nd";
            }
            case 3: {
                return Integer.toString(idx) + "rd";
            }
        }
        return Integer.toString(idx) + "th";
    }

    private static void parseRemovalCategoryIndexes(String arg_str) {
        StringTokenizer idxs_itr = new StringTokenizer(arg_str.trim(), ",");
        del_iobjdefs = new int[idxs_itr.countTokens()];
        int ii = 0;
        while (idxs_itr.hasMoreTokens()) {
            Slog2ToSlog2.del_iobjdefs[ii] = Integer.parseInt(idxs_itr.nextToken());
            ++ii;
        }
        Arrays.sort(del_iobjdefs);
    }

    private static boolean isCategoryToBeRemoved(int iobjdef) {
        return del_iobjdefs != null && Arrays.binarySearch(del_iobjdefs, iobjdef) >= 0;
    }

    static {
        help_msg = "Usage: java slog2.output.Slog2ToSlog2 [options] slog2_filename.\n options: \n\t [-h|--h|-help|--help]             \t Display HELP message.\n\t [-tc]                             \t Check increasing endtime order,\n\t                                   \t exit when 1st violation occurs.\n\t [-tcc]                            \t Check increasing endtime order,\n\t                                   \t continue when violations occur.\n\t [-nc number_of_children_per_node] \t Default value is taken from the\n\t                                   \t input slog2 file.\n\t [-ls max_byte_size_of_leaf_node]  \t Default value is taken from the\n\t                                   \t input slog2 file.\n\t [-r id1,id2,...,idN]              \t Remove drawable categories of  \n\t                                   \t indexes, id1,id2,...,idN.\n\t [-o output_filename_with_slog2_suffix]\n\n note: \"max_byte_size_of_leaf_node\" can be specified with suffix k, K, m or M,\n       where k or K stands for kilobyte, m or M stands for megabyte.\n       e.g. 64k means 65536 bytes.\n";
    }
}

