/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import logformat.slog2.input.InputLog;
import logformat.slog2.input.TreeNode;
import logformat.slog2.input.TreeTrunk;

public class Navigator {
    private static boolean printAll = false;
    private static boolean changedPrintAll = false;
    private static boolean isVerbose = false;
    private static InputStreamReader sys_insrdr = new InputStreamReader(System.in);
    private static BufferedReader sys_bufrdr = new BufferedReader(sys_insrdr);
    private static String in_filename;
    private static short depth_max;
    private static short depth;
    private static String format_msg;
    private static String input_msg;
    private static double zoom_ftr;
    private static String stub_msg;
    private static String help_msg;

    public static final void main(String[] args) {
        String err_msg;
        Navigator.parseCmdLineArgs(args);
        InputLog slog_ins = new InputLog(in_filename);
        if (slog_ins == null) {
            System.err.println("Null input logfile!");
            System.exit(1);
        }
        if (!slog_ins.isSLOG2()) {
            System.err.println(in_filename + " is NOT SLOG-2 file!.");
            System.exit(1);
        }
        if ((err_msg = slog_ins.getCompatibleHeader()) != null) {
            System.err.print(err_msg);
            InputLog.stdoutConfirmation();
        }
        slog_ins.initialize();
        TreeTrunk treetrunk = new TreeTrunk(slog_ins, Drawable.INCRE_STARTTIME_ORDER);
        treetrunk.setDebuggingEnabled(isVerbose);
        treetrunk.initFromTreeTop();
        TreeNode treeroot = treetrunk.getTreeRoot();
        if (treeroot == null) {
            System.out.println("SLOG-2 file, " + in_filename + " " + "contains no drawables");
            slog_ins.close();
            System.exit(0);
        }
        TimeBoundingBox timeframe_root = new TimeBoundingBox(treeroot);
        depth_max = treeroot.getTreeNodeID().depth;
        System.out.println("TimeWindow = " + timeframe_root + " @ dmax = " + depth_max);
        TimeBoundingBox timeframe_old = new TimeBoundingBox(timeframe_root);
        depth = depth_max;
        TimeBoundingBox timeframe = Navigator.getTimeWindowFromStdin(timeframe_old);
        System.out.println("TimeWindow = " + timeframe + " @ d = " + depth);
        treetrunk.growInTreeWindow(treeroot, depth, timeframe);
        if (printAll) {
            System.out.println(treetrunk.toString(timeframe));
        } else {
            System.out.println(treetrunk.toStubString());
        }
        timeframe_old = timeframe;
        while ((timeframe = Navigator.getTimeWindowFromStdin(timeframe_old)) != null) {
            System.out.println("TimeWindow = " + timeframe + " @ d = " + depth);
            if (!changedPrintAll && treetrunk.updateTimeWindow(timeframe_old, timeframe) <= 0) continue;
            if (printAll) {
                System.out.println(treetrunk.toString(timeframe));
            } else {
                System.out.println(treetrunk.toStubString());
            }
            timeframe_old = timeframe;
            changedPrintAll = false;
        }
        slog_ins.close();
    }

    private static TimeBoundingBox getTimeWindow(TimeBoundingBox timeframe_old, String[] argv) {
        StringBuffer err_msg = new StringBuffer();
        TimeBoundingBox timeframe = new TimeBoundingBox(timeframe_old);
        int idx = 0;
        try {
            while (idx < argv.length) {
                double win_span;
                double Nwins;
                double ctr_span;
                double zoom_ctr;
                if (argv[idx].indexOf(61) != -1) {
                    String str;
                    if (argv[idx].startsWith("d=")) {
                        str = argv[idx].trim().substring(2);
                        depth = Short.parseShort(str);
                        err_msg.append("\n lowest_depth = " + str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].startsWith("ts=")) {
                        str = argv[idx].trim().substring(3);
                        timeframe.setEarliestTime(Double.parseDouble(str));
                        err_msg.append("\n time_frame_start = " + str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].startsWith("tf=")) {
                        str = argv[idx].trim().substring(3);
                        timeframe.setLatestTime(Double.parseDouble(str));
                        err_msg.append("\n time_frame_final = " + str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].startsWith("+=")) {
                        str = argv[idx].trim().substring(2);
                        zoom_ctr = Double.parseDouble(str);
                        ctr_span = timeframe_old.getDuration() / 2.0 / zoom_ftr;
                        timeframe.setEarliestTime(zoom_ctr - ctr_span);
                        timeframe.setLatestTime(zoom_ctr + ctr_span);
                        err_msg.append("\n zoom_in_center = " + str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].startsWith("-=")) {
                        str = argv[idx].trim().substring(2);
                        zoom_ctr = Double.parseDouble(str);
                        ctr_span = timeframe_old.getDuration() / 2.0 * zoom_ftr;
                        timeframe.setEarliestTime(zoom_ctr - ctr_span);
                        timeframe.setLatestTime(zoom_ctr + ctr_span);
                        err_msg.append("\n zoom_out_center = " + str);
                        ++idx;
                        continue;
                    }
                    if (argv[idx].startsWith(">=")) {
                        str = argv[idx].trim().substring(2);
                        Nwins = Double.parseDouble(str);
                        win_span = timeframe_old.getDuration();
                        timeframe.setEarliestTime(Nwins * win_span + timeframe_old.getEarliestTime());
                        timeframe.setLatestTime(win_span + timeframe.getEarliestTime());
                        err_msg.append("\n scroll_forward = " + str + " frames");
                        ++idx;
                        continue;
                    }
                    if (argv[idx].startsWith("<=")) {
                        str = argv[idx].trim().substring(2);
                        Nwins = Double.parseDouble(str);
                        win_span = timeframe_old.getDuration();
                        timeframe.setEarliestTime(-Nwins * win_span + timeframe_old.getEarliestTime());
                        timeframe.setLatestTime(win_span + timeframe.getEarliestTime());
                        err_msg.append("\n scroll_forward = " + str + " frames");
                        ++idx;
                        continue;
                    }
                    System.err.println("Unrecognized option, " + argv[idx] + ", at " + Navigator.indexOrderStr(idx + 1) + " input argument");
                    System.err.flush();
                    return null;
                }
                if (argv[idx].startsWith("+")) {
                    zoom_ctr = (timeframe_old.getEarliestTime() + timeframe_old.getLatestTime()) / 2.0;
                    ctr_span = timeframe_old.getDuration() / 2.0 / zoom_ftr;
                    timeframe.setEarliestTime(zoom_ctr - ctr_span);
                    timeframe.setLatestTime(zoom_ctr + ctr_span);
                    err_msg.append("\n zoom_in_center = " + zoom_ctr);
                    ++idx;
                    continue;
                }
                if (argv[idx].startsWith("-")) {
                    zoom_ctr = (timeframe_old.getEarliestTime() + timeframe_old.getLatestTime()) / 2.0;
                    ctr_span = timeframe_old.getDuration() / 2.0 * zoom_ftr;
                    timeframe.setEarliestTime(zoom_ctr - ctr_span);
                    timeframe.setLatestTime(zoom_ctr + ctr_span);
                    err_msg.append("\n zoom_out_center = " + zoom_ctr);
                    ++idx;
                    continue;
                }
                if (argv[idx].startsWith(">")) {
                    Nwins = 1.0;
                    win_span = timeframe_old.getDuration();
                    timeframe.setEarliestTime(Nwins * win_span + timeframe_old.getEarliestTime());
                    timeframe.setLatestTime(win_span + timeframe.getEarliestTime());
                    err_msg.append("\n scroll_forward = " + Nwins + " frames");
                    ++idx;
                    continue;
                }
                if (argv[idx].startsWith("<")) {
                    Nwins = 1.0;
                    win_span = timeframe_old.getDuration();
                    timeframe.setEarliestTime(-Nwins * win_span + timeframe_old.getEarliestTime());
                    timeframe.setLatestTime(win_span + timeframe.getEarliestTime());
                    err_msg.append("\n scroll_forward = " + Nwins + " frames");
                    ++idx;
                    continue;
                }
                if (argv[idx].startsWith("s")) {
                    printAll = false;
                    changedPrintAll = true;
                    err_msg.append("\n print_details = " + printAll);
                    ++idx;
                    continue;
                }
                if (argv[idx].startsWith("a")) {
                    printAll = true;
                    changedPrintAll = true;
                    err_msg.append("\n print_details = " + printAll);
                    ++idx;
                    continue;
                }
                System.err.println("Unrecognized option, " + argv[idx] + ", at " + Navigator.indexOrderStr(idx + 1) + " input argument");
                System.err.flush();
                return null;
            }
        }
        catch (NumberFormatException numerr) {
            if (err_msg.length() > 0) {
                System.err.println(err_msg.toString());
            }
            String idx_order_str = Navigator.indexOrderStr(idx);
            System.err.println("Error occurs after option " + argv[idx - 1] + ", " + Navigator.indexOrderStr(idx) + " input argument.  It needs a number.");
            numerr.printStackTrace();
            return null;
        }
        if (depth >= 0 && depth <= depth_max) {
            return timeframe;
        }
        System.err.println("Invalid TimeWindow!");
        return null;
    }

    private static TimeBoundingBox getTimeWindowFromStdin(TimeBoundingBox timeframe_old) {
        String[] input_args;
        TimeBoundingBox timeframe;
        do {
            String input_str;
            System.out.print("Enter TimeWindow: " + format_msg + " ?\n");
            try {
                input_str = sys_bufrdr.readLine();
            }
            catch (IOException ioerr) {
                ioerr.printStackTrace();
                return null;
            }
            StringTokenizer tokens = new StringTokenizer(input_str);
            input_args = new String[tokens.countTokens()];
            int idx = 0;
            while (tokens.hasMoreTokens()) {
                input_args[idx] = tokens.nextToken();
                ++idx;
            }
        } while ((timeframe = Navigator.getTimeWindow(timeframe_old, input_args)) == null);
        return timeframe;
    }

    private static void parseCmdLineArgs(String[] argv) {
        StringBuffer err_msg = new StringBuffer();
        int idx = 0;
        while (idx < argv.length) {
            if (argv[idx].startsWith("-")) {
                if (argv[idx].equals("-h") || argv[idx].equals("-help") || argv[idx].equals("--help")) {
                    System.out.println(help_msg);
                    System.out.flush();
                    System.exit(0);
                    continue;
                }
                if (argv[idx].equals("-s") || argv[idx].equals("-stub")) {
                    printAll = false;
                    ++idx;
                    continue;
                }
                if (argv[idx].equals("-a") || argv[idx].equals("-all")) {
                    printAll = true;
                    ++idx;
                    continue;
                }
                if (argv[idx].equals("-v") || argv[idx].equals("-verbose")) {
                    isVerbose = true;
                    ++idx;
                    continue;
                }
                System.err.println("Unrecognized option, " + argv[idx] + ", at " + Navigator.indexOrderStr(idx + 1) + " command line argument");
                System.out.flush();
                System.exit(1);
                continue;
            }
            in_filename = argv[idx];
            ++idx;
        }
        if (in_filename == null) {
            System.err.println("The Program needs a SLOG-2 filename as a command line argument.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int idx) {
        switch (idx) {
            case 1: {
                return Integer.toString(idx) + "st";
            }
            case 2: {
                return Integer.toString(idx) + "nd";
            }
            case 3: {
                return Integer.toString(idx) + "rd";
            }
        }
        return Integer.toString(idx) + "th";
    }

    static {
        format_msg = "[s|a] [d=I] [[ts=D] [tf=D]] [-[=D]] [+[=D]] [<[=F]] [>[=F]]";
        input_msg = "Interactive Input Options: \n\t Specification of the Time Frame : \n\t \t " + format_msg + "\n" + "\t [s|a], print details              " + " s for stub, a for all drawables.\n" + "\t [d=I], depth=Integer              " + " Needed only when program starts.\n" + "\t [ts=D], timeframe_start=Double    " + " Specify Start of TimeFrame.\n" + "\t [tf=D], timeframe_final=Double    " + " Specify Final of TimeFrame.\n" + "\t [-[=D]], zoom-out[=Double]        " + " Specify Center of Zoom-Out Frame.\n" + "\t [+[=D]], zoom-in[=Double]         " + " Specify Center of Zoom-In Frame.\n" + "\t [<[=F]], scroll-backward[=Frames] " + " Specify Frames to Scroll Backward.\n" + "\t [>[=F]], scroll-forward[=Frames]  " + " Specify Frames to Scroll Forward.\n";
        zoom_ftr = 2.0;
        stub_msg = "Format of the TreeNodeStub: \n  { TreeNodeID, TreeNodeEndtimes, BlockSize + FilePointer, NumOfDrawables .. }\n\t TreeNodeID : ID( d, i )            d is the depth of the TreeNode.\n\t                                    d = 0, for LeafNode; \n\t                                    d = d_max, for RootNode.\n\t                                    i is TreeNode's index(same depth).\n\t TreeNodeEndtimes                   TreeNode's Start and End times.\n";
        help_msg = "Usage: java slog2.input.Navigator [options] slog2_filename.\nOptions: \n\t [-h|-help|--help]                  Display this message.\n\t [-s|-stub]                         Print TreeNode's stub (Default).\n\t [-a|-all]                          Print TreeNode's drawable content.\n\t [-v|-verbose]                      Print detailed diagnostic message.\n\n" + input_msg + "\n" + stub_msg;
    }
}

