/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import java.util.StringTokenizer;

public class TraceName {
    public static final String CLOG2_EXT = ".clog2";
    public static final String CLOG_EXT = ".clog";
    public static final String RLOG_EXT = ".rlog";
    public static final String UTE_EXT = ".ute";
    public static final String TXT_EXT = ".txt";
    public static final String SLOG1_EXT = ".slog";
    public static final String SLOG2_EXT = ".slog2";
    private static final String DELIMITERS = "[]{}()~!@#$%^&*;`? \t\n\r\f";

    public static String getLogFormatExtension(String tracename) {
        if (tracename.endsWith(CLOG2_EXT)) {
            return CLOG2_EXT;
        }
        if (tracename.endsWith(CLOG_EXT)) {
            return CLOG_EXT;
        }
        if (tracename.endsWith(RLOG_EXT)) {
            return RLOG_EXT;
        }
        if (tracename.endsWith(UTE_EXT)) {
            return UTE_EXT;
        }
        if (tracename.endsWith(SLOG1_EXT)) {
            return SLOG1_EXT;
        }
        if (tracename.endsWith(SLOG2_EXT)) {
            return SLOG2_EXT;
        }
        if (tracename.endsWith(TXT_EXT)) {
            return TXT_EXT;
        }
        return "";
    }

    private static String stripInvalidChar(String tracename) {
        String delims = System.getProperty("file.separator").equals("/") ? "[]{}()~!@#$%^&*;`? \t\n\r\f:\\" : "[]{}()~!@#$%^&*;`? \t\n\r\f/";
        StringTokenizer tokens = new StringTokenizer(tracename, delims);
        StringBuffer strbuf = new StringBuffer();
        if (tokens.hasMoreTokens()) {
            strbuf.append(tokens.nextToken());
            while (tokens.hasMoreTokens()) {
                strbuf.append('_');
                strbuf.append(tokens.nextToken());
            }
        }
        if (strbuf.charAt(0) == '-') {
            return "TRACE_" + strbuf.toString();
        }
        return strbuf.toString();
    }

    public static String getDefaultSLOG2Name(String tracename) {
        if (tracename.endsWith(CLOG2_EXT)) {
            return tracename.substring(0, tracename.lastIndexOf(CLOG2_EXT)) + SLOG2_EXT;
        }
        if (tracename.endsWith(CLOG_EXT)) {
            return tracename.substring(0, tracename.lastIndexOf(CLOG_EXT)) + SLOG2_EXT;
        }
        if (tracename.endsWith(RLOG_EXT)) {
            return tracename.substring(0, tracename.lastIndexOf(RLOG_EXT)) + SLOG2_EXT;
        }
        if (tracename.endsWith(TXT_EXT)) {
            return tracename.substring(0, tracename.lastIndexOf(TXT_EXT)) + SLOG2_EXT;
        }
        String prefix_name = TraceName.stripInvalidChar(tracename);
        if (prefix_name.length() > 0) {
            if (prefix_name.endsWith(".")) {
                return prefix_name + SLOG2_EXT.substring(1);
            }
            return prefix_name + SLOG2_EXT;
        }
        return "trace.slog2";
    }
}

