/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import viewer.common.CustomCursor;
import viewer.common.Parameters;
import viewer.zoomable.CoordPixelImage;
import viewer.zoomable.Debug;
import viewer.zoomable.InfoDialog;
import viewer.zoomable.InfoDialogForDuration;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ScrollableObject;
import viewer.zoomable.ScrollableView;
import viewer.zoomable.TimeEvent;
import viewer.zoomable.TimeListener;
import viewer.zoomable.ToolBarStatus;

public class ViewportTime
extends JViewport
implements TimeListener,
ComponentListener,
MouseInputListener,
KeyListener {
    private static final Color INFO_LINE_COLOR = Color.green;
    private static final Color INFO_AREA_COLOR = new Color(255, 255, 0, 64);
    private static final Color ZOOM_LINE_COLOR = Color.white;
    private static final Color ZOOM_AREA_COLOR = new Color(132, 112, 255, 96);
    private static final Color FOCUS_LINE_COLOR = Color.red;
    private Point view_pt;
    private ScrollableView view_img = null;
    private ModelTime time_model = null;
    private ToolBarStatus toolbar = null;
    private TimeBoundingBox vport_timebox = null;
    protected CoordPixelImage coord_xform = null;
    private TimeBoundingBox zoom_timebox = null;
    private TimeBoundingBox info_timebox = null;
    private List info_dialogs;
    private InfoDialogActionListener info_action_listener;
    private InfoDialogWindowListener info_window_listener;
    protected boolean isLeftMouseClick4Zoom;
    private JRadioButton zoom_btn;
    private JRadioButton hand_btn;
    private double mouse_pressed_time;
    private int mouse_pressed_Xloc;
    private int mouse_last_Xloc;
    private boolean hasControlKeyBeenPressed = false;

    public ViewportTime(ModelTime in_model) {
        this.time_model = in_model;
        this.view_pt = new Point(0, 0);
        this.isLeftMouseClick4Zoom = false;
        this.zoom_btn = null;
        this.hand_btn = null;
        this.addComponentListener(this);
        this.vport_timebox = new TimeBoundingBox();
    }

    public void setView(Component view) {
        Dimension pref_sz;
        Dimension max_sz;
        super.setView(view);
        Dimension min_sz = view.getMinimumSize();
        if (min_sz != null) {
            this.setMinimumSize(min_sz);
        }
        if ((max_sz = view.getMaximumSize()) != null) {
            this.setMaximumSize(max_sz);
        }
        if ((pref_sz = view.getPreferredSize()) != null) {
            this.setPreferredSize(pref_sz);
        }
        this.view_img = (ScrollableView)((Object)view);
        this.coord_xform = new CoordPixelImage((ScrollableObject)this.view_img);
        super.addMouseListener(this);
        super.addMouseMotionListener(this);
        super.addKeyListener(this);
        this.info_dialogs = new ArrayList();
        this.info_action_listener = new InfoDialogActionListener(this, this.info_dialogs);
        this.info_window_listener = new InfoDialogWindowListener(this, this.info_dialogs);
    }

    public void setToolBarStatus(ToolBarStatus in_toolbar) {
        this.toolbar = in_toolbar;
    }

    public Dimension getMinimumSize() {
        Dimension min_sz = super.getMinimumSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTime: min_size = " + min_sz);
        }
        return min_sz;
    }

    public Dimension getMaximumSize() {
        Dimension max_sz = super.getMaximumSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTime: max_size = " + max_sz);
        }
        return max_sz;
    }

    public Dimension getPreferredSize() {
        Dimension pref_sz = super.getPreferredSize();
        if (Debug.isActive()) {
            Debug.println("ViewportTime: pref_size = " + pref_sz);
        }
        return pref_sz;
    }

    protected void setYaxisViewPosition(int new_y_view_pos) {
        this.view_pt.y = new_y_view_pos;
    }

    protected int getXaxisViewPosition() {
        return this.view_pt.x;
    }

    public void timeChanged(TimeEvent evt) {
        if (Debug.isActive()) {
            Debug.println("ViewportTime: timeChanged()'s START: ");
            Debug.println("time_evt = " + evt);
        }
        if (this.view_img != null) {
            this.view_img.checkToZoomView();
            this.view_img.checkToScrollView();
            if (Debug.isActive()) {
                Debug.println("ViewportTime:timeChanged()'s view_img = " + this.view_img);
            }
            this.view_pt.x = this.view_img.getXaxisViewPosition();
            super.setViewPosition(this.view_pt);
            this.repaint();
        }
        if (Debug.isActive()) {
            if (this.view_img != null) {
                Debug.println("ViewportTime: view_img.getXaxisViewPosition() = " + this.view_pt.x);
                Debug.println("ViewportTime: [after] getViewPosition() = " + super.getViewPosition());
            }
            Debug.println("ViewportTime: timeChanged()'s END: ");
        }
    }

    public void componentResized(ComponentEvent evt) {
        if (Debug.isActive()) {
            Debug.println("ViewportTime: componentResized()'s START: ");
            Debug.println("comp_evt = " + evt);
        }
        if (this.view_img != null) {
            this.view_img.componentResized(this);
            this.setPreferredSize(this.getSize());
            if (Debug.isActive()) {
                Debug.println("ViewportTime: componentResized()'s view_img = " + this.view_img);
            }
            this.view_pt.x = this.view_img.getXaxisViewPosition();
            super.setViewPosition(this.view_pt);
            this.repaint();
        }
        if (Debug.isActive()) {
            if (this.view_img != null) {
                Debug.println("ViewportTime: view_img.getXaxisViewPosition() = " + this.view_pt.x);
                Debug.println("ViewportTime: [after] getViewPosition() = " + super.getViewPosition());
            }
            Debug.println("ViewportTime: componentResized()'s END: ");
        }
    }

    public void componentMoved(ComponentEvent evt) {
        if (Debug.isActive()) {
            Debug.println("ViewportTime: componentMoved()'s START: ");
            Debug.println("comp_evt = " + evt);
            Debug.println("ViewportTime: componentMoved()'s END: ");
        }
    }

    public void componentHidden(ComponentEvent evt) {
        if (Debug.isActive()) {
            Debug.println("ViewportTime: componentHidden()'s START: ");
            Debug.println("comp_evt = " + evt);
            Debug.println("ViewportTime: componentHidden()'s END: ");
        }
    }

    public void componentShown(ComponentEvent evt) {
        if (Debug.isActive()) {
            Debug.println("ViewportTime: componentShown()'s START: ");
            Debug.println("comp_evt = " + evt);
            Debug.println("ViewportTime: componentShown()'s END: ");
        }
    }

    private void drawShadyTimeBoundingBox(Graphics g, TimeBoundingBox timebox, Color line_color, Color area_color) {
        if (this.vport_timebox.overlaps(timebox)) {
            int x2_pos;
            int x1_pos;
            double line_time = timebox.getEarliestTime();
            if (this.coord_xform.contains(line_time)) {
                x1_pos = this.coord_xform.convertTimeToPixel(line_time);
                g.setColor(line_color);
                g.drawLine(x1_pos, 0, x1_pos, this.getHeight());
            } else {
                x1_pos = 0;
            }
            line_time = timebox.getLatestTime();
            if (this.coord_xform.contains(line_time)) {
                x2_pos = this.coord_xform.convertTimeToPixel(line_time);
                g.setColor(line_color);
                g.drawLine(x2_pos, 0, x2_pos, this.getHeight());
            } else {
                x2_pos = this.getWidth();
            }
            if (x2_pos > x1_pos) {
                g.setColor(area_color);
                g.fillRect(x1_pos + 1, 0, x2_pos - x1_pos - 1, this.getHeight());
            }
        }
    }

    public void paint(Graphics g) {
        int x_pos;
        double focus_time;
        if (Debug.isActive()) {
            Debug.println("ViewportTime: paint()'s START: ");
        }
        super.paint(g);
        this.vport_timebox.setEarliestTime(this.time_model.getTimeViewPosition());
        this.vport_timebox.setLatestFromEarliest(this.time_model.getTimeViewExtent());
        this.coord_xform.resetTimeBounds(this.vport_timebox);
        if (!Parameters.LEFTCLICK_INSTANT_ZOOM && this.coord_xform.contains(focus_time = this.time_model.getTimeZoomFocus())) {
            x_pos = this.coord_xform.convertTimeToPixel(focus_time);
            g.setColor(FOCUS_LINE_COLOR);
            g.drawLine(x_pos, 0, x_pos, this.getHeight());
        }
        if (this.zoom_timebox != null) {
            this.drawShadyTimeBoundingBox(g, this.zoom_timebox, ZOOM_LINE_COLOR, ZOOM_AREA_COLOR);
        }
        if (this.info_timebox != null) {
            this.drawShadyTimeBoundingBox(g, this.info_timebox, INFO_LINE_COLOR, INFO_AREA_COLOR);
        }
        Iterator itr = this.info_dialogs.iterator();
        while (itr.hasNext()) {
            InfoDialog info_popup = (InfoDialog)itr.next();
            if (info_popup instanceof InfoDialogForDuration) {
                InfoDialogForDuration popup = (InfoDialogForDuration)info_popup;
                this.drawShadyTimeBoundingBox(g, popup.getTimeBoundingBox(), INFO_LINE_COLOR, INFO_AREA_COLOR);
                continue;
            }
            double popup_time = info_popup.getClickedTime();
            if (!this.coord_xform.contains(popup_time)) continue;
            x_pos = this.coord_xform.convertTimeToPixel(popup_time);
            g.setColor(INFO_LINE_COLOR);
            g.drawLine(x_pos, 0, x_pos, this.getHeight());
        }
        if (Debug.isActive()) {
            Debug.println("ViewportTime: paint()'s END: ");
        }
    }

    private URL getURL(String filename) {
        return this.getClass().getResource(filename);
    }

    public void initLeftMouseToZoom(boolean in_isLeftMouseClick4Zoom) {
        ImageIcon icon_shaded;
        ImageIcon icon;
        this.isLeftMouseClick4Zoom = in_isLeftMouseClick4Zoom;
        ButtonGroup btn_group = new ButtonGroup();
        URL icon_URL = this.getURL("/images/ZoomBW16.gif");
        if (icon_URL != null) {
            icon = new ImageIcon(icon_URL);
            icon_shaded = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
            this.zoom_btn = new JRadioButton(icon_shaded);
            this.zoom_btn.setSelectedIcon(icon);
            this.zoom_btn.setBorderPainted(true);
        } else {
            this.zoom_btn = new JRadioButton("zoom");
        }
        this.zoom_btn.setToolTipText("Left mouse button click to Zoom");
        this.zoom_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ViewportTime.this.zoom_btn.isSelected()) {
                    ViewportTime.this.isLeftMouseClick4Zoom = true;
                }
            }
        });
        if (this.isLeftMouseClick4Zoom) {
            this.zoom_btn.doClick();
        }
        btn_group.add(this.zoom_btn);
        icon_URL = this.getURL("/images/HandOpen16.gif");
        if (icon_URL != null) {
            icon = new ImageIcon(icon_URL);
            icon_shaded = new ImageIcon(GrayFilter.createDisabledImage(icon.getImage()));
            this.hand_btn = new JRadioButton(icon_shaded);
            this.hand_btn.setSelectedIcon(icon);
            this.hand_btn.setBorderPainted(true);
        } else {
            this.hand_btn = new JRadioButton("hand");
        }
        this.hand_btn.setToolTipText("Left mouse button click to Scroll");
        this.hand_btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (ViewportTime.this.hand_btn.isSelected()) {
                    ViewportTime.this.isLeftMouseClick4Zoom = false;
                }
            }
        });
        if (!this.isLeftMouseClick4Zoom) {
            this.hand_btn.doClick();
        }
        btn_group.add(this.hand_btn);
    }

    public JPanel createLeftMouseModePanel(int boxlayout_mode) {
        JPanel btn_panel = null;
        btn_panel = null;
        if (this.zoom_btn != null && this.hand_btn != null) {
            btn_panel = new JPanel();
            btn_panel.setLayout(new BoxLayout(btn_panel, boxlayout_mode));
            btn_panel.add(this.zoom_btn);
            btn_panel.add(this.hand_btn);
            btn_panel.setBorder(BorderFactory.createEtchedBorder());
        }
        return btn_panel;
    }

    public void setCursor(Cursor new_cursor) {
        if (new_cursor == CustomCursor.Normal) {
            if (this.isLeftMouseClick4Zoom) {
                super.setCursor(CustomCursor.ZoomPlus);
            } else {
                super.setCursor(CustomCursor.HandOpen);
            }
        } else {
            super.setCursor(new_cursor);
        }
    }

    public void mouseMoved(MouseEvent mouse_evt) {
    }

    public void mouseEntered(MouseEvent mouse_evt) {
        super.requestFocus();
        if (this.isLeftMouseClick4Zoom) {
            super.setCursor(CustomCursor.ZoomPlus);
        } else {
            super.setCursor(CustomCursor.HandOpen);
        }
    }

    public void mouseExited(MouseEvent mouse_evt) {
    }

    public void mouseClicked(MouseEvent mouse_evt) {
        if (SwingUtilities.isLeftMouseButton(mouse_evt) && this.isLeftMouseClick4Zoom) {
            Point vport_click = mouse_evt.getPoint();
            double focus_time = this.coord_xform.convertPixelToTime(vport_click.x);
            this.time_model.setTimeZoomFocus(focus_time);
            if (Parameters.LEFTCLICK_INSTANT_ZOOM) {
                if (mouse_evt.isShiftDown()) {
                    this.time_model.zoomOut();
                    super.setCursor(CustomCursor.ZoomMinus);
                } else {
                    this.time_model.zoomIn();
                    super.setCursor(CustomCursor.ZoomPlus);
                }
                super.requestFocus();
                if (this.toolbar != null) {
                    this.toolbar.resetZoomButtons();
                }
            } else {
                this.repaint();
            }
        }
        super.requestFocus();
    }

    public void mousePressed(MouseEvent mouse_evt) {
        if (mouse_evt.isControlDown()) {
            this.hasControlKeyBeenPressed = true;
            return;
        }
        this.vport_timebox.setEarliestTime(this.time_model.getTimeViewPosition());
        this.vport_timebox.setLatestFromEarliest(this.time_model.getTimeViewExtent());
        this.coord_xform.resetTimeBounds(this.vport_timebox);
        Point vport_click = mouse_evt.getPoint();
        double click_time = this.coord_xform.convertPixelToTime(vport_click.x);
        if (SwingUtilities.isLeftMouseButton(mouse_evt)) {
            if (this.isLeftMouseClick4Zoom) {
                this.zoom_timebox = new TimeBoundingBox();
                this.zoom_timebox.setZeroDuration(click_time);
                this.repaint();
                super.setCursor(CustomCursor.ZoomPlus);
            } else {
                super.setCursor(CustomCursor.HandClose);
            }
        } else if (SwingUtilities.isRightMouseButton(mouse_evt)) {
            this.info_timebox = new TimeBoundingBox();
            this.info_timebox.setZeroDuration(click_time);
            this.repaint();
        }
        this.mouse_pressed_time = click_time;
        this.mouse_pressed_Xloc = vport_click.x;
        this.mouse_last_Xloc = vport_click.x;
    }

    public void mouseDragged(MouseEvent mouse_evt) {
        if (mouse_evt.isControlDown() || this.hasControlKeyBeenPressed) {
            this.hasControlKeyBeenPressed = true;
            return;
        }
        if (mouse_evt.isShiftDown() && super.getCursor() == CustomCursor.ZoomMinus) {
            super.setCursor(CustomCursor.ZoomPlus);
        }
        Point vport_click = mouse_evt.getPoint();
        double click_time = this.coord_xform.convertPixelToTime(vport_click.x);
        if (SwingUtilities.isLeftMouseButton(mouse_evt)) {
            if (this.isLeftMouseClick4Zoom) {
                if (this.zoom_timebox != null) {
                    if (click_time > this.mouse_pressed_time) {
                        this.zoom_timebox.setLatestTime(click_time);
                    } else {
                        this.zoom_timebox.setEarliestTime(click_time);
                    }
                    this.repaint();
                }
            } else if (vport_click.x != this.mouse_last_Xloc) {
                this.time_model.scroll(this.mouse_last_Xloc - vport_click.x);
                this.mouse_last_Xloc = vport_click.x;
                super.setCursor(CustomCursor.HandClose);
            }
        } else if (SwingUtilities.isRightMouseButton(mouse_evt)) {
            if (click_time > this.mouse_pressed_time) {
                this.info_timebox.setLatestTime(click_time);
            } else {
                this.info_timebox.setEarliestTime(click_time);
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouse_evt) {
        if (mouse_evt.isControlDown() || this.hasControlKeyBeenPressed) {
            this.hasControlKeyBeenPressed = false;
            return;
        }
        Point vport_click = mouse_evt.getPoint();
        double click_time = this.coord_xform.convertPixelToTime(vport_click.x);
        if (SwingUtilities.isLeftMouseButton(mouse_evt)) {
            if (this.isLeftMouseClick4Zoom) {
                if (this.zoom_timebox != null) {
                    if (click_time > this.mouse_pressed_time) {
                        this.zoom_timebox.setLatestTime(click_time);
                    } else {
                        this.zoom_timebox.setEarliestTime(click_time);
                    }
                    this.repaint();
                    if (Math.abs(vport_click.x - this.mouse_pressed_Xloc) >= Parameters.MIN_WIDTH_TO_DRAG) {
                        this.time_model.zoomRapidly(this.zoom_timebox.getEarliestTime(), this.zoom_timebox.getDuration());
                        double focus_time = (this.zoom_timebox.getEarliestTime() + this.zoom_timebox.getLatestTime()) / 2.0;
                        this.time_model.setTimeZoomFocus(focus_time);
                    }
                    this.zoom_timebox = null;
                    this.repaint();
                    super.setCursor(CustomCursor.ZoomPlus);
                    if (this.toolbar != null) {
                        this.toolbar.resetZoomButtons();
                    }
                }
            } else {
                if (vport_click.x != this.mouse_last_Xloc) {
                    this.time_model.scroll(this.mouse_last_Xloc - vport_click.x);
                    this.mouse_last_Xloc = vport_click.x;
                }
                super.setCursor(CustomCursor.HandOpen);
            }
        } else if (SwingUtilities.isRightMouseButton(mouse_evt)) {
            InfoDialog info_popup;
            if (click_time > this.mouse_pressed_time) {
                this.info_timebox.setLatestTime(click_time);
            } else {
                this.info_timebox.setEarliestTime(click_time);
            }
            ScrollableObject scrollable = (ScrollableObject)this.view_img;
            if (Math.abs(vport_click.x - this.mouse_pressed_Xloc) >= Parameters.MIN_WIDTH_TO_DRAG) {
                Window window = SwingUtilities.windowForComponent(this);
                info_popup = window instanceof Frame ? new InfoDialogForDuration((Frame)window, this.info_timebox, scrollable) : new InfoDialogForDuration((Dialog)window, this.info_timebox, scrollable);
            } else {
                Point view_click = SwingUtilities.convertPoint(this, vport_click, scrollable);
                info_popup = scrollable.getPropertyAt(view_click, this.vport_timebox);
            }
            Point global_click = new Point(vport_click);
            SwingUtilities.convertPointToScreen(global_click, this);
            info_popup.setVisibleAtLocation(global_click);
            info_popup.getCloseButton().addActionListener(this.info_action_listener);
            info_popup.addWindowListener(this.info_window_listener);
            this.info_dialogs.add(info_popup);
            this.info_timebox = null;
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 16 && super.getCursor() == CustomCursor.ZoomMinus) {
            super.setCursor(CustomCursor.ZoomPlus);
        }
    }

    public void keyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 16) {
            if (super.getCursor() == CustomCursor.ZoomPlus) {
                super.setCursor(CustomCursor.ZoomMinus);
            }
        } else if (evt.getKeyCode() == 27 && this.zoom_timebox != null) {
            this.zoom_timebox = null;
            this.repaint();
        }
    }

    public void resetToolBarZoomButtons() {
        if (this.toolbar != null) {
            this.toolbar.resetZoomButtons();
        }
    }

    protected InfoDialog getLastInfoDialog() {
        int info_dialogs_size = this.info_dialogs.size();
        if (info_dialogs_size > 0) {
            return (InfoDialog)this.info_dialogs.get(info_dialogs_size - 1);
        }
        return null;
    }

    private class InfoDialogWindowListener
    extends WindowAdapter {
        private ViewportTime viewport;
        private List info_dialogs;

        public InfoDialogWindowListener(ViewportTime vport, List dialogs) {
            this.viewport = vport;
            this.info_dialogs = dialogs;
        }

        public void windowClosing(WindowEvent evt) {
            Object evt_src = evt.getSource();
            Iterator itr = this.info_dialogs.iterator();
            while (itr.hasNext()) {
                InfoDialog info_popup = (InfoDialog)itr.next();
                if (evt_src != info_popup) continue;
                this.info_dialogs.remove(info_popup);
                info_popup.dispose();
                this.viewport.repaint();
                break;
            }
        }
    }

    private class InfoDialogActionListener
    implements ActionListener {
        private ViewportTime viewport;
        private List info_dialogs;

        public InfoDialogActionListener(ViewportTime vport, List dialogs) {
            this.viewport = vport;
            this.info_dialogs = dialogs;
        }

        public void actionPerformed(ActionEvent evt) {
            Object evt_src = evt.getSource();
            Iterator itr = this.info_dialogs.iterator();
            while (itr.hasNext()) {
                InfoDialog info_popup = (InfoDialog)itr.next();
                if (evt_src != info_popup.getCloseButton()) continue;
                this.info_dialogs.remove(info_popup);
                info_popup.dispose();
                this.viewport.repaint();
                break;
            }
        }
    }
}

