/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import viewer.common.Const;

public class ScaledSlider
extends JSlider {
    private static final Font FONT = Const.FONT;
    private static final int MODEL_MIN = 0;
    private static final int MODEL_MAX = 1000000000;
    private double label_min;
    private double label_max;
    private double ratio_label2model;
    private Font label_font;
    private DecimalFormat label_fmt;
    private MouseEvent simulated_click = null;
    static /* synthetic */ Class class$java$awt$event$MouseListener;

    public ScaledSlider(int orientation) {
        super(orientation, 0, 1000000000, 0);
        super.setBackground(Color.white);
        super.setPaintTrack(true);
        super.setPaintLabels(true);
        super.setPaintTicks(true);
        super.setFont(FONT);
        super.setBorder(BorderFactory.createLoweredBevelBorder());
        this.label_min = 0.0;
        this.label_max = 100.0;
        this.label_font = FONT;
        this.setLabelFormat("###0.0##");
    }

    public void setLabelFormat(String format) {
        if (format != null) {
            this.label_fmt = (DecimalFormat)NumberFormat.getInstance();
            this.label_fmt.applyPattern(format);
        }
    }

    private double getModel2LabelValue(int model_val) {
        return this.ratio_label2model * (double)(model_val - 0) + this.label_min;
    }

    private int getLabel2ModelValue(double label_val) {
        double fmodel_val = (label_val - this.label_min) / this.ratio_label2model + 0.0;
        return (int)Math.round(fmodel_val);
    }

    private double getModel2LabelInterval(int model_intvl) {
        return this.ratio_label2model * (double)model_intvl;
    }

    private int getLabel2ModelInterval(double label_intvl) {
        return (int)Math.round(label_intvl / this.ratio_label2model);
    }

    private static double getMajorTickIntervalLabel(double a_max_label) {
        if (a_max_label < 11.0) {
            return 1.0;
        }
        if (a_max_label < 22.0) {
            return 2.0;
        }
        if (a_max_label < 55.0) {
            return 5.0;
        }
        if (a_max_label < 110.0) {
            return 10.0;
        }
        if (a_max_label < 220.0) {
            return 20.0;
        }
        if (a_max_label < 440.0) {
            return 40.0;
        }
        if (a_max_label < 550.0) {
            return 50.0;
        }
        return 100.0;
    }

    public void setLabelFont(Font font) {
        Dictionary label_table;
        this.label_font = font;
        if (super.getPaintLabels() && (label_table = super.getLabelTable()) != null) {
            Enumeration labels = super.getLabelTable().elements();
            while (labels.hasMoreElements()) {
                JComponent label = (JComponent)labels.nextElement();
                label.setFont(this.label_font);
            }
        }
    }

    private void setDefaultLabelTable() {
        if (this.label_fmt == null || !super.getPaintLabels()) {
            return;
        }
        double label_intvl = ScaledSlider.getMajorTickIntervalLabel(this.label_max);
        int model_intvl = this.getLabel2ModelInterval(label_intvl);
        super.setMajorTickSpacing(model_intvl);
        Hashtable<Integer, JLabel> label_table = new Hashtable<Integer, JLabel>();
        for (int imodel = 0; imodel < 1000000000; imodel += model_intvl) {
            double flabel = this.getModel2LabelValue(imodel);
            JLabel tick_mark = new JLabel(this.label_fmt.format(flabel));
            tick_mark.setFont(this.label_font);
            label_table.put(new Integer(imodel), tick_mark);
        }
        super.setLabelTable(label_table);
    }

    public void setMaxLabel(double a_max_label) {
        this.label_max = a_max_label;
        this.ratio_label2model = (this.label_max - this.label_min) / 1.0E9;
        this.setDefaultLabelTable();
    }

    public void setMaxLabel(int i_max_label) {
        this.setMaxLabel((double)i_max_label);
    }

    public double getMaxLabel() {
        return this.label_max;
    }

    public void setMinLabel(double a_min_label) {
        this.label_min = a_min_label;
        this.ratio_label2model = (this.label_max - this.label_min) / 1.0E9;
        this.setDefaultLabelTable();
    }

    public void setMinLabel(int i_min_label) {
        this.setMinLabel((double)i_min_label);
    }

    public double getMinLabel() {
        return this.label_min;
    }

    public void setValLabel(double a_val_label) {
        double label_value = a_val_label;
        if (label_value > this.label_max) {
            System.err.println("label_value(" + label_value + ") > label_max(" + this.label_max + ")");
            this.setMaxLabel(label_value);
        } else if (label_value < this.label_min) {
            System.err.println("label_value(" + label_value + ") < label_min(" + this.label_min + ")");
            this.setMinLabel(label_value);
        }
        int model_value = this.getLabel2ModelValue(label_value);
        if (model_value > 1000000000) {
            System.err.println("model_value(" + model_value + ") > MODEL_MAX(" + 1000000000 + ")");
        } else if (model_value < 0) {
            System.err.println("model_value(" + model_value + ") < MODEL_MIN(" + 0 + ")");
        }
        super.setValue(model_value);
    }

    public double getValLabel() {
        return this.getModel2LabelValue(super.getValue());
    }

    public void setValLabelFully(double a_val_label) {
        this.setValLabel(a_val_label);
    }

    private void simulateMouseClicked() {
        if (this.simulated_click == null) {
            this.simulated_click = new MouseEvent(this, 500, System.currentTimeMillis(), 0, 5, 5, 1, false);
        }
        MouseListener[] listeners = (MouseListener[])this.getListeners(class$java$awt$event$MouseListener == null ? (class$java$awt$event$MouseListener = ScaledSlider.class$("java.awt.event.MouseListener")) : class$java$awt$event$MouseListener);
        for (int idx = 0; idx < listeners.length; ++idx) {
            MouseListener listener = listeners[idx];
            listener.mousePressed(this.simulated_click);
            listener.mouseReleased(this.simulated_click);
        }
    }

    public void fireStateChanged() {
        super.fireStateChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

