/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import base.drawable.TimeBoundingBox;
import java.awt.Window;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Stack;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.event.EventListenerList;
import viewer.common.Dialogs;
import viewer.common.Parameters;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTimePanel;
import viewer.zoomable.TimeEvent;
import viewer.zoomable.TimeListener;

public class ModelTime
extends DefaultBoundedRangeModel
implements AdjustmentListener {
    private int MAX_SCROLLBAR_PIXELS = 0x40000000;
    private double tGlobal_min;
    private double tGlobal_max;
    private double tGlobal_extent;
    private double tView_init;
    private double tView_extent;
    private double old_tView_init;
    private double tZoom_focus;
    private int iZoom_focus;
    private int iView_width = -1;
    private double iViewPerTime;
    private double iScrollbarPerTime;
    private double tZoomScale = 1.0;
    private double tZoomFactor;
    private double logZoomFactor;
    private ModelTimePanel params_display = null;
    private EventListenerList time_listener_list = new EventListenerList();
    private TimeEvent time_chg_evt = null;
    private Window root_window;
    private JScrollBar scrollbar;
    private Stack zoom_undo_stack = new Stack();
    private Stack zoom_redo_stack = new Stack();
    static /* synthetic */ Class class$viewer$zoomable$TimeListener;

    public ModelTime(Window top_window, double init_global_time, double final_global_time) {
        this.root_window = top_window;
        this.setTimeGlobalMinimum(init_global_time);
        this.setTimeGlobalMaximum(final_global_time);
        this.setTimeZoomFocus();
        this.tZoomFactor = 2.0;
        this.logZoomFactor = Math.log(this.tZoomFactor);
    }

    private void setTimeGlobalMinimum(double init_global_time) {
        this.old_tView_init = this.tGlobal_min = init_global_time;
        this.tView_init = this.tGlobal_min;
    }

    private void setTimeGlobalMaximum(double final_global_time) {
        this.tGlobal_max = final_global_time;
        this.tView_extent = this.tGlobal_extent = this.tGlobal_max - this.tGlobal_min;
        this.iScrollbarPerTime = (double)this.MAX_SCROLLBAR_PIXELS / this.tGlobal_extent;
    }

    private void setTimeViewPosition(double cur_view_init) {
        this.old_tView_init = this.tView_init;
        this.tView_init = cur_view_init < this.tGlobal_min ? this.tGlobal_min : (cur_view_init > this.tGlobal_max - this.tView_extent ? this.tGlobal_max - this.tView_extent : cur_view_init);
    }

    private void setTimeViewExtent(double cur_view_extent) {
        if (cur_view_extent < this.tGlobal_extent) {
            this.tView_extent = cur_view_extent;
            if (this.tView_init > this.tGlobal_max - this.tView_extent) {
                this.old_tView_init = this.tView_init;
                this.tView_init = this.tGlobal_max - this.tView_extent;
            }
        } else {
            this.tView_extent = this.tGlobal_extent;
            this.old_tView_init = this.tView_init;
            this.tView_init = this.tGlobal_min;
        }
    }

    public double getTimeGlobalMinimum() {
        return this.tGlobal_min;
    }

    public double getTimeGlobalMaximum() {
        return this.tGlobal_max;
    }

    public double getTimeViewPosition() {
        return this.tView_init;
    }

    public double getTimeViewExtent() {
        return this.tView_extent;
    }

    public void setViewPixelsPerUnitTime(int width) {
        this.iView_width = width;
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
    }

    public double getViewPixelsPerUnitTime() {
        return this.iViewPerTime;
    }

    public double computeTimeViewExtent(double time_per_pixel) {
        return (double)this.iView_width * time_per_pixel;
    }

    public int getViewportMovingDir() {
        double tView_init_changed = this.tView_init - this.old_tView_init;
        if (tView_init_changed > 0.0) {
            return 1;
        }
        if (tView_init_changed < 0.0) {
            return -1;
        }
        return 0;
    }

    public void setScrollBar(JScrollBar sb) {
        this.scrollbar = sb;
    }

    public void removeScrollBar() {
        this.scrollbar = null;
    }

    public void setParamDisplay(ModelTimePanel tl) {
        this.params_display = tl;
    }

    public void removeParamDisplay(ModelTimePanel tl) {
        this.params_display = null;
    }

    private void updateParamDisplay() {
        if (this.params_display != null) {
            if (this.time_chg_evt == null) {
                this.time_chg_evt = new TimeEvent(this);
            }
            this.params_display.timeChanged(this.time_chg_evt);
            this.params_display.zoomLevelChanged();
        }
    }

    public void addTimeListener(TimeListener tl) {
        this.time_listener_list.add(class$viewer$zoomable$TimeListener == null ? (class$viewer$zoomable$TimeListener = ModelTime.class$("viewer.zoomable.TimeListener")) : class$viewer$zoomable$TimeListener, tl);
    }

    public void removeTimeListener(TimeListener tl) {
        this.time_listener_list.remove(class$viewer$zoomable$TimeListener == null ? (class$viewer$zoomable$TimeListener = ModelTime.class$("viewer.zoomable.TimeListener")) : class$viewer$zoomable$TimeListener, tl);
    }

    protected void fireTimeChanged() {
        Object[] listeners = this.time_listener_list.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$viewer$zoomable$TimeListener == null ? ModelTime.class$("viewer.zoomable.TimeListener") : class$viewer$zoomable$TimeListener)) continue;
            if (this.time_chg_evt == null) {
                this.time_chg_evt = new TimeEvent(this);
            }
            ((TimeListener)listeners[i + 1]).timeChanged(this.time_chg_evt);
        }
    }

    private int time2pixel(double time_coord) {
        return (int)Math.round((time_coord - this.tGlobal_min) * this.iScrollbarPerTime);
    }

    private double pixel2time(int pixel_coord) {
        return (double)pixel_coord / this.iScrollbarPerTime + this.tGlobal_min;
    }

    private int timeRange2pixelRange(double time_range) {
        return (int)Math.round(time_range * this.iScrollbarPerTime);
    }

    private double pixelRange2timeRange(int pixel_range) {
        return (double)pixel_range / this.iScrollbarPerTime;
    }

    public void updatePixelCoords() {
        super.setRangeProperties(this.time2pixel(this.tView_init), this.timeRange2pixelRange(this.tView_extent), this.time2pixel(this.tGlobal_min), this.time2pixel(this.tGlobal_max), super.getValueIsAdjusting());
    }

    public void updateTimeCoords() {
        if (this.iScrollbarPerTime > 0.0) {
            this.tGlobal_min = this.pixel2time(super.getMinimum());
            this.tGlobal_max = this.pixel2time(super.getMaximum());
            this.tGlobal_extent = this.tGlobal_max - this.tGlobal_min;
            this.old_tView_init = this.tView_init;
            this.tView_init = this.pixel2time(super.getValue());
            this.tView_extent = this.pixelRange2timeRange(super.getExtent());
            this.updateParamDisplay();
        }
    }

    public void setTimeZoomFactor(double inTimeZoomFactor) {
        this.tZoomFactor = inTimeZoomFactor;
        this.logZoomFactor = Math.log(this.tZoomFactor);
    }

    public double getTimeZoomFactor() {
        return this.tZoomFactor;
    }

    public void setTimeZoomFocus() {
        this.tZoom_focus = this.tView_init + this.tView_extent / 2.0;
    }

    public void setTimeZoomFocus(double inTimeZoomFocus) {
        this.tZoom_focus = inTimeZoomFocus;
        this.updateParamDisplay();
    }

    public double getTimeZoomFocus() {
        return this.tZoom_focus;
    }

    public int getZoomLevel() {
        return (int)Math.round(Math.log(this.tZoomScale) / this.logZoomFactor);
    }

    private void setScrollBarIncrements() {
        if (this.scrollbar != null) {
            int sb_block_incre = super.getExtent();
            if (sb_block_incre <= 0) {
                Dialogs.error(this.root_window, "You have reached the Zoom limit! Time ScrollBar has 0 BLOCK Increment. Zoom out or risk crashing the viewer.");
                sb_block_incre = 0;
            }
            this.scrollbar.setBlockIncrement(sb_block_incre);
            int sb_unit_incre = this.timeRange2pixelRange(this.tView_extent * (double)Parameters.TIME_SCROLL_UNIT_RATIO);
            if (sb_unit_incre <= 0) {
                Dialogs.error(this.root_window, "You have reached the Zoom limit! Time ScrollBar has 0 UNIT Increment. Zoom out or risk crashing the viewer.");
                sb_unit_incre = 0;
            }
            this.scrollbar.setUnitIncrement(sb_unit_incre);
        }
    }

    public void scroll(double tView_change) {
        this.setTimeViewPosition(this.tView_init + tView_change);
        this.updatePixelCoords();
    }

    public void scroll(int iView_change) {
        double tView_change = (double)iView_change / this.iViewPerTime;
        this.scroll(tView_change);
    }

    public void scroll(int iView_change, boolean isValueAdjusting) {
        this.old_tView_init = this.tView_init;
        double tView_change = (double)iView_change / this.iViewPerTime;
        int iScrollbar_change = this.timeRange2pixelRange(tView_change);
        super.setRangeProperties(super.getValue() + iScrollbar_change, super.getExtent(), super.getMinimum(), super.getMaximum(), isValueAdjusting);
        this.tView_init = this.pixel2time(super.getValue());
        this.updateParamDisplay();
    }

    public void zoomHome() {
        this.tZoomScale = 1.0;
        this.setTimeViewExtent(this.tGlobal_extent);
        this.setTimeViewPosition(this.tGlobal_min);
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
        this.updatePixelCoords();
        this.setScrollBarIncrements();
        this.zoom_undo_stack.clear();
        this.zoom_redo_stack.clear();
    }

    private void updateZoomStack(Stack zoom_stack) {
        TimeBoundingBox vport_timebox = new TimeBoundingBox();
        vport_timebox.setEarliestTime(this.tView_init);
        vport_timebox.setLatestFromEarliest(this.tView_extent);
        zoom_stack.push(vport_timebox);
    }

    public void zoomIn() {
        this.updateZoomStack(this.zoom_undo_stack);
        this.tZoomScale *= this.tZoomFactor;
        double tZoom_center = this.tView_init < this.tZoom_focus && this.tZoom_focus < this.tView_init + this.tView_extent ? this.tZoom_focus : this.tView_init + this.tView_extent / 2.0;
        double tView_ratio = (tZoom_center - this.tView_init) / this.tView_extent;
        this.setTimeViewExtent(this.tView_extent / this.tZoomFactor);
        this.setTimeViewPosition(tZoom_center - this.tView_extent * tView_ratio);
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
        this.updatePixelCoords();
        this.setScrollBarIncrements();
    }

    public void zoomOut() {
        this.updateZoomStack(this.zoom_undo_stack);
        this.tZoomScale /= this.tZoomFactor;
        double tZoom_center = this.tView_init < this.tZoom_focus && this.tZoom_focus < this.tView_init + this.tView_extent ? this.tZoom_focus : this.tView_init + this.tView_extent / 2.0;
        double tView_ratio = (tZoom_center - this.tView_init) / this.tView_extent;
        this.setTimeViewExtent(this.tView_extent * this.tZoomFactor);
        this.setTimeViewPosition(tZoom_center - this.tView_extent * tView_ratio);
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
        this.updatePixelCoords();
        this.setScrollBarIncrements();
    }

    public void zoomRapidly(double new_tView_init, double new_tView_extent) {
        double cur_tZoomScale = this.tView_extent / new_tView_extent;
        this.updateZoomStack(this.zoom_undo_stack);
        this.tZoomScale *= cur_tZoomScale;
        this.setTimeViewExtent(new_tView_extent);
        this.setTimeViewPosition(new_tView_init);
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
        this.updatePixelCoords();
        this.setScrollBarIncrements();
    }

    private void zoomBack(double new_tView_init, double new_tView_extent) {
        double cur_tZoomScale = this.tView_extent / new_tView_extent;
        this.tZoomScale *= cur_tZoomScale;
        this.setTimeViewExtent(new_tView_extent);
        this.setTimeViewPosition(new_tView_init);
        this.iViewPerTime = (double)this.iView_width / this.tView_extent;
        this.updatePixelCoords();
        this.setScrollBarIncrements();
    }

    public void zoomUndo() {
        if (!this.zoom_undo_stack.empty()) {
            this.updateZoomStack(this.zoom_redo_stack);
            TimeBoundingBox vport_timebox = (TimeBoundingBox)this.zoom_undo_stack.pop();
            this.zoomBack(vport_timebox.getEarliestTime(), vport_timebox.getDuration());
            Object var1_1 = null;
        }
    }

    public void zoomRedo() {
        if (!this.zoom_redo_stack.empty()) {
            this.updateZoomStack(this.zoom_undo_stack);
            TimeBoundingBox vport_timebox = (TimeBoundingBox)this.zoom_redo_stack.pop();
            this.zoomBack(vport_timebox.getEarliestTime(), vport_timebox.getDuration());
            Object var1_1 = null;
        }
    }

    public boolean isZoomUndoStackEmpty() {
        return this.zoom_undo_stack.empty();
    }

    public boolean isZoomRedoStackEmpty() {
        return this.zoom_redo_stack.empty();
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (Debug.isActive()) {
            Debug.println("ModelTime: AdjustmentValueChanged()'s START: ");
            Debug.println("adj_evt = " + evt);
        }
        if (Debug.isActive()) {
            Debug.println("ModelTime(before) = " + this.toString());
        }
        this.updateTimeCoords();
        if (Debug.isActive()) {
            Debug.println("ModelTime(after) = " + this.toString());
        }
        this.fireTimeChanged();
        if (Debug.isActive()) {
            Debug.println("ModelTime: AdjustmentValueChanged()'s END: ");
        }
    }

    public String toString() {
        String str_rep = super.toString() + ",  " + "tGlobal_min=" + this.tGlobal_min + ", " + "tGlobal_max=" + this.tGlobal_max + ", " + "tView_init=" + this.tView_init + ", " + "tView_extent=" + this.tView_extent + ", " + "iView_width=" + this.iView_width + ", " + "iViewPerTime=" + this.iViewPerTime + ", " + "iScrollbarPerTime=" + this.iScrollbarPerTime;
        return this.getClass().getName() + "{" + str_rep + "}";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

