/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import viewer.common.Dialogs;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ToolBarStatus;

public class ActionZoomRedo
implements ActionListener {
    private ToolBarStatus toolbar;
    private ModelTime model;

    public ActionZoomRedo(ToolBarStatus in_toolbar, ModelTime in_model) {
        this.toolbar = in_toolbar;
        this.model = in_model;
    }

    public void actionPerformed(ActionEvent event) {
        if (this.model.isZoomRedoStackEmpty()) {
            Window window = SwingUtilities.windowForComponent((JToolBar)((Object)this.toolbar));
            String msg = "Zoom Redo Stack is empty";
            Dialogs.warn(window, msg);
        } else {
            this.model.zoomRedo();
        }
        if (this.toolbar != null) {
            this.toolbar.resetZoomButtons();
        }
        if (Debug.isActive()) {
            Debug.println("Action for Zoom Redo button.");
        }
    }
}

