/*
 * Decompiled with CFR 0.152.
 */
package viewer.zoomable;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import viewer.common.Dialogs;
import viewer.zoomable.Debug;
import viewer.zoomable.ModelTime;
import viewer.zoomable.ToolBarStatus;

public class ActionZoomHome
implements ActionListener {
    private ToolBarStatus toolbar;
    private ModelTime model;
    private int zoomlevel;

    public ActionZoomHome(ToolBarStatus in_toolbar, ModelTime in_model) {
        this.toolbar = in_toolbar;
        this.model = in_model;
        this.zoomlevel = 0;
    }

    public void actionPerformed(ActionEvent event) {
        this.zoomlevel = this.model.getZoomLevel();
        if (this.zoomlevel < 0) {
            Window window = SwingUtilities.windowForComponent((JToolBar)((Object)this.toolbar));
            String msg = "The Current ZoomLevel(" + this.zoomlevel + ") is below " + "the Minimum ZoomLevel(" + 0 + ") " + "already!";
            Dialogs.warn(window, msg);
        } else {
            this.model.zoomHome();
        }
        if (this.toolbar != null) {
            this.toolbar.resetZoomButtons();
        }
        if (Debug.isActive()) {
            Debug.println("Action for Zoom Home button");
        }
    }
}

