/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import viewer.legends.LegendTableModel;

public class OperationBooleanMenu
extends JPopupMenu {
    private static String toggle_selected_icon_path = "/images/checkbox/ToggleSelected.gif";
    private static String enable_selected_icon_path = "/images/checkbox/EnableSelected.gif";
    private static String disable_selected_icon_path = "/images/checkbox/DisableSelected.gif";
    private static String toggle_all_icon_path = "/images/checkbox/ToggleAll.gif";
    private static String enable_all_icon_path = "/images/checkbox/EnableAll.gif";
    private static String disable_all_icon_path = "/images/checkbox/DisableAll.gif";
    private JTable table_view;
    private LegendTableModel table_model;
    private int bool_column;

    public OperationBooleanMenu(JTable in_table, int in_column) {
        this.table_view = in_table;
        this.table_model = (LegendTableModel)this.table_view.getModel();
        this.bool_column = in_column;
        super.setLabel(this.table_model.getColumnName(this.bool_column));
        super.setToolTipText(this.table_model.getColumnToolTip(this.bool_column));
        this.addMenuItems();
    }

    private void addMenuItems() {
        URL icon_URL = null;
        icon_URL = this.getURL(toggle_selected_icon_path);
        ImageIcon icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        JMenuItem menu_item = new JMenuItem("Toggle Selected", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationBooleanMenu.this.toggleSelectedAtColumn(OperationBooleanMenu.this.bool_column);
            }
        });
        super.add(menu_item);
        icon_URL = null;
        icon_URL = this.getURL(enable_selected_icon_path);
        icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        menu_item = new JMenuItem("Enable Selected", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationBooleanMenu.this.setSelectedAtColumn(OperationBooleanMenu.this.bool_column, Boolean.TRUE);
            }
        });
        super.add(menu_item);
        icon_URL = null;
        icon_URL = this.getURL(disable_selected_icon_path);
        icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        menu_item = new JMenuItem("Disable Selected", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationBooleanMenu.this.setSelectedAtColumn(OperationBooleanMenu.this.bool_column, Boolean.FALSE);
            }
        });
        super.add(menu_item);
        icon_URL = null;
        icon_URL = this.getURL(toggle_all_icon_path);
        icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        menu_item = new JMenuItem("Toggle All", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationBooleanMenu.this.toggleAllAtColumn(OperationBooleanMenu.this.bool_column);
            }
        });
        super.add(menu_item);
        icon_URL = null;
        icon_URL = this.getURL(enable_all_icon_path);
        icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        menu_item = new JMenuItem("Enable All", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationBooleanMenu.this.setAllAtColumn(OperationBooleanMenu.this.bool_column, Boolean.TRUE);
            }
        });
        super.add(menu_item);
        icon_URL = null;
        icon_URL = this.getURL(disable_all_icon_path);
        icon = icon_URL != null ? new ImageIcon(icon_URL) : null;
        menu_item = new JMenuItem("Disable All", icon);
        menu_item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                OperationBooleanMenu.this.setAllAtColumn(OperationBooleanMenu.this.bool_column, Boolean.FALSE);
            }
        });
        super.add(menu_item);
    }

    private void toggleSelectedAtColumn(int icolumn) {
        int[] irows = this.table_view.getSelectedRows();
        int irows_length = irows.length;
        for (int idx = 0; idx < irows_length; ++idx) {
            int irow = irows[idx];
            Boolean bval = (Boolean)this.table_model.getValueAt(irow, icolumn);
            if (bval.booleanValue()) {
                this.table_model.setValueAt(Boolean.FALSE, irow, icolumn);
                continue;
            }
            this.table_model.setValueAt(Boolean.TRUE, irow, icolumn);
        }
    }

    private void setSelectedAtColumn(int icolumn, Boolean bval) {
        int[] irows = this.table_view.getSelectedRows();
        int irows_length = irows.length;
        for (int idx = 0; idx < irows_length; ++idx) {
            int irow = irows[idx];
            this.table_model.setValueAt(bval, irow, icolumn);
        }
    }

    private void toggleAllAtColumn(int icolumn) {
        int irows_length = this.table_model.getRowCount();
        for (int irow = 0; irow < irows_length; ++irow) {
            Boolean bval = (Boolean)this.table_model.getValueAt(irow, icolumn);
            if (bval.booleanValue()) {
                this.table_model.setValueAt(Boolean.FALSE, irow, icolumn);
                continue;
            }
            this.table_model.setValueAt(Boolean.TRUE, irow, icolumn);
        }
    }

    private void setAllAtColumn(int icolumn, Boolean bval) {
        int irows_length = this.table_model.getRowCount();
        for (int irow = 0; irow < irows_length; ++irow) {
            this.table_model.setValueAt(bval, irow, icolumn);
        }
    }

    private URL getURL(String filename) {
        return this.getClass().getResource(filename);
    }
}

