/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import base.drawable.Category;
import base.drawable.ColorAlpha;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import logformat.slog2.CategoryMap;
import viewer.legends.CategoryIcon;
import viewer.legends.LegendComparators;

public class LegendTableModel
extends AbstractTableModel {
    public static final int ICON_COLUMN = 0;
    public static final int NAME_COLUMN = 1;
    public static final int VISIBILITY_COLUMN = 2;
    public static final int SEARCHABILITY_COLUMN = 3;
    private static final String[] COLUMN_TITLES = new String[]{"Topo", "Name", "V", "S"};
    private static final String[] COLUMN_TOOLTIPS = new String[]{"Topology/Color", "Category Name", "Visibility", "Searchability"};
    private static final Class[] COLUMN_CLASSES = new Class[]{class$viewer$legends$CategoryIcon == null ? (class$viewer$legends$CategoryIcon = LegendTableModel.class$("viewer.legends.CategoryIcon")) : class$viewer$legends$CategoryIcon, class$java$lang$String == null ? (class$java$lang$String = LegendTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = LegendTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = LegendTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean};
    private static final Color[] COLUMN_TITLE_FORE_COLORS = new Color[]{Color.magenta, Color.pink, Color.green, Color.yellow};
    private static final Color[] COLUMN_TITLE_BACK_COLORS = new Color[]{Color.black, Color.gray, Color.darkGray.darker(), Color.blue.darker()};
    private static final boolean[] COLUMN_TITLE_RAISED_ICONS = new boolean[]{false, false, true, false};
    private static final Object[] COLUMN_SAMPLES = new Object[]{CategoryIcon.BLANK_ICON, "ABCDEFGHIJKLMNOP", Boolean.TRUE, Boolean.TRUE};
    private List objdef_list = null;
    private List icon_list = null;
    static /* synthetic */ Class class$viewer$legends$CategoryIcon;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public LegendTableModel(CategoryMap map) {
        this.objdef_list = new ArrayList(map.values());
        this.sortNormally(LegendComparators.CASE_SENSITIVE_ORDER);
    }

    private void initIconListFromCategoryList() {
        this.icon_list = new ArrayList(this.objdef_list.size());
        Iterator objdefs = this.objdef_list.iterator();
        while (objdefs.hasNext()) {
            Category objdef = (Category)objdefs.next();
            CategoryIcon icon = new CategoryIcon(objdef);
            this.icon_list.add(icon);
        }
    }

    private void sortNormally(Comparator comparator) {
        Collections.sort(this.objdef_list, comparator);
        this.initIconListFromCategoryList();
    }

    private void sortReversely(Comparator comparator) {
        Collections.sort(this.objdef_list, comparator);
        Collections.reverse(this.objdef_list);
        this.initIconListFromCategoryList();
    }

    public void arrangeOrder(Comparator comparator) {
        this.sortNormally(comparator);
        super.fireTableDataChanged();
    }

    public void reverseOrder(Comparator comparator) {
        this.sortReversely(comparator);
        super.fireTableDataChanged();
    }

    public int getRowCount() {
        return this.objdef_list.size();
    }

    public int getColumnCount() {
        return COLUMN_TITLES.length;
    }

    public Class getColumnClass(int icolumn) {
        return COLUMN_CLASSES[icolumn];
    }

    public String getColumnName(int icolumn) {
        return COLUMN_TITLES[icolumn];
    }

    public Color getColumnNameForeground(int icolumn) {
        return COLUMN_TITLE_FORE_COLORS[icolumn];
    }

    public Color getColumnNameBackground(int icolumn) {
        return COLUMN_TITLE_BACK_COLORS[icolumn];
    }

    public boolean isRaisedColumnNameIcon(int icolumn) {
        return COLUMN_TITLE_RAISED_ICONS[icolumn];
    }

    public String getColumnToolTip(int icolumn) {
        return COLUMN_TOOLTIPS[icolumn];
    }

    public Object getColumnTypicalValue(int icolumn) {
        return COLUMN_SAMPLES[icolumn];
    }

    public Object getValueAt(int irow, int icolumn) {
        switch (icolumn) {
            case 0: {
                return this.icon_list.get(irow);
            }
            case 1: {
                Category objdef = (Category)this.objdef_list.get(irow);
                return objdef.getName();
            }
            case 2: {
                Category objdef = (Category)this.objdef_list.get(irow);
                if (objdef.isVisible()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            case 3: {
                Category objdef = (Category)this.objdef_list.get(irow);
                if (objdef.isSearchable()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        }
        System.err.println("LegendTableModel.getValueAt(" + irow + "," + icolumn + ") fails!");
        return null;
    }

    public boolean isCellEditable(int irow, int icolumn) {
        return true;
    }

    public void setValueAt(Object value, int irow, int icolumn) {
        Category objdef = (Category)this.objdef_list.get(irow);
        switch (icolumn) {
            case 0: {
                ColorAlpha color = (ColorAlpha)value;
                objdef.setColor(color);
                CategoryIcon icon = (CategoryIcon)this.icon_list.get(irow);
                icon.setDisplayedColor(color);
                this.fireTableCellUpdated(irow, icolumn);
                break;
            }
            case 1: {
                objdef.setName((String)value);
                this.fireTableCellUpdated(irow, icolumn);
                break;
            }
            case 2: {
                objdef.setVisible((Boolean)value);
                this.fireTableCellUpdated(irow, icolumn);
                break;
            }
            case 3: {
                objdef.setSearchable((Boolean)value);
                this.fireTableCellUpdated(irow, icolumn);
                break;
            }
            default: {
                System.err.print("LegendTableModel.setValueAt(" + irow + "," + icolumn + ") fails!");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

