/*
 * Decompiled with CFR 0.152.
 */
package viewer.common;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;

public class CustomCursor {
    public static Cursor Normal = null;
    public static Cursor Wait = null;
    public static Cursor Hand = null;
    public static Cursor HandOpen = null;
    public static Cursor HandClose = null;
    public static Cursor ZoomPlus = null;
    public static Cursor ZoomMinus = null;
    private static Toolkit toolkit = null;

    private URL getURL(String filename) {
        return this.getClass().getResource("/images/" + filename);
    }

    private Image getBestCursorImage(String filename) {
        URL icon_URL = this.getURL(filename);
        Image img = new ImageIcon(icon_URL).getImage();
        int iwidth = img.getWidth(null);
        int iheight = img.getHeight(null);
        Dimension opt_size = toolkit.getBestCursorSize(iwidth, iheight);
        if (opt_size.width == iwidth && opt_size.height == iheight) {
            return img;
        }
        BufferedImage buf_img = new BufferedImage(opt_size.width, opt_size.height, 2);
        System.out.println(filename + ": (" + iwidth + "," + iheight + ") -> (" + opt_size.width + "," + opt_size.height + ")");
        Graphics2D g2d = buf_img.createGraphics();
        g2d.drawImage(img, 0, 0, null);
        g2d.dispose();
        return buf_img;
    }

    public void initCursors() {
        Normal = Cursor.getPredefinedCursor(0);
        Wait = Cursor.getPredefinedCursor(3);
        Hand = Cursor.getPredefinedCursor(12);
        toolkit = Toolkit.getDefaultToolkit();
        Point pt = new Point(1, 1);
        Image img = this.getBestCursorImage("HandOpenUpLeft25.gif");
        HandOpen = toolkit.createCustomCursor(img, pt, "Hand Open");
        img = this.getBestCursorImage("HandCloseUpLeft25.gif");
        HandClose = toolkit.createCustomCursor(img, pt, "Hand Close");
        img = this.getBestCursorImage("ZoomPlusUpLeft25.gif");
        ZoomPlus = toolkit.createCustomCursor(img, pt, "Zoom Plus");
        img = this.getBestCursorImage("ZoomMinusUpLeft25.gif");
        ZoomMinus = toolkit.createCustomCursor(img, pt, "Zoom Minus");
    }

    static {
        new CustomCursor().initCursors();
    }
}

