/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.input;

import base.drawable.Drawable;
import base.drawable.TimeBoundingBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import logformat.slog2.BufForObjects;
import logformat.slog2.input.BufStub;
import logformat.slog2.input.IteratorOfGroupObjects;
import logformat.slog2.input.TreeNode;

public class TreeFloor
extends TreeMap {
    private short depth;
    private TimeBoundingBox timebounds;
    private boolean isIncreTimeOrdered;

    public TreeFloor(short in_depth, BufForObjects.Order buf4objs_order) {
        super(buf4objs_order);
        this.depth = in_depth;
        this.timebounds = new TimeBoundingBox();
        this.isIncreTimeOrdered = buf4objs_order.isIncreasingIndexOrdered();
    }

    public short getDepth() {
        return this.depth;
    }

    public TimeBoundingBox earliestTimeBounds() {
        if (this.isIncreTimeOrdered) {
            return (TimeBoundingBox)super.firstKey();
        }
        return (TimeBoundingBox)super.lastKey();
    }

    public TimeBoundingBox latestTimeBounds() {
        if (this.isIncreTimeOrdered) {
            return (TimeBoundingBox)super.lastKey();
        }
        return (TimeBoundingBox)super.firstKey();
    }

    public TimeBoundingBox getTimeBounds() {
        this.timebounds.setEarliestTime(this.earliestTimeBounds().getEarliestTime());
        this.timebounds.setLatestTime(this.latestTimeBounds().getLatestTime());
        if (!this.timebounds.isTimeOrdered()) {
            System.out.println("slog2.input.TreeFloor.getTimeBounds() returns wrong " + this.timebounds);
        }
        return this.timebounds;
    }

    public boolean coversBarely(TimeBoundingBox tframe) {
        return this.earliestTimeBounds().contains(tframe.getEarliestTime()) && this.latestTimeBounds().contains(tframe.getLatestTime());
    }

    public boolean covers(TimeBoundingBox tframe) {
        this.getTimeBounds();
        return this.timebounds.covers(tframe);
    }

    public boolean overlaps(TimeBoundingBox tframe) {
        this.getTimeBounds();
        return this.timebounds.overlaps(tframe);
    }

    public boolean disjoints(TimeBoundingBox tframe) {
        this.getTimeBounds();
        return this.timebounds.disjoints(tframe);
    }

    public void pruneToBarelyCovering(TimeBoundingBox tframe) {
        if (this.covers(tframe)) {
            double starttime = tframe.getEarliestTime();
            double finaltime = tframe.getLatestTime();
            while (!this.coversBarely(tframe)) {
                if (!this.earliestTimeBounds().contains(starttime)) {
                    super.remove(super.firstKey());
                }
                if (this.latestTimeBounds().contains(finaltime)) continue;
                super.remove(super.lastKey());
            }
        }
    }

    public Iterator iteratorOfDrawables(TimeBoundingBox tframe, Drawable.Order dobj_order, boolean isComposite, boolean isNestable) {
        return new ItrOfDrawables(tframe, dobj_order, isComposite, isNestable);
    }

    public Iterator iteratorOfShadows(TimeBoundingBox tframe, Drawable.Order dobj_order, boolean isNestable) {
        return new ItrOfShadows(tframe, dobj_order, isNestable);
    }

    public String toStubString() {
        StringBuffer rep = new StringBuffer();
        Iterator itr = this.keySet().iterator();
        while (itr.hasNext()) {
            BufStub nodestub = new BufStub((BufForObjects)itr.next());
            rep.append(nodestub.toString() + "\n");
        }
        return rep.toString();
    }

    public String toString() {
        StringBuffer rep = new StringBuffer();
        Iterator itr = this.values().iterator();
        while (itr.hasNext()) {
            rep.append(itr.next().toString() + "\n");
        }
        return rep.toString();
    }

    private class ItrOfShadows
    extends IteratorOfGroupObjects {
        private Drawable.Order dobj_order;
        private boolean isNestable;
        private ListIterator nodes_itr;
        private boolean isSameDir;

        public ItrOfShadows(TimeBoundingBox tframe, Drawable.Order in_dobj_order, boolean in_isNestable) {
            super(tframe);
            this.dobj_order = in_dobj_order;
            this.isNestable = in_isNestable;
            this.isSameDir = this.dobj_order.isIncreasingTimeOrdered() == TreeFloor.this.isIncreTimeOrdered;
            ArrayList nodes = new ArrayList(TreeFloor.super.values());
            this.nodes_itr = this.isSameDir ? nodes.listIterator(0) : nodes.listIterator(nodes.size());
            super.setObjGrpItr(this.nextObjGrpItr(tframe));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox tframe) {
            if (this.isSameDir) {
                while (this.nodes_itr.hasNext()) {
                    TreeNode node = (TreeNode)this.nodes_itr.next();
                    if (!node.overlaps(tframe)) continue;
                    return node.iteratorOfShadows(tframe, this.dobj_order, this.isNestable);
                }
            } else {
                while (this.nodes_itr.hasPrevious()) {
                    TreeNode node = (TreeNode)this.nodes_itr.previous();
                    if (!node.overlaps(tframe)) continue;
                    return node.iteratorOfShadows(tframe, this.dobj_order, this.isNestable);
                }
            }
            return null;
        }
    }

    private class ItrOfDrawables
    extends IteratorOfGroupObjects {
        private Drawable.Order dobj_order;
        private boolean isComposite;
        private boolean isNestable;
        private ListIterator nodes_itr;
        private boolean isSameDir;

        public ItrOfDrawables(TimeBoundingBox tframe, Drawable.Order in_dobj_order, boolean in_isComposite, boolean in_isNestable) {
            super(tframe);
            this.dobj_order = in_dobj_order;
            this.isNestable = in_isNestable;
            this.isComposite = in_isComposite;
            this.isSameDir = this.dobj_order.isIncreasingTimeOrdered() == TreeFloor.this.isIncreTimeOrdered;
            ArrayList nodes = new ArrayList(TreeFloor.super.values());
            this.nodes_itr = this.isSameDir ? nodes.listIterator(0) : nodes.listIterator(nodes.size());
            super.setObjGrpItr(this.nextObjGrpItr(tframe));
        }

        protected Iterator nextObjGrpItr(TimeBoundingBox tframe) {
            if (this.isSameDir) {
                while (this.nodes_itr.hasNext()) {
                    TreeNode node = (TreeNode)this.nodes_itr.next();
                    if (!node.overlaps(tframe)) continue;
                    return node.iteratorOfDrawables(tframe, this.dobj_order, this.isComposite, this.isNestable);
                }
            } else {
                while (this.nodes_itr.hasPrevious()) {
                    TreeNode node = (TreeNode)this.nodes_itr.previous();
                    if (!node.overlaps(tframe)) continue;
                    return node.iteratorOfDrawables(tframe, this.dobj_order, this.isComposite, this.isNestable);
                }
            }
            return null;
        }
    }
}

