/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2;

import base.io.DataIO;
import base.io.MixedDataIO;
import base.io.MixedDataInput;
import base.io.MixedDataOutput;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import logformat.slog2.TreeDirValue;
import logformat.slog2.TreeNodeID;

public class TreeDir
extends TreeMap
implements DataIO,
MixedDataIO {
    private TreeNodeID root = new TreeNodeID(0, 0);

    public TreeDir() {
        super(TreeNodeID.INCRE_INDEX_ORDER);
    }

    public TreeNodeID getTreeRootID() {
        return this.root;
    }

    public void put(TreeNodeID ID, TreeDirValue entry_val) {
        super.put(ID, entry_val);
        if (ID.isPossibleRoot() && ID.depth > this.root.depth) {
            this.root = new TreeNodeID(ID);
        }
    }

    public TreeDirValue get(TreeNodeID ID) {
        return (TreeDirValue)super.get(ID);
    }

    public void writeObject(DataOutput outs) throws IOException {
        outs.writeInt(super.size());
        Iterator entries = this.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            TreeNodeID ID = (TreeNodeID)entry.getKey();
            TreeDirValue val = (TreeDirValue)entry.getValue();
            ID.writeObject(outs);
            val.writeObject(outs);
        }
    }

    public void writeObject(MixedDataOutput outs) throws IOException {
        this.writeObject((DataOutput)outs);
    }

    public TreeDir(DataInput ins) throws IOException {
        this();
        this.readObject(ins);
    }

    public void readObject(DataInput ins) throws IOException {
        int Nentries = ins.readInt();
        for (int idx = 0; idx < Nentries; ++idx) {
            TreeNodeID ID = new TreeNodeID(ins);
            TreeDirValue val = new TreeDirValue(ins);
            this.put(ID, val);
        }
    }

    public void readObject(MixedDataInput ins) throws IOException {
        this.readObject((DataInput)ins);
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("\t SLOG-2 Tree Directory\n");
        Iterator entries = this.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            TreeNodeID ID = (TreeNodeID)entry.getKey();
            TreeDirValue val = (TreeDirValue)entry.getValue();
            rep.append(ID + " -> " + val + "\n");
        }
        return rep.toString();
    }
}

