/**
 * $Id: estutil.h,v 1.9 2006/04/22 18:46:22 shinh Exp $
 *
 * Copyright (C) shinichiro.h <hamaji@nii.ac.jp>
 *  http://shinh.skr.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

/**
 * The present copyright holders of this program have given permission,
 * as a special exception, to link this program with Apache Portable
 * Runtime (APR) and to include header files for APR components when
 * those header files are covered by the Apache licenses, as long as
 * the GNU GPL is followed for this program in all other ways. 
 */

#ifndef estutil_h_
#define estutil_h_

#include <estraier.h>

/* create a document object from HTML */
ESTDOC *est_doc_new_from_html(const char *buf, int size,
                              const char *charset, int plang, int bcheck);

ESTDOC *est_doc_new_from_text(const char *buf, int size,
                              const char *penc, int plang, int bcheck);

ESTDOC *est_doc_new_with_xcmd(const char *buf, int size, const char *uri,
                              const char *xcmd, const char *tmpdir,
                              const char *penc, int plang);

#endif // ! estutil_h_

