
/*
 * LaTeX Symbols Selector
 *
 * Copyright (C) 2006 Tomasz Mka <pasp@users.sourceforge.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _PREFS_H
#define _PREFS_H

#include <gtk/gtk.h>

#define CONFIG_DIRNAME      ".clay"
#define CONFIG_FILENAME     "lss.xml"
#define CONFIG_NAME         "lss_config"

struct lss_prefs
{
    gint        window_x;
    gint        window_y;
    gint        window_size_x;
    gint        window_size_y;
    gint        current_group;
    gint        single_click;
    gint        display_symbol_name;
    gint        enable_ams_symbols;
    gint        send_to_gvim;
    gint        send_to_clipboard;
};

extern  struct lss_prefs        config;

void    prefs_read_config       (void);
void    prefs_write_config      (void);

#endif /* _PREFS_H */

