# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import gtk, gobject
import urllib, re

import utils, config, stock, const

from song import sType
from helper import helper

from web_threading import WebFetchThread
from widget.webinfo.webtemplate import get_template
from widget.mozembed_wrap import MozClient

WIKI_HOTE = "%s.wikipedia.org"
WIKI_URL = WIKI_HOTE+"/wiki/"
WIKI_URL = WIKI_HOTE+"/wiki/Special:Search/"

class WikiBox(gtk.VBox):
    def __init__(self,player):
        gtk.VBox.__init__(self,False,6)
        player.connect("new-song",self.new_media_cb)

        self.last_action = "artist"
        self.song = None

        
        self.embed = MozClient()
        self.embed.connect("open-uri",self.link_uri_cb)

        self.btn_forward = self.make_btn(gtk.STOCK_GO_FORWARD,"forward")
        utils.set_tip(self.btn_forward,_("Forward"))
        self.btn_back = self.make_btn(gtk.STOCK_GO_BACK,"back")
        utils.set_tip(self.btn_back,_("Back"))
        self.btn_artist = self.make_btn(stock.WIKI_USERS,"artist",_("Artist"))
        self.btn_artist.set_active(True)
        self.btn_album = self.make_btn(stock.WIKI_CD,"album",_("Album"),self.btn_artist)
        self.btn_title = self.make_btn(gtk.STOCK_DIALOG_INFO,"title",_("Song")+"   ",self.btn_artist)

        self.btn_browser = gtk.Button()
        self.btn_browser.add(gtk.image_new_from_icon_name("stock_internet", gtk.ICON_SIZE_LARGE_TOOLBAR))
        self.btn_browser.connect("clicked",self.open_in_browser)
        utils.set_tip(self.btn_browser,_("See in web browser"))

        model = gtk.ListStore(gobject.TYPE_STRING)

        self.dropdown_lang = gtk.combo_box_new_text()
        langs = ["en","fr","de","es","it","nl","sv","pl","pt"]
        for lang in langs:
            if lang == config.get("setting","wikipedia"):
                active = langs.index(lang)
                self.lang=lang
            self.dropdown_lang.append_text(lang)

        self.dropdown_lang.set_active(active)
        self.dropdown_lang.connect("changed",self.on_change_lang)
        utils.set_tip(self.dropdown_lang,_("Change wikipedia language"))


        hbox = gtk.HBox(False,6)

        hbox.pack_start(self.btn_artist,False,False)
        hbox.pack_start(self.btn_album,False,False)
        hbox.pack_start(self.btn_title,True,True)
        hbox.pack_start(self.btn_browser,False,False)
        hbox.pack_start(self.btn_back,False,False)
        hbox.pack_start(self.btn_forward,False,False)
        hbox.pack_start(self.dropdown_lang,False,False)

        self.pack_start(hbox,False,False)

        f = gtk.Frame()
        f.add(self.embed)
        self.pack_start(f)
        self.embed.show_all()
        self.site_cache={}
        
        self.current_url = None
        self.go_back_url = []
        self.go_forward_url = []
        
        self.update_btn_status()
        
        helper.connect("show-wikipedia",self.helper_cb)
        
        self.download_thread = WebFetchThread(1024,self.fail_fetch)
        #self.download_thread.dbg = True

    def fail_fetch(self):
        HTML = get_template()%("<h3>"+_("Failed to retreive data")+"</h3>")
        self.render_data(HTML)
        
    def link_uri_cb(self,w,uri):
        if uri.find("wikipedia.org")!=-1 or uri.find("wikimedia.org")!=-1:
            if self.current_url:
                self.go_back_url.append(self.current_url)
            self.go_forward_url = []
            self.download_uri(uri)
        else:
            utils.website(uri);
        return True
        
    def download_uri(self,uri):
        print "D:WikiBox:open",uri
        self.download_thread.fetch_url(uri,self.render_data,True)
        self.current_url = uri
        
        
    def render_data(self,html,prepare_data=False):
        if not isinstance(html,str) and not isinstance(html,unicode):
            html = html.read()
        if prepare_data:
            html = self.prepare_html(html)
        self.embed.set_data(self.current_url,html)
        gobject.idle_add(self.update_btn_status)
            
        
    def open_in_browser(self,btn=None):
        if self.current_url:
            utils.website(self.current_url);


    def on_change_lang(self,widget):
        self.lang = self.dropdown_lang.get_active_text()
        config.set("setting","wikipedia",self.lang)
        self.fetch_information(None,self.last_action)
        
    def helper_cb(self,helper,action,song):
        self.set_action(action)
        self.new_media_cb(None,song)
        
    def set_action(self,action):
        #FIXME: replace by block/unblock signal
        if action=="artist":
            self.btn_artist.connect("clicked",lambda x: None)
            self.btn_artist.clicked()
            self.btn_artist.connect("clicked",self.fetch_information,action)
        if action=="album":
            self.btn_album.connect("clicked",lambda x: None)
            self.btn_album.clicked()
            self.btn_album.connect("clicked",self.fetch_information,action)
        if action=="title":
            self.btn_title.connect("clicked",lambda x: None)
            self.btn_title.clicked()
            self.btn_title.connect("clicked",self.fetch_information,action)


    def make_btn(self,stocks,action,label=None,btn=None):
        if label==None:
           btn = gtk.Button()
           image = gtk.image_new_from_stock(stocks, gtk.ICON_SIZE_BUTTON)
           btn.add(image)
        else:
           btn = gtk.RadioButton(group=btn)
           image = gtk.image_new_from_stock(stocks, gtk.ICON_SIZE_BUTTON)
           label = gtk.Label(label)
           label.set_alignment(0,0.5)
           box = gtk.HBox(False,6)
           box.pack_start(image,False,False)
           box.pack_start(label,True,True)
           btn.add(box)

        btn.connect("clicked",self.fetch_information,action)
        return btn

    def new_media_cb(self,widget,song):
        if song==None or config.get("source", "wikipedia")!="1" :
            return

        self.song = song

        if config.get("setting","offline") == "true" :
            HTML = get_template()%("<h3>"+_("Offline mode")+"</h3>")
            self.render_data(HTML)
            return

        if song.get_type() not in sType.wikipedia:
            HTML = get_template()%("<h3>"+_("Wikipedia not available for this media type")+"</h3>")
            self.render_data(HTML)
            return

        self.fetch_information(None,self.last_action)

    def update_btn_status(self):
        if len(self.go_back_url)!=0:
            self.btn_back.set_sensitive(True)
        else:
            self.btn_back.set_sensitive(False)
        if len(self.go_forward_url)!=0:
            self.btn_forward.set_sensitive(True)
        else:
            self.btn_forward.set_sensitive(False)

    def fetch_information(self,btn,action):

        if action in ["artist","album","title"]:
            self.last_action=action
            if self.song==None:
                return
            url = "http://"+(WIKI_URL%self.lang)+urllib.quote(utils.filter_info_song(self.song.get_str(action)).encode("utf-8"))
            if str(url) == str(self.current_url):
                return
            if self.current_url:
                self.go_back_url.append(self.current_url)
            self.go_forward_url = []
            
            self.download_uri(url)

        elif action=="back":
            url = self.go_back_url.pop()
            if self.current_url:
                self.go_forward_url.append(self.current_url)
            self.download_uri(url)

        elif action=="forward":
            url = self.go_forward_url.pop()
            if self.current_url:
                self.go_back_url.append(self.current_url)
            self.download_uri(url)
            
        while len(self.go_back_url)>const.WIKIPEDIA_HISTORY_LEN:
            self.go_back_url.pop(0)
        while len(self.go_forward_url)>const.WIKIPEDIA_HISTORY_LEN:
            self.go_forward_url.pop(0)
        self.update_btn_status()

        
        

    def prepare_html(self,html):
        
        # New template by AqD - aquila_deus
        html = re.sub("id='p-navigation'","style=\"display:none\"",html)
        html = re.sub("id=\"p-[a-z]*\"","style=\"display:none\"",html)
        html = re.sub("id=\"siteNotice*\"","style=\"display:none\"",html)
        html = re.sub("id=\"footer*\"","style=\"display:none\"",html)
        html = re.sub("id=\"content*\"","id=\"content*\" style=\"margin-left: 0.5em; margin-right: 0.5em\"",html)
        return html

        html = html[html.find("<body"):html.find("</body>")]
        #html = re.sub('<(.*)>', "", html)
        html = re.sub("class=\"(.[^>]*)\"","",html)
        html = re.sub("id=\"(.[^>]*)\"","",html)
        html = re.sub("style=\"(.[^>]*)\"","",html)
        #html = re.sub("<input(.[^>]*)>","",html)
        #print html

        html = get_template()%html
        return html
