# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk
import config
import const

class Splash(gtk.Window):
    def __init__(self):
        gtk.Window.__init__(self,gtk.WINDOW_POPUP)
        width = 420
        height = 150

        self.set_decorated(False)
        self.set_position(gtk.WIN_POS_CENTER_ALWAYS)



        import Image
        image = Image.open(const.PIXMAP_DIR+"splash.png")
        IS_RGBA = image.mode=='RGBA'
        pixbuf =  gtk.gdk.pixbuf_new_from_data(
            image.tostring(), # data
            gtk.gdk.COLORSPACE_RGB, # color mode
            IS_RGBA, # has alpha
            8, # bits
            image.size[0], # width
            image.size[1], # height
            (IS_RGBA and 4 or 3) * image.size[0] # rowstride
            )
        pixmap, mask = pixbuf.render_pixmap_and_mask()
        width, height = pixmap.get_size()
        del pixbuf
        self.set_app_paintable(True)
        self.resize(width, height)
        self.realize()

        self.shape_combine_mask(mask, 0, 0)  # make it transparent
        self.window.set_back_pixmap(pixmap, False)
        del pixmap
        self.show_all()

        