# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import sys
import const
from optparse import OptionParser

class ListenOptionParser:
    usage = "usage: %prog [options] [FILE_TO_PLAY ...]"
    def __init__(self):
        
        self.parser = OptionParser(usage=self.usage,version="%prog "+const.VERSION)

        self.parser.add_option("-p","-a","--play",dest="file_to_play",default=None,
                  action="callback", callback=self.vararg_callback,
                  help=_("play files"))
                  
        self.parser.add_option("-q","","--queue",dest="file_to_queue",default=None,
                  action="callback", callback=self.vararg_callback,
                  help=_("queue files in the playlist"))
                  
        self.parser.add_option("--next", action="store_true", dest="next", default=False,
                                help=_("play the next song in the playlist"))
                                
        self.parser.add_option("--previous", action="store_true", dest="previous", default=False,
                                help=_("play the previous song in the playlist"))
                                
        self.parser.add_option("--play-pause", action="store_true", dest="play", default=False,
                                help=_("play or pause current playing media"))
                                
        self.parser.add_option("-c","--current-playing", action="store_true", dest="print_current", default=False,
                                help=_("show current playing song"))
                                
                                
        self.parser.add_option("-v", "--volume", action="store", dest="volume", default=None,
                                help=_("change volume (VOLUME 0.0-1.0)"))
                                
        self.parser.add_option("-d", "--device", action="store", dest="device", default=None,
                                help=_("play a device"))
                                
        self.parser.add_option("--ext-support", action="store_true", dest="print_ext", default=False,
                                help=_("show information about supported audio file"))

        (self.options, self.args) = self.parser.parse_args(sys.argv[1:])
        #remove empty parameter
        self.args = filter(lambda arg: arg and arg.strip(),self.args)
        
    def run_preload(self):  
        if self.options.print_current:
            print _("No playing song")
            sys.exit(0)
            
        if self.options.print_ext:
            import song  
            print song.get_supported_extention()
            sys.exit(0)

    def run_load(self,client):
        ret = None
        
        if self.options.next:
            ret = client.msg_send("control",("next",""))
            
        if self.options.previous:
            ret = client.msg_send("control",("previous",""))
            
        if self.options.print_current:
            ret = client.msg_send("control",("current-song",""))
            
        if self.options.play:
            ret = client.msg_send("control",("play-pause",""))
            
        if self.options.volume!=None:
            ret = client.msg_send("control",("volume",self.options.volume))
            
        if self.options.file_to_play:
            ret = client.msg_send("add",("play",self.convert_args_to_uris_string(self.options.file_to_play)))
            
        if self.options.file_to_queue:
            ret = client.msg_send("add",("queue",self.convert_args_to_uris_string(self.options.file_to_queue)))

        if self.options.device!=None:
            ret = client.msg_send("control",("play-device",self.options.device))
            
        if self.args:
            ret = client.msg_send("add",("play",self.convert_args_to_uris_string(self.args)))
           
        if ret:
            print ret
    
    def convert_args_to_uris_string(self,args):
        import gnomevfs
        uris = []
        for arg in args:
            if arg and arg.strip():
                uris.append(gnomevfs.make_uri_from_shell_arg(arg))
        print uris
        return "<####>".join(uris)
    
    def vararg_callback(self,option, opt_str, value, parser):
        assert value is None
        done = 0
        value = []
        rargs = parser.rargs
        while rargs:
            arg = rargs[0]
        
            # Stop if we hit an arg like "--foo", "-a", "-fx", "--file=f",
            # etc.  Note that this also stops on "-3" or "-3.0", so if
            # your option takes numeric values, you will need to handle
            # this.
            if ((arg[:2] == "--" and len(arg) > 2) or
                (arg[:1] == "-" and len(arg) > 1 and arg[1] != "-")):
                break
            else:
                value.append(arg)
                del rargs[0]

        setattr(parser.values, option.dest, value)
    
