# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###



import gtk
import gobject
import threading
from time import time

import stock
import utils
import config

from helper import helper
from song import Song,sType
from library import SimpleLibrary
from widget.view import MultiDragTreeview
from widget.misc import ScrolledWindow
from widget.song_view import SortableSongView,SongView,PlaylistSongView
from widget.song_menu import SongMenu
from library import library_wrapper
from webradio.shoutcast import ShoutcastBrowser
from widget.dialog import WindowNewRadio

from library import Library,library_wrapper

class RadioWidget(gtk.VBox):
    def __init__(self,pl):
        super(RadioWidget,self).__init__(False,6)   
        
        
        self.favorite_song_view = FavoriteRadioSongView(pl)
        
        #FIXME: POPULATE this array dynamicly with content of webradio/
        browsers = [
                     (_("Favorite"),ScrolledWindow(self.favorite_song_view)),
                     (_("SHOUTcast"),RadioBrowser(ShoutcastBrowser()))
                     ]
        btn_box = gtk.HBox(False,6)
        self.notebook = gtk.Notebook()
        
        btn = None
        page_num = 0
        for browser_name, browser in browsers:
            btn = gtk.RadioButton(btn,browser_name)
            btn.set_mode(False)
            btn.connect("clicked",self.on_click)
            btn.page_num = page_num
            btn_box.pack_start(btn,False,False)
            self.notebook.append_page(browser,gtk.Label(browser_name))
            page_num += 1
            
            
        self.notebook.set_property("show-tabs",False)
        self.notebook.set_property("show-border",False)        
        self.notebook.connect("switch-page",self.on_select_page)
        
        self.pack_start(btn_box,False,False)
        self.pack_start(self.notebook,True,True)
        
        
    def on_click(self,b):
        self.notebook.set_current_page(b.page_num)
        
    def on_select_page(self,notebook,page,page_num):
        if page_num==0: return
        self.notebook.get_nth_page(page_num).fill()
        
    def populate(self):
        self.favorite_song_view.get_model().fill(self.favorite_song_view.pl.get_songs())
        
class FavoriteRadioSongView(SortableSongView):
    show_all_columns = True
    def __init__(self,pl):
        kargs={
                "title":(1,gobject.TYPE_STRING)
                }
        super(FavoriteRadioSongView,self).__init__(pl,"favoriteradio",**kargs)
        
        self.menu = SongMenu(pl,True,True,True,False,False,False,False)
        self.menu.insert_sep(-1)
        self.menu.insert_item(self.edit_radio,stock.EDIT_RADIO,-1)
        self.menu.insert_sep(-1)
        self.menu.insert_item(self.new_radio,stock.NEW_RADIO,-1)
        self.menu.show_all()
        
        self.empty_menu = SongMenu(pl,False,False,False,False,False,False,False)
        self.empty_menu.insert_item(self.new_radio,stock.NEW_RADIO)
        self.empty_menu.show_all()
        
        self.set_menu(self.menu,self.empty_menu)
          
        helper.connect("pl-add-songs",self.append_songs)
        helper.connect("pl-insert-songs",self.insert_songs)
        
        helper.connect("changed",self.get_model().change_songs)
        helper.connect("deleted",self.get_model().remove_songs)
        
    def new_radio(self,w):
        WindowNewRadio()
        
    def edit_radio(self,w):
        model, rows = self.get_selection().get_selected_rows()
        WindowNewRadio(model[rows[0]][0])
        
    def append_songs(self,helper,pl,songs):
        if pl == self.pl:
            self.get_model().append_songs(songs)
        
    def insert_songs(self,helper,pl,songs,pos):
        if pl == self.pl:
            self.get_model().insert_songs(pos,songs)
            
class RadioSongView(SortableSongView):
    show_all_columns = True
    def __init__(self):
        kargs={
                "title":(1,gobject.TYPE_STRING),
                "radio_person":(2,gobject.TYPE_STRING),
                "#bitrate":(3,gobject.TYPE_STRING)
                }
        
        super(RadioSongView,self).__init__(None,"radio",**kargs)
        
        self.menu = SongMenu(None,True,True,False,False,False,False,False)
        self.menu.append_sep()
        self.menu.insert_item(self.add_favorite,stock.ADD_FAVORITE)
        self.menu.show_all()
        self.set_menu(self.menu)  

    def add_favorite(self,w):
        model, rows = self.get_selection().get_selected_rows()
        pl = library_wrapper.get_library("local").get_pl_iradio()
        songs = [Song(model[row][0]) for row in rows ]
        for song in songs:
            song.set_type(sType.LOCAL_WEBRADIO)
        pl.append(songs)
        
        
class RadioBrowser(gtk.HPaned):
    def __init__(self,radio_browser):
        super(RadioBrowser,self).__init__()
        
        self.radio_browser = radio_browser
        
        model_categorie = gtk.ListStore(str,str)
        model_radio = gtk.ListStore(object,str,str,str,str)
        
        self.tree_categorie = gtk.TreeView(model_categorie)
        self.tree_categorie.insert_column_with_attributes(-1,_("Categorie"), gtk.CellRendererText(),text=1)
        
        
        self.library = SimpleLibrary("audiocd")
        
        
        self.tree_radio = RadioSongView()
        
        self.tree_categorie.get_selection().connect("changed",self.on_cat_activated)
        #self.tree_radio.connect("row-activated",self.on_radio_activated)
        
        self.pack1(ScrolledWindow(self.tree_categorie),False,True)
        self.pack2(ScrolledWindow(self.tree_radio),False,True)
        
        self.last_update = 0
        
        self.thread = None
        def on_move_pane(pane,ev):
            config.set("iradio",radio_browser.conf_prefix+"_pos","%d"%pane.get_position())
            return True
        self.connect("motion-notify-event",on_move_pane)
        #self.compute_position(-1,200,250)
        self.set_position(int(config.get("iradio",radio_browser.conf_prefix+"_pos")))
        
    def fill(self):
        if not self.thread:
            self.thread = threading.Thread(target=self.__thread_fill)
            self.thread.setDaemon(True)
            self.thread.start()
        
    def __thread_fill(self):
        cat = self.radio_browser.load()
        gobject.idle_add(self.__thread_fill_cb,cat)
        
    def __thread_fill_cb(self,cat):
        self.thread = None
        model = self.tree_categorie.get_model()
        model.clear()    
        for key ,name in cat:
            model.append((utils.xmlescape(key),utils.xmlescape(name)))
        #self.tree_categorie.get_selection().select_path(0)
        
    def on_cat_activated(self,treeselection):
        model,iter = treeselection.get_selected()
        if iter:
            key = model[iter][0]
            self.last_key = key
            #self.get_toplevel().window.set_cursor(gtk.gdk.Cursor(gtk.gdk.WATCH))
            self.thread = threading.Thread(target=self.radio_browser.get_iradio_songs,args=(key,self.fill_song_view))
            self.thread.setDaemon(True)
            self.thread.start()
        
    def fill_song_view(self,key,iradios):
        if self.last_key == key:
            #self.get_toplevel().window.set_cursor(None)    
            self.library.delete_auto_gen_playlist("shoutcast")
            pl = self.library.auto_gen_playlist("shoutcast",iradios)
            model = self.tree_radio.get_model()
            model.clear()
            model.fill(pl.get_songs())
        