# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###




import gtk
import gobject
import pango
import threading
from time import time,sleep


class ActionProgress(gtk.HBox):
    def __init__(self):
        super(ActionProgress,self).__init__(spacing=6)
        
        self.progress = gtk.ProgressBar()
        self.progress.set_text("")
        self.progress.set_fraction(0)
        self.progress.set_pulse_step(0.1)
        self.progress.set_ellipsize(pango.ELLIPSIZE_START)
        self.progress.set_size_request(-1,22)
        
        self.label = gtk.Label("0 "+_("operation(s) pending"))
        
        btn_cancel= gtk.Button()
        btn_cancel.connect("clicked",self.cancel)
        
        image = gtk.image_new_from_stock(gtk.STOCK_STOP,gtk.icon_size_register("progress",18,18))
        btn_cancel.add(image)
        btn_cancel.set_relief(gtk.RELIEF_NONE)
        btn_cancel.set_size_request(22,22)
        
        self.pack_start(self.label,False,False)
        self.pack_start(self.progress,True,True)
        self.pack_start(btn_cancel,False,False)
        self.show_all()
        self.set_no_show_all(True)
        self.hide()
        self.__cancel = False
        self.__process = False
        
        
        self.condition = threading.Condition()
        
        self.queue = []
        
        self.__id = 0
        self.__ids = []
        
    def cancel(self,w):
        self.__cancel = True
        
    def get_id(self):
        self.__id += 1
        return self.__id
    
    def task_is_finish(self,id):
        return id in self.__ids
    
    def remove_task(self,id):
        for i,item in enumerate(self.queue[:]):
            if item["id"]==id:
                del self.queue[i]
                id = gobject.idle_add(self.update_label)
                return True
        return False
                
        
    def add_queue(self,init_message,iter_func,*args,**kargs):
        id = self.get_id()
        self.queue.append({"id":id,"init_message":init_message,"iter_func":iter_func,"thread":True,"param":args,"cb_func":kargs.get("cb"),"cb_args":kargs.get("cb_args")})
        if len(self.queue)==1 and not self.__process:
            self.process_queue()
        else:
            gobject.idle_add(self.update_label)
        return id
    
    def add_thread_queue(self,init_message,iter_func,*args,**kargs):
        id = self.get_id()
        self.queue.append({"id":id,"init_message":init_message,"iter_func":iter_func,"thread":True,"param":args,"cb_func":kargs.get("cb"),"cb_args":kargs.get("cb_args")})
        if len(self.queue)==1 and not self.__process:
            self.process_queue()
        else:
            gobject.idle_add(self.update_label)
        return id
    
    def __wait_task(self,id):
        while not action_progress.task_is_finish(id):
            sleep(0.01)
            while gtk.events_pending(): gtk.main_iteration()
        return True
    
    def update_label(self):
        if (len(self.queue))>0:
            self.label.set_text("%d "%len(self.queue)+_("operation(s) pending"))
            self.label.show_all()
        else:
            self.label.hide_all()
            
    def process_queue(self):
        if len(self.queue)==0:
            self.__process = False   
            self.update_label() 
            self.finish()
        else:
            self.__process = True    
            action =  self.queue.pop(0)
            self.progress.set_text(action["init_message"])
            self.progress.set_fraction(0)
            self.update_label()
            self.show()
            if not action["thread"]:
                self.run(action)
            else:
                thread = threading.Thread(target = self.run_thread, args=(action,))
                thread.setDaemon(True)
                thread.start()
        
    def run_thread(self,action):
        for text,fraction,pulse in action["iter_func"](*action["param"]):
            gobject.idle_add(self.update_display,text,fraction,pulse)
            if self.__cancel: break
                
        if not action["cb_args"]: action["cb_args"] = tuple()
        if action["cb_func"]:
            gobject.idle_add(action["cb_func"],*action["cb_args"])
        self.__cancel = False
        self.__ids.append(action["id"])
        gobject.idle_add(self.process_queue)
        
    def run(self,action):
        for text,fraction,pulse in action["iter_func"](*action["param"]):
            self.update_display(text,fraction,pulse)
            if self.__cancel: break
            while gtk.events_pending():gtk.main_iteration()
                
        if not action["cb_args"]: action["cb_args"] = tuple()
        if action["cb_func"]:
            action["cb_func"](*action["cb_args"])
        self.__cancel = False
        self.__ids.append(action["id"])
        self.process_queue()
        
    def update_display(self,text,fraction,pulse):
        if pulse:
            """self.progress.set_pulse_step(0.1)"""
            self.progress.pulse()
        else:
            self.progress.set_fraction(fraction)
        if text:
            self.progress.set_text(text)

        
    def __run(self,id,init_message,iter_func,*param):
        print "run",init_message
        self.progress.set_text(init_message)
        self.progress.set_fraction(0)
        self.show()
        while gtk.events_pending():gtk.main_iteration()
        i = 0
        
        for text,fraction,pulse in iter_func(*param):
            i += 1
            if self.__cancel: break
            if pulse:
                self.progress.set_pulse_step(0.1)
                self.progress.pulse()
            else:
                self.progress.set_fraction(fraction)
            if text:
                self.progress.set_text(text)
            self.update_label()
            while gtk.events_pending():gtk.main_iteration()
                
        self.__cancel = False
        self.__ids.append(id)
        self.process_queue()
        
    def finish(self): 
        self.__cancel = False
        self.hide()
        while gtk.events_pending():gtk.main_iteration()
        
action_progress = ActionProgress()





