# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import os, traceback
import gst

import gobject, gtk, gnomevfs
from time import time,sleep
from datetime import datetime

import threading
import urllib
from xml.dom import minidom

try: import gpod
except: pass

import amazon


MUSICBRAINZ = False
try: 
    from musicbrainz2.webservice import WebService, Query, WebServiceError, TrackFilter
except: print "No musicbrainz support (musicbrainz2 missing)"
else:
    try: 
        from tunepimp import tunepimp
        dir(tunepimp.tunepimp).index("setMusicDNSClientId")
    except: print "No musicbrainz support (tunepimp missing or version < 0.5) "
    else: MUSICBRAINZ = True



PLAYLIST_EXTENTION = [".m3u",".pls"]

from helper import helper 
import utils, config, const 

"""
List of album covers that I have already tried
to download on amazon website and which failed
this list is reinitialized every 30min
"""
COVER_TO_SKIP = []
REINIT_COVER_TO_SKIP_TIME = 100*60*30
def reinit_skip_cover():
    COVER_TO_SKIP = []
gobject.timeout_add(REINIT_COVER_TO_SKIP_TIME,reinit_skip_cover)


"""
Mutagen Tag support
"""

from mutagen.apev2 import APEv2File
from mutagen.flac import FLAC
from mutagen.trueaudio import TrueAudio 
from mutagen.oggflac import OggFLAC
from mutagen.oggspeex import OggSpeex
from mutagen.oggtheora import OggTheora
from mutagen.oggvorbis import OggVorbis
from mutagen.musepack import Musepack
try: from mutagen.mp4 import MP4
except: from mutagen.m4a import M4A as MP4
from easymp3 import EasyMP3
 
TAG_KEYS = {
    "title": "title",
    "artist": "artist",
    "album": "album",
    "tracknumber": "#track",
    "genre": "genre",
    "date": "date"
}    
       
EXTENTIONS = {}
EXTENTIONS[".mp3"] = EXTENTIONS[".mp2"] = (EasyMP3,"mad",None)
EXTENTIONS[".ogg"] = (OggVorbis,"vorbis",None)
EXTENTIONS[".oggflac"] = (OggFLAC,"flac",None)
EXTENTIONS[".flac"] = (FLAC,"flac",None)
EXTENTIONS[".spx"] = (OggSpeex,"speex",None)
EXTENTIONS[".tta"] = (TrueAudio,"ttadec",None)
EXTENTIONS[".mpc"] = EXTENTIONS[".mp+"] = (Musepack,"musepack",{"tracknumber":"track","date":"year"})
EXTENTIONS[".mp4"] = \
EXTENTIONS[".m4a"] = (MP4,"faad",{
        "title":"\xa9nam",
        "artist":"\xa9ART",
        "album":"\xa9alb",
        "tracknumber":"trkn",
        "genre":"\xa9gen",
        "date":"\xa9day"
        })
        
VALID_EXTENTIONS = {}
for ext, (Kind, plugin,tag_keys_override) in EXTENTIONS.iteritems():
    if gst.registry_get_default().find_plugin(plugin) is not None:
        VALID_EXTENTIONS[ext]= (Kind, plugin,tag_keys_override)
 

def get_supported_extention():
    string = "File supported: \n"+str(VALID_EXTENTIONS.keys())
    string += "\nMissing Gstreamer plugins for : \n"+str([ext for ext in EXTENTIONS.keys() if ext not in VALID_EXTENTIONS.keys()])
    return string

if const.SHOW_EXT_ON_STARTUP:
    print get_supported_extention()
        

COVER_PIXBUF={}

"""
Class to manage policy between action and song type

"""
class SongType:
    LOCAL_FILE, \
    LOCAL_PODCAST, \
    LOCAL_WEBRADIO, \
    REMOVABLE_FILE, \
    REMOVABLE_PODCAST, \
    REMOVABLE_WEBRADIO, \
    REMOTE_FILE, \
    REMOTE_WEBRADIO, \
    UNKNOWN, \
    AUDIOCD_TRACKS = range(0,10)
    
    def __init__(self):
        self.file_transfert_to = [
                                   self.LOCAL_FILE,
                                   self.REMOVABLE_FILE
                                   ]
        self.file_transfert_from = [
                                   self.LOCAL_PODCAST,
                                   self.LOCAL_WEBRADIO,
                                   self.LOCAL_FILE
                                   ]
        self.podcast_transfert_to = [
                                   self.LOCAL_PODCAST
                                   ]
        self.podcast_transfert_from = []
        self.shoucast_report=[
                               self.LOCAL_FILE,
                               self.REMOVABLE_FILE,
                               self.AUDIOCD_TRACKS
                               ]
        self.podcast=[
                               self.LOCAL_PODCAST,
                               self.REMOVABLE_PODCAST
                               ]
        self.webradio=[
                               self.LOCAL_WEBRADIO,
                               self.REMOVABLE_WEBRADIO,
                               self.REMOTE_WEBRADIO
                               ]
        self.wikipedia = [
                           self.LOCAL_FILE,
                           self.REMOTE_FILE,
                           self.REMOVABLE_FILE,
                           self.AUDIOCD_TRACKS
                           ]
        self.lyrics = [
                           self.LOCAL_FILE,
                           self.REMOTE_FILE,
                           self.REMOVABLE_FILE,
                           self.AUDIOCD_TRACKS
                           ]
        self.lastfm = [
                           self.LOCAL_FILE,
                           self.REMOTE_FILE,
                           self.REMOVABLE_FILE,
                           self.AUDIOCD_TRACKS
                           ]
        self.auto_refresh_tag = [
                               self.LOCAL_WEBRADIO,
                               self.REMOVABLE_WEBRADIO,
                               self.REMOTE_WEBRADIO
                               ]
                               
        self.do_check_exist = [
                           self.LOCAL_FILE
                           ]
                           
        self.disable_cover = [
                               self.LOCAL_WEBRADIO,
                               self.REMOVABLE_WEBRADIO,
                               self.REMOTE_WEBRADIO
                               ]

sType = SongType()
"""
Some note about tag:

For podcast:
    album contains the podcast feed name
    
    
For iradio:
    title contains the radio name
    album contains the web site of the radio
    artist contains the now_playing title

listen tag list: (need to be more clean)

album
artist
#bitrate
category
comment
composer
#ctime
#date
#daterss
description
descriptionrss
#duration
genre
grouping
imagerss
ipod_id
is_m3u
is_pls
#lastplayed
#mtime
#playcount
podcast_feed_title
podcast_local_uri
podcastrss
podcasturl
progress_text
#progress_value
#size
subtitle
tagged
title
#track
uri
uri_to_transfert

"""

SONG_SET_NO_FORMAT = False
BINARY_KEY=["daap_track"]


class Song(dict):
    def __init__(self,iterable=[]):
        self["##song_type##"] = sType.UNKNOWN
        dict.__init__(self,iterable)
        self["tagged"] = False #I thinl is not useful now

    def __getstate__(self):
        odict = {}
        for key,value in self.__dict__.copy():
            if key[0]!="~": odict[key] = value
        return odict

    def get_type(self):
        if self.has_key("##song_type##"):
            return self["##song_type##"]
        else:
            return sType.UNKNOWN
    
    def set_type(self,type):
        self["##song_type##"] = type

    def reinit_key_modified(self):
        self.key_to_update = []
        
    def get_filter(self):
        """self.sprint("genre").strip().lower(),"""

        return " ".join([
                self.get_str("artist").lower(),
                self.get_str("album").lower(),
                self.get_str("title").lower(),
                        ])
    
    def get_str(self,key,xml=False):
        if xml:
            value = dict.get(self,"~~"+key)
        else:
            value = dict.get(self,"~"+key)
        if not value: value = ""
        return value
            
    def get_sortable(self,key):
        if self.has_key("~~~"+key):
            value = dict.get(self,"~~~"+key)
        else:
            value = dict.get(self,key)
        if not value: value = ""
        return value

    def _get_sortable(self,key):
        value = self.get(key)    
        if not value:
            return None
        if key in ["album","genre","artist","title"]:
            value = utils.format_tag(value).lower()
        if key in ["uri"]:
            value = value.lower()
        return value
        
    def __getitem__(self,key):
        if self.has_key(key):
            return dict.__getitem__(self,key)
        else:
            if key=="feed":
                return dict.__getitem__(self,"album")
            if key[:1] == "#" and key!="#track": #len(key)>0 and 
                return 0
            else:
                return None

    def get(self,key):
        return self.__getitem__(key)
    
    def __setitem__(self,key,value):
        if key in ["sort_key_artist","sort_key_title","sort_key_album","sort_key_genre"]: return 
        
        if not key or key[0] == "~": return

        # delete tag used in previous version but actually

        if key == "#track" and value!=None and  not isinstance(value,int) and value.rfind("/")!=-1 and value.strip()!="":
            value = value.strip()
            value = value[:value.rfind("/")]

        if key[0]=="#":
            if (value==None or value=="") and key == "#duration":
                value = "0"
            if value!=None:
                try: value = int(value)
                except:
                    print "Failed set key ",key,"to", value ,"on song",self.get("uri")
                    return
            
        if key == "uri" and utils.get_protocol(value)=="file://":
            dict.__setitem__(self,"path",gnomevfs.get_local_path_from_uri(value))
        elif key == "uri" and self.has_key("path"):
            del self["path"]
            
            

        dict.__setitem__(self,key,value)

        if key in BINARY_KEY: return

        #Key need to reaffect after type change
        if key == "##song_type##" and  value == sType.podcast:
            self["#duration"] = self.get("#duration")

        #Shorcut to don't write special cell renderer
        str_value = value
        if key == "#person" or key == "#max_person":
            self["radio_person"] = "%s/%s"%(self.get_str("#person"),self.get_str("#max_person"))
        elif key=="album":
            self["feed"] = str_value
        elif key=="#duration" and str_value!=None:
            str_value = utils.duration_to_string(str_value)
        elif key=="#duration" and str_value==None and self.get_type() in sType.podcast :
            str_value = _("Not downloaded")
        #elif str_value and (key=="#rssdate" or key=="#date") and self.get_type() in sType.podcast :
        #    str_value = datetime.fromtimestamp(int(str_value)).strftime("%x %X")[:-3]
        elif str_value and key in ["#lastplayed","#rssdate","#date"]:
            str_value = datetime.fromtimestamp(int(str_value)).strftime("%x %X")[:-3]
            if self.get_type() in sType.podcast and key=="#date": 
                self["artist"] = str_value
        elif not str_value and key in ["#lastplayed","#playcount"]:
            str_value = _("Never")
        elif not str_value and (key=="#rssdate" or key=="#date"):
            str_value = _("Unknown")
        elif key == "#bitrate" and str_value!=None:
            str_value = "%dk"%(str_value/1000)
        if not str_value:
            str_value = ""
        if key in ["#person","#max_person"] and not str_value:
            str_value = 0            
        if isinstance(str_value,int):
            str_value = "%d"%str_value
        if key=="uri":
            str_value = gnomevfs.unescape_string_for_display(str_value)
            if not self.get("title"):
                try: filename =  utils.fsdecode(gnomevfs.get_file_info(str(value)).name)
                except: filename = str_value
                dict.__setitem__(self,"~title",filename)
                dict.__setitem__(self,"~~title",utils.xmlescape(filename))

        if key in ["album","genre","artist","title"]:
            str_value = utils.format_tag(str_value)


        sort_value = value
        if key in ["album","genre","artist","title"]:
            sort_value = utils.format_tag(sort_value).lower()
        elif key in ["uri"]:
            sort_value = sort_value.lower()
        if key == "radio_person":
            sort_value = self.get_str("#person")

        # Printable value
        dict.__setitem__(self,"~"+key,str_value)
        # Printable value escaped
        dict.__setitem__(self,"~~"+key,utils.xmlescape(str_value))
        # Sortable value
        if key in ["album","genre","artist","title","uri","radio_person"]:
            dict.__setitem__(self,"~~~"+key,sort_value)



        
    def __delitem__(self,key):
        
        if key == "uri":
            dict.__delitem__(self,"path")    
        #if key in ["album","genre","artist","title"]:
        #    dict.__delitem__(self,"sort_key_"+key)

        dict.__delitem__(self,key) 
        if dict.has_key(self,"~"+key):
            dict.__delitem__(self,"~"+key)
        if dict.has_key(self,"~~"+key):
            dict.__delitem__(self,"~~"+key)
        if dict.has_key(self,"~~~"+key):
            dict.__delitem__(self,"~~~"+key)
            
        
    def __sort_key(self):   
        return(
                self.get_sortable("album"),
                self.get_sortable("#track"),
                self.get_sortable("artist"),
                self.get_sortable("title"),
                self.get_sortable("date"),
                self.get_sortable("#bitrate"),
                self.get_sortable("uri")
                )    
    sort_key = property(__sort_key)
    
    def __browser_sort_key(self):
        return(
                self.get_sortable("album"),
                self.get_sortable("#track"),
                self.get_sortable("artist"),
                self.get_sortable("genre"),
                self.get_sortable("title"),
                self.get_sortable("uri")
                )    
    browser_sort_key = property(__browser_sort_key)

    def __hash__(self):
        return hash(self.get("uri"))


    def __cmp__(self, other):
        if not other: return -1 
        try: return cmp(self.sort_key, other.sort_key)
        except AttributeError: return -1

    def __eq__(self,other):
        try:return self.get("uri")==other.get("uri")
        except:return False

    def exists(self):
        if self.get_type() in sType.do_check_exist:
            return gnomevfs.exists(self.get("uri"))
        else:
            return self.get("uri")
    """""""""""""""""""""
        FILE READER
    """""""""""""""""""""
    """
    Send a copy of song to reading tag thread
    """
    def async_read_from_file(self):
        thread_tag_reader.add_song(Song(self))
        
    def read_from_file(self):
        if self.get_protocol()=="file://" and not self.exists():
            return False
        """if self.type == "iradio" :
            return res"""
        
        if self.get_protocol()=="file://" and VALID_EXTENTIONS.has_key(self.get_ext()):
            return self._read_from_local_file()
        else:
            return self._read_from_remote_file()
          
          
    def _read_from_local_file(self):
        try: 
            
            
            try: fileinfo = gnomevfs.get_file_info(self.get("uri"))
            except: pass
            else:
                for key in ["size","mtime","ctime"]:
                    try: self["#"+key] = getattr(fileinfo,key)
                    except:pass    
                    
            Kind, gst_plugin, tag_keys_override = VALID_EXTENTIONS[self.get_ext()]
            audio = Kind(self.get_path())
                    
            if audio!=None:
                for file_tag,tag in TAG_KEYS.iteritems():
                    
                    if tag_keys_override and tag_keys_override.has_key(file_tag):
                        file_tag = tag_keys_override[file_tag]
                        
                    if audio.has_key(file_tag) and audio[file_tag]:
                        value = audio[file_tag]
            
                        if isinstance(value,list) or isinstance(value,tuple):
                            value = value[0]
                            
                        self[tag] = unicode(value)
            
                self["#duration"] = int(audio.info.length)*1000
                try: self["#bitrate"] = int(audio.info.bitrate)
                except AttributeError: pass
            else:
                raise "w:Song:MutagenTag:No audio found"
                    
        #FIXME: Add a real traceback suppor
        except Exception, e:
            print "W: Error while loading ("+self.get("uri")+")\nTracback :",e
            self.last_error = _("Error while reading")+": "+self.get_filename()
            return False
        else:
            return True
        
    def _read_from_remote_file(self):
        GST_IDS = {
            "title": "title",
            "genre": "genre",
            "artist": "artist",
            "album": "album",
            "bitrate": "#bitrate",
            'track-number':"#track"
        }
        
        is_finalize = False
        is_tagged = False
        def unknown_type(*param):
            raise "W:Song:GstTag:Gst decoder: type inconnu"
        
        def finalize(pipeline):
            state_ret = pipeline.set_state(gst.STATE_NULL)
            if state_ret != gst.STATE_CHANGE_SUCCESS:
                print "Failed change to null"
            is_finalize = True
            #print "finalize"
                
            
        def message(bus,message,pipeline):
            if message.type == gst.MESSAGE_finalize:
                finalize(pipeline)
    
            elif message.type == gst.MESSAGE_TAG:
                taglist = message.parse_tag()
                for key in taglist.keys():
                    if GST_IDS.has_key(key): 
                        if key=="bitrate":
                            value = int(taglist[key]/100)
                        elif isinstance(taglist[key],long):
                            value = int(taglist[key])   
                        else:
                            value = taglist[key]
                        self[IDS[key]] = value
                        #print key,":",value
                self["tagged"] = True
                is_tagged = True
    
            elif message.type == gst.MESSAGE_ERROR:
                err, debug = message.parse_error()
                finalize(pipeline)
                raise "W:Song:GstTag:Decoder error: %s\n%s" % (err,debug)
        try:
            try: pipeline = gst.parse_launch ("gnomevfssrc location="+self.get("uri")+" ! decodebin name=decoder ! fakesink");
            except gobject.GError : 
                raise "W:Song:GstTag:Failed to build pipeline to read metadata of",self.get("uri")
        
            decoder = pipeline.get_by_name("decoder")
            decoder.connect("unknown-type",unknown_type)
            bus = pipeline.get_bus()
            bus.connect('message', message,pipeline)
            bus.add_signal_watch()
            
            state_ret = pipeline.set_state(gst.STATE_PAUSED);
            timeout = 10
            state = None
            while state_ret == gst.STATE_CHANGE_ASYNC and not is_finalize and timeout > 0:
                state_ret,state,pending_state = pipeline.get_state(1 * gst.SECOND);
                timeout -= 1
                
            if state_ret != gst.STATE_CHANGE_SUCCESS:
                finalize(pipeline)
                raise "W:Song:GstTag:Failed change to pausedu"
            else:
                if not is_tagged:
                    bus.poll(gst.MESSAGE_TAG,5 * gst.SECOND)
                try:
                    query = gst.query_new_duration(gst.FORMAT_TIME)
                    if pipeline.query(query):
                        total = query.parse_duration()[1]
                    else: total = 0
                except gst.QueryError: total = 0
                total //= gst.MSECOND
                #print "duration",total
                self["#duration"] = total
                if not self["tagged"]:
                    print "W:Song:GstTag: Media found but no tag found"
                
                finalize(pipeline)

        except Exception, e:
            print "W: Error while loading ("+self.get("uri")+")\nTracback :",e
            self.last_error = _("Error while reading")+": "+self.get_filename()    
            return False
        else: return True

            
    """""""""""""""""""""
        FILE WRITER
    """""""""""""""""""""


    def write_to_file(self):
        if self.get_protocol()!="file://":
            self.last_error = self.get_protocol()+" "+_("Protocol not supported")
            return False
        if not os.path.exists(self.get_path()):
            self.last_error = self.get_filename()+_(" doesn't exist")
            return False
        if not os.access(self.get_path(),os.W_OK):
            self.last_error = self.get_filename()+_(" doesn't have enough permission")
            return False

        if VALID_EXTENTIONS.has_key(self.get_ext()):
            try: 
                Kind, gst_plugin, tag_keys_override = VALID_EXTENTIONS[self.get_ext()]
                audio = Kind(self.get_path())
                        
                if audio!=None:
                    if audio.tags is None: audio.add_tags()    
                    
                    for file_tag,tag in TAG_KEYS.iteritems():
                        
                        if tag_keys_override and tag_keys_override.has_key(file_tag):
                            file_tag = tag_keys_override[file_tag]
                            
                        #FIXME: FOund when tag is a tuple
                        """
                        orig_tag = audio[file_tag]
                        try: del(audio[file_tag])
                        except KeyError:pass
                        value = unicode(self.get(tag))
                        
                        if isinstance(orig_tag, tuple):
                            audio[file_tag] = (int(value), orig_tag[1])
                        else:
                            audio[file_tag] = value
                        """
                        if self.get(tag):
                            value = unicode(self.get(tag))
                            audio[file_tag] = value
                        else:
                            try:del(audio[file_tag])
                            except KeyError:pass
                
                    audio.save()
                else:
                    raise "w:Song:MutagenTag:No audio found"
                    
            #FIXME: Add a real traceback support
            except Exception, e:
                #print traceback.format_exc()
                print "W: Error while writting ("+self.get("uri")+")\nTracback :",e
                self.last_error = _("Error while writting")+": "+self.get_filename()
                return False
            else:
                return True
        
        else:
            self.last_error = self.get_filename()+_(": file formats don't support tag writting")
            return False

    
    
    """""""""""""""""""""""""""
        MUSICBRAINZ READER
    """""""""""""""""""""""""""
    def read_from_musicbrainz(self):
        print "I:Song:Musicbrainz:Fetch metadata of %s" % self.get_filename()

        encoding = 'utf-8'
        tp = tunepimp.tunepimp(const.GETTEXT_APP, const.VERSION , tunepimp.tpThreadAll)
        #| tunepimp.tpThreadLookupPUID | tunepimp.tpThreadLookupFile )
        tp.setMusicDNSClientId('001bd3a391cc704bb97cbdedb33336d5'); 

        tp.addFile( self.get_path() , 0 )

        analyzed = False
        puid = None

        while tp.getNumFiles():
            ret, type, fileId, status = tp.getNotification()
            if not ret:
                continue

            tr = tp.getTrack(fileId)
            tr.lock()
            fileName = tr.getFileName()
            mdata = tr.getLocalMetadata()
            puid = mdata.filePUID
            if len(puid) == 0 : puid = None
                

            tr.unlock()

            fileStatusEnumDict = {
                tunepimp.eMetadataRead      : "eMetadataRead",
                tunepimp.ePending           : "ePending",
                tunepimp.eUnrecognized      : "eUnrecognized",
                tunepimp.eRecognized        : "eRecognized",
                tunepimp.ePUIDLookup         : "ePUIDLookup",
                tunepimp.ePUIDCollision      : "ePUIDCollision",
                tunepimp.eFileLookup        : "eFileLookup",
                tunepimp.eUserSelection     : "eUserSelection",
                tunepimp.eVerified          : "eVerified",
                tunepimp.eSaved             : "eSaved",
                tunepimp.eDeleted           : "eDeleted",
                tunepimp.eError             : "eError",
            }
            #print "Status: ",fileStatusEnumDict[status]

            if status == tunepimp.ePUIDLookup:
                tr.lock()
                puid = tr.getPUID()
                tr.unlock()

            elif status in [tunepimp.eUnrecognized, tunepimp.eRecognized, tunepimp.eSaved]:
                puid = mdata.filePUID
                if not puid or len(puid) == 0 :
                    puid = tr.getPUID()
                if not puid:
                    if not analyzed:
                        tr.lock()
                        tr.setStatus(tunepimp.ePending)
                        tr.unlock()
                        tp.wake(tr)
                        analyzed = True
                    else:
                        print "I:Song:MusicBrainz:Failed get puid of %s" % self.get_filename()
                        tp.releaseTrack(tr)
                        tp.remove(fileId)
                        tr = None

            if tr:
                tp.releaseTrack(tr)
            
            if status == tunepimp.eError:
                print "E:Song:Musicbrainz: %s - %s" % ( self.get_filename() , tp.getError())
                tp.remove(fileId)
                return False


            if puid:
                try:
                    q = Query(WebService())
                    flt = TrackFilter(puid=puid)
                    result = q.getTracks(flt)
                except WebServiceError, e:
                    result = []

                # Use puid check ???
                if len(result) > 0:
                    result = [(result[i].getScore(), result[i]) for i in range(0,len(result)) ]
                    result.sort()
                    track = result[0][1].getTrack()
                    self["title"] = track.getTitle()
                    self["artist"] = track.getArtist().getName()
                
                    # Can do better by asking user the better album
                    releases = track.getReleases()
                    if len(releases) > 0:
                        self["album"] = releases[0].getTitle()
                        self["date"] = releases[0].getEarliestReleaseDate()

                    print "Found on musicbrainz"
                    print "I:Song:Musicbrainz:Ok %s" % self.get_filename()
                else:
                    print "I:Song:Musicbrainz:No files match for %s" % self.get_filename()
                
                tp.remove(fileId)
                return True


    """
    Some filename manipulation
    """
    def get_path(self):
        return self.get("path")

    def get_protocol(self):
        return utils.get_protocol(self.get("uri"))

    def get_ext(self,complete=True):
        return utils.get_ext(self.get("uri"),complete)

    def get_filename(self):
        value = self.get("uri") 
        try:
            return utils.fsdecode(gnomevfs.get_file_info(str(value)).name)
        except:
            """
            FIXME: 
                i don't meet this bug again
                i my memory, i have edit some tag with muzikbrainz and without
                And 3 song have been created without uri filed!!
                And all function that use uri failed
                
                here return value for now and print tag information for debugging
            """
            #print "E:Song:get_filename:gnomevfs.get_file_info failed on ", self
            return value

    """
    Delete album cover from harddisk
    """
    def remove_cover(self):
        image_path = self.get_cover_path()
        if image_path in COVER_TO_SKIP:
            del COVER_TO_SKIP[COVER_TO_SKIP.index(image_path)]
        if os.path.exists(image_path):
            os.unlink(image_path)

    """
    The lyrics filename 
    Use same as quodlibet format
    """
    lyric_uri = property(lambda self: "file://"+utils.fsencode(
        os.path.join(os.path.expanduser("~/.lyrics"),
                     self.get_str("artist").replace('/', '')[:128],
                     self.get_str("title").replace('/', '')[:128] + '.lyric')))

    """
    Update played information
    """
    def update_played_information(self):
        if self.get("#playcount"):
            self["#playcount"] = self.get("#playcount")+1
        else:
            self["#playcount"] = 1
        self["#lastplayed"] = time()
    
    """
    Return the name of the cover file without extention
    """
    def get_cover_search_str(self):
        art = ""
        if not self.get_type() in sType.podcast and self.get_str("artist")!="":
            art=self.get_str("artist")+"+"
        if self.get_str("album")!="":
            art+=self.get_str("album")

        art = art.replace(os.sep,"")
        art = utils.filter_info_song(art).encode('utf-8')
        return art
    
    """
    Return path of the local album art
    It can not exist
    """
    def get_cover_path(self):
        if self.get_type() in sType.disable_cover:
            return const.DEFAULT_COVER
        return const.CONFIG_DIR+"cover/"+self.get_cover_search_str()+".jpg"
    
    def get_cover_pixbuf(self,x,y,try_web=True):
        filename = self.get_cover(try_web)
        if not COVER_PIXBUF.has_key((filename,x,y)) :
            try: pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(filename,x,y)
            except gobject.GError: 
                print "W:Song:get_cover_pixbuf:Failed to load",filename
                pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(const.DEFAULT_COVER,x,y)
            COVER_PIXBUF[(filename,x,y)] = pixbuf
        return COVER_PIXBUF[(filename,x,y)]
        
    """
    Return path of the existing album art to display
    Or default cover if not found
    Must be ONLY use in a thread
    because it use amazon to get cover and if they don't have internet connection listen freeze
    """
    def get_cover(self,try_web=True):

        default_image_path = const.DEFAULT_COVER
        if self.get_type() in sType.disable_cover:
                return default_image_path    
            
        basedir = os.path.dirname(os.path.realpath(__file__))+"/"
        art = self.get_cover_search_str()

        image_path_disable = const.CONFIG_DIR+"cover/"+art+".jpg.#disable#"
        if os.path.exists(image_path_disable):
            return default_image_path

        image_path = const.CONFIG_DIR+"cover/"+art+".jpg"
        if os.path.exists(image_path):
            return image_path
        else:
            if image_path in COVER_TO_SKIP:
                return default_image_path

            """
            search in local directory
            artist.jpg,folder.jpg,album.jpg and same with png
            """
            if self.get("uri")!=None and self.get_protocol()=="file://":
                filename = self.get_path()
                path = filename[:filename.rfind("/")]
                if os.path.exists(path):
                    list_file = os.listdir(path)
                    for f in list_file:
                        #print f.lower()
                        if f.lower() in ["artist.jpg","folder.jpg",".folder.jpg","album.jpg","artist.png","folder.png",".folder.png","album.png","cover.jpg","cover.png"]:
                            try : pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(path+"/"+f,const.COVER_SAVE_SIZE["x"],const.COVER_SAVE_SIZE["y"])
                            except gobject.GError: pass
                            else:
                                if os.path.exists(image_path):
                                    os.unlink(image_path)
                                pixbuf.save(image_path, "jpeg", {"quality":"85"})
                                del pixbuf
                                #print "Local cover found: ",f
                                return image_path
                            
            if config.get("setting","offline") == "true" or not try_web:
                return default_image_path
            else:
                """ retrieve cover from mp3 tag """
                if self.get_protocol() == "file://" and self.get_ext() in [".mp3",".tta"]:
                    from mutagen.id3 import ID3
                    try:
                        f = file(image_path,"wb+")
                        tag = ID3(self.get_path())
                        for frame in tag.getall("APIC"):
                            #print len(frame.data)
                            f.write(frame.data)
                            f.flush()
                            f.seek(0, 0)
                    except:
                        f.close()
                    else:
                        f.close()
                        try: pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(image_path,const.COVER_SAVE_SIZE["x"],const.COVER_SAVE_SIZE["y"])
                        except gobject.GError: 
                            self.remove_cover()
                        else:
                            if os.path.exists(image_path):
                                os.unlink(image_path)
                            pixbuf.save(image_path, "jpeg", {"quality":"85"})
                            del pixbuf
                            return image_path

            if config.get("setting","offline") == "true" or not try_web:
                return default_image_path
            else:
                try:
                    #print "Download a cover"
                    if self.get_type() in sType.podcast:
                        if self.get("imagerss"):
                            res = urllib.urlretrieve(self.get("imagerss"), image_path)
                        else:
                            return default_image_path  
                    else:
                        """ Try Amazon search """
                        if True:
                            amazon.setLicense("0RKH4ZH1JCFZHMND91G2")
                            bags = amazon.searchByKeyword(utils.remove_accents(art),type="lite", product_line="music")
                            res = urllib.urlretrieve(bags[0].ImageUrlLarge, image_path)
                        else:
                            #Lastfm version but not really usable for now
                            lastfm_url = "http://www.last.fm/music/"+urllib.quote(self.get_str("artist").encode("utf-8"))+"/"+urllib.quote(self.get_str("album").encode("utf-8"))
                            fp = urllib.urlopen(lastfm_url)
                            html = fp.read()
                            import re
                            res_exp = re.search("<div class=\"cover\"><a.*?src=\"(.*?)\".*?></a></div>",html,re.S)
                            if res_exp:
                                lastfm_img_url = res_exp.group(1)
                                res = urllib.urlretrieve(lastfm_img_url, image_path)
                            else:
                                return default_image_path
                except:
                    COVER_TO_SKIP.append(image_path)
                    return default_image_path
                else:
                    if res:
                        #Change resolution
                        try: pixbuf = gtk.gdk.pixbuf_new_from_file_at_size(image_path,const.COVER_SAVE_SIZE["x"],const.COVER_SAVE_SIZE["y"])
                        except gobject.GError: 
                            print "W:Song:get_cover:Incorrecte Image Format", image_path
                            return default_image_path
                        else:
                            # Check cover is not a big black 
                            str_pixbuf = pixbuf.get_pixels()
                            if str_pixbuf.count("\x00") > len(str_pixbuf)/2 : 
                                return default_image_path
                            else:
                                if os.path.exists(image_path): os.unlink(image_path)
                                pixbuf.save(image_path, "jpeg", {"quality":"85"})
                                del pixbuf
                            helper.change_songs([self])
                            return image_path
                    else:
                        COVER_TO_SKIP.append(image_path)
                        return default_image_path



class ThreadTagReader:
    def __init__(self):
        
        self.dbg = False
        
        self.queue = []
        
        self.condition = threading.Condition()
        nb_thread = 1
        self.threads = []
        for i in range(0,nb_thread):
            t = threading.Thread(target=self.thread)
            t.setDaemon(True)
            self.threads.append(t)
            
    
    def run(self):
        for t in self.threads:
           t.start()
           
    def add_song(self,song):
        self.condition.acquire()
        self.print_dbg("add_song",song.get("uri"))
        self.queue.append(song)
        self.condition.notify()
        self.condition.release()
    
    def thread(self):
        while True:
            self.condition.acquire()
            while not self.queue:
                self.print_dbg("wait")    
                self.condition.wait()
            song = self.queue.pop(0)
            self.condition.release()
            self.print_dbg("read_from_file:",song.get("uri")) 
            song.read_from_file()
            gobject.idle_add(helper.change_songs,[song])
            self.print_dbg("helper.change_songs:",song.get("uri")) 
       
    def print_dbg(self,*args):
        if self.dbg: print "DBG:ThreadTagReader:",args

thread_tag_reader = ThreadTagReader()
