# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


import gtk, gobject
import os, shutil
import traceback
import gnomevfs
from time import time,sleep

import stock, utils, const, config

from library import *

from transcode import Transcoder,TrancoderError
from widget.progress import action_progress    
from helper import helper
from song import Song,VALID_EXTENTIONS,sType
from widget.dialog import WindowBase


try: import gpod
except : 
  print _("No iPod support")
  pass

class IpodPlaylist(Playlist):
    def __init__(self,library,name,ipod_pl=None):
        if ipod_pl == None:
            self.ipod_pl = gpod.itdb_playlist_new(str(name),False)
        else:
            self.ipod_pl = ipod_pl
        if gpod.itdb_playlist_is_mpl(self.ipod_pl):
            playlist_type = PL_MASTER
        elif gpod.itdb_playlist_is_podcasts(self.ipod_pl):
            playlist_type = PL_PODCAST
        elif self.ipod_pl.is_spl:
            playlist_type = PL_SMART    
        else:
            playlist_type = PL_NORMAL
        Playlist.__init__(self,library,name,playlist_type)
        
    def append(self,songs):
        if self.is_podcast():
            songs_for_pl = [s for s in songs if s.get_type() in sType.podcast_transfert_to and s.get("uri") != s.get("podcasturl")]
        else:
            songs_for_pl = [s for s in songs if s.get_type() in sType.file_transfert_to]
            songs_for_podcast = [s for s in songs if s.get_type() in sType.podcast_transfert_to and s.get("uri") != s.get("podcasturl")]
            self.library.get_pl_podcast().append(songs_for_podcast)
            
        added = Playlist.append(self,songs_for_pl)
        for s in added:
            track = self.library.ipod_track[s.get("uri")]
            gpod.itdb_playlist_add_track(self.ipod_pl, track,-1)
            self.library.sync_ipod()
        return added
            
    def insert(self,songs,init_pos):
        added = Playlist.append(self,songs)
        pos = init_pos
        for s in added:
            track = self.library.ipod_track[s.get("uri")]
            gpod.itdb_playlist_add_track(self.ipod_pl, track,pos)
            self.library.sync_ipod()
            pos += 1
        
        
    def remove_pos(self,positions):
        removed = []
        for pos in positions:
            s = self.library.get_song(self.songs[pos])
            removed.append(s)
            uri = s.get("uri")
            track = self.library.ipod_track[uri]
            del self.songs[pos]
            """
            gpod can't handle track position in playlist
            need delete all track in playlist
            and reinsert the good one
            """
            while gpod.itdb_playlist_contains_track(self.ipod_pl, track):
                gpod.itdb_playlist_remove_track(self.ipod_pl, track)
            
            for apos, u in enumerate(self.songs):
                if u==uri:
                    gpod.itdb_playlist_add_track(self.ipod_pl, track,apos)
            
        if len(removed)>0: helper.pl_remove_songs(self,removed,positions)
        self.library.sync_ipod()
        
    def remove_songs(self,songs):
        removed = Playlist.remove_songs(self,songs)    
        for s in removed:
            track = self.library.ipod_track[s.get("uri")]
            while gpod.itdb_playlist_contains_track(self.ipod_pl, track):
                gpod.itdb_playlist_remove_track(self.ipod_pl, track)
            self.library.sync_ipod()
        
class IpodLibrary(Library):
    itdb = None
    model = _("Unknown iPod")
    firmware = _("Unknown")
    space = ""

    def __init__(self,mount_point,udi):
        Library.__init__(self,"ipod")
        self.udi = udi
        udi_path = udi[udi.rfind("/"):]

        self.mount_point = mount_point
            
        self.db = os.path.join(self.mount_point,"iPod_Control","iTunes","iTunesDB")
        self.sysinfo_path = os.path.join(self.mount_point, 'iPod_Control', 'Device', 'SysInfo')
        self.ipod_track = {}
        
        self.init_ipod_model_info()
        
        self.__song_to_transfer = []
        self.__current_transcode = None
        
        self.id_source_update=None
        self.id_save_task = None
        
        self.tmp_uri_transfert_id = 0
        self.uri_convert = None
        self.__block_sync = False
        
    def block_sync(self):
        self.__block_sync = True
        
    def unblock_sync(self):
        self.__block_sync = False
        
    def sync_ipod(self):
        action_progress.remove_task(self.id_save_task)
        def background_save():
            yield _("Save iPod database..."),1.0,False    
            self.save_db()
        if not self.__block_sync: self.id_save_task = action_progress.add_queue(_("Save iPod database..."),background_save)
        
        
    def load(self):
        mount_point = str(self.mount_point)
        self.itdb = gpod.itdb_parse(mount_point, None)
        if not self.itdb:
            print "Failed to read %s" % self.db
            return self.create_ipod_structure()
        else:
            """ check podcast playlist exsist and create it if not """
            if self.check_ipod_structure():
                return True
            else:
                print "Failed create master and podcast playlist"
    
    @utils.print_timing
    def save_db(self):
        print "Save iPod database..."
        if os.path.exists(self.db):
            #print "Write Shuffle IPOD DB",mount_point
            if gpod.itdb_write(self.itdb, None)==0:
                print "E:Failed to save iPod database (Main)"
                if gpod.itdb_shuffle_write(self.itdb, None)==0:    
                    print "E:Failed to save iPod database (Shuffle)"
        else:
            print "E:Ipod DB file doesn't exists"
        #self.load()
    
    def free(self):
        if gpod.itdb_free(self.itdb)==0:
            print "Failed free ipod db"
            
    def get_song_on_ipod(self,song):
        for s in self.songs.values():
            if s.get("#duration") != song.get("#duration"):
                continue    
            elif s.get("title") != song.get("title"):
                continue
            elif s.get("artist") != song.get("artist"):
                continue
            elif s.get("album") != song.get("album"):
                continue
            else:
                return s
        return None
    
    def background_add(self):
        i = 0
        added = []
        
        print "Song to transfert",len(self.__song_to_transfer)

        while self.__song_to_transfer:
            new_song = self.__song_to_transfer.pop(0)
            i += 1
            uri_to_transfert = new_song.get("uri_to_transfert")
            uri = new_song.get("uri")
            track = self.ipod_track[uri]
            
                
            if utils.get_ext(uri_to_transfert) != ".mp3":
                try:
                    tmp_uri = uri_to_transfert[:uri_to_transfert.rfind("/")+1]+".listen-"+uri_to_transfert[uri_to_transfert.rfind("/")+1:uri_to_transfert.rfind(".")]+".mp3"
                except:
                    try: gnomevfs.unlink("file:///tmp/listentmp.mp3")
                    except: pass
                    tmp_uri = "file:///tmp/listentmp.mp3"
                if not gnomevfs.exists(tmp_uri):
                    self.uri_convert = tmp_uri
                    try:self.__current_transcode = Transcoder(uri_to_transfert,tmp_uri)
                    except TrancoderError:
                        tmp_uri = "file:///tmp/listentmp.mp3"
                        try:self.__current_transcode = Transcoder(uri_to_transfert,tmp_uri)
                        except TrancoderError:    
                            print "E:IpodLibrary:Transcode:Failed transcode ",uri_to_transfert
                            continue
                    
                    while not self.__current_transcode.is_finish():
                        sleep(1)
                        total = len(self.__song_to_transfer)+i
                        yield _("Adding file")+" %d/%d..."%(i,total)+" Encoding... (%d%%)"%self.__current_transcode.get_ratio(),float(i)/float(total),False    
           
                    self.uri_convert = None
            else:
                tmp_uri = uri_to_transfert
                            
            gpod.itdb_cp_track_to_ipod(track,str(gnomevfs.get_local_path_from_uri(tmp_uri)),None)
            
            """pl_to_update = []
            for pl in self.playlists:
                if uri in pl.songs:
                    pos = pl.songs.index(uri)
                    pl_to_update.append((pl,pos))
                    
            helper.delete_songs([new_song])"""
            
            new_uri = "file://"+gpod.itdb_filename_on_ipod(track)
            print "after:"+new_uri
            new_song["uri"] = new_uri
            fileinfo = gnomevfs.get_file_info(new_song.get("uri"))
            new_song["#size"] = fileinfo.size
            if new_song.get("#size") : track.size = long(new_song.get("#size"))
            
            self.songs[new_uri] = new_song
            self.ipod_track[new_uri] = track


            for pl in self.playlists:
                if uri in pl.songs:
                    pos = pl.songs.index(uri)
                    pl.songs[pos] = new_uri
                    
            del self.songs[uri]
            del self.ipod_track[uri]
            
            """for pl,pos in pl_to_update:
                pl.songs.insert(pos,new_uri)
                helper.pl_insert_songs(pl,[new_song],pos)
                    
            added.append(new_song)"""
                
            total = len(self.__song_to_transfer)+i
            yield _("Adding file")+" %d/%d..."%(i,total),float(i)/float(total),False

        """if len(added)>0: helper.add_songs(added)"""
        gobject.idle_add(self.sync_ipod)
        print "Song transfered",i
        
    def background_add_cb(self):
        if self.__current_transcode:
            self.__current_transcode.stop()
        self.__current_transcode = None
        if self.uri_convert:
            try: gnomevfs.unlink(self.uri_convert)
            except: pass
        print "Song not transfered",len(self.__song_to_transfer)
        self.delete_songs(self.__song_to_transfer)
        self.__song_to_transfer = []
        self.sync_ipod()
        
    def add_songs(self,songs):
        
        added = []
        new_songs = []
        for song in songs:
            uri = song.get("uri")
            ipod_song = self.get_song_on_ipod(song)
            if not uri in self.ipod_track.keys() and ipod_song==None:
                new_song = Song(song)
                
                track = song_to_track(new_song)
                track.itdb = self.itdb
        
                gpod.itdb_track_add(self.itdb,track,-1)
                
                #add the new song
                uri = "ipod_tmp_uri://%d"%self.tmp_uri_transfert_id
                new_song = track_to_song(track,uri)
                new_song["uri_to_transfert"] = song.get("uri")
                #uri = new_song.get("uri")
                self.songs[uri] = new_song
                self.ipod_track[uri] = track
                added.append(new_song)
                
                self.tmp_uri_transfert_id += 1
                
            else:
                new_song = ipod_song
                
            if song.get_type()==sType.LOCAL_PODCAST:
                new_song.set_type(sType.REMOVABLE_PODCAST)
            else:
                new_song.set_type(sType.REMOVABLE_FILE)
                
            new_songs.append(new_song)
        
        
            if self.albums_cache!=None:
                self.add_to_cache(new_songs)
                
        print "Song to add",len(added)
        if len(added)>0: 
            helper.add_songs(added)
            if len(self.__song_to_transfer)==0:
                self.__song_to_transfer = added
                action_progress.add_queue("Loading...",self.background_add,cb=self.background_add_cb)
            else:
                self.__song_to_transfer.extend(added)
        
        return new_songs
        
    def delete_songs(self,songs):
        deleted = []    
        for pl in self.playlists:
            pl.remove_songs(songs)
            
        for song in songs:
            uri = song["uri"]
            if self.songs.has_key(uri):
                
                gpod.itdb_track_unlink(self.ipod_track[uri])
                self.sync_ipod()
                try:gnomevfs.unlink(uri)
                except:pass
                del self.songs[uri]
                del self.ipod_track[uri]
                deleted.append(song)
                
                if self.albums_cache!=None:
                    self.remove_from_cache(song) 
                
        if len(deleted)>0: helper.delete_songs(deleted)
        self.check_for_smart_playlist_change(deleted)
        
        return deleted
        
    def add_playlist(self,playlist):
        gpod.itdb_playlist_add(self.itdb,playlist.ipod_pl,-1)
        super(IpodLibrary,self).add_playlist(playlist)   
        self.sync_ipod() 
        
        
    def delete_playlist(self,playlist):
        gpod.itdb_playlist_remove(playlist.ipod_pl)
        super(IpodLibrary,self).delete_playlist(playlist)
        self.sync_ipod()
        
        
    def load_library(self):
        self.block_sync()

        for track in gpod.sw_get_tracks(self.itdb):
            song = track_to_song(track)
            self.ipod_track[song.get("uri")] = track
            self.songs[song.get("uri")] = song
                    
        for playlist in gpod.sw_get_playlists(self.itdb):
            pl = IpodPlaylist(self,playlist.name,playlist)
            pl.codeName = self.codeName
            self.playlists.append(pl)
            for track in gpod.sw_get_playlist_tracks(playlist):
                song = track_to_song(track)
                if song:
                    pl.songs.append(song.get("uri"))
                
        print "----- IPod -----"
        print len(self.songs),"songs and",len(self.playlists),"playlists loaded"
        for pl in self.playlists:
            print len(pl.songs)," in pl ",pl.name
        self.unblock_sync()
           
           
           
    def create_ipod_structure(self):
        itdb = gpod.itdb_new()
        db_dir = self.mount_point+"/iPod_Control/iTunes/"
        ipod_name = _("Unamed Ipod")
        if not os.path.exists(db_dir):
            os.makedirs(db_dir)
        if not os.path.exists(self.mount_point+"/iPod_Control/Artwork"):
            os.makedirs(self.mount_point+"/iPod_Control/Artwork")
        if not os.path.exists(self.mount_point+"/iPod_Control/Device"):
            os.makedirs(self.mount_point+"/iPod_Control/Device")
        for dir_number in range(0,20):
            if not os.path.exists(self.mount_point+"/iPod_Control/Music/F%02d"%dir_number):
                os.makedirs(self.mount_point+"/iPod_Control/Music/F%02d"%dir_number)

        m = str(self.mount_point)
        gpod.itdb_set_mountpoint(itdb,m)
        itdb.usertype
        self.check_ipod_structure(itdb,ipod_name,False)
        gpod.itdb_write_file(itdb,str(db_dir+"iTunesDB"),None)
        gpod.itdb_shuffle_write_file(itdb,str(db_dir+"iTunesSD"),None)
        self.load()
        return True           
           
    def check_ipod_structure(self,itdb=None,ipod_name="iPod",check_exists=True):
        if itdb == None: itdb = self.itdb
        #Create main and podcast playlist
        if check_exists:
            mpl = gpod.itdb_playlist_mpl(itdb)
            ppl = gpod.itdb_playlist_podcasts(itdb)
        else:
            mpl = None
            ppl = None
        if mpl==None:
            mpl = gpod.itdb_playlist_new(str(ipod_name),False)
            gpod.itdb_playlist_set_mpl(mpl)
            gpod.itdb_playlist_add(itdb,mpl,0)
        if ppl==None:
            ppl = gpod.itdb_playlist_new("Podcasts",False)
            gpod.itdb_playlist_set_podcasts(ppl)
            gpod.itdb_playlist_add(itdb,ppl,1)
        return gpod.itdb_playlist_mpl(itdb)!= None and gpod.itdb_playlist_podcasts(itdb)!=None

           
           
    def init_ipod_model_info(self):
        """ Get iPod model """
        try: file = open(self.sysinfo_path)
        except IOError: return

        while True:
            line = file.readline()
            if not line: break
            parts = line.split()
            if len(parts) == 0: continue

            parts[0] = parts[0].rstrip(":")
            if parts[0] == "ModelNumStr":
                info = self.__models.get(parts[1][1:], ('iPod', '-'))
                self.model = info[0]
                self.space = info[1]
            elif parts[0] == "visibleBuildID":
                self.firmware = parts[2].strip("()")
    
    # Thx Quodlibet    
    # This list is taken from
    # http://en.wikipedia.org/wiki/List_of_iPod_model_numbers
    __models = {
        # First Generation
        '8513': ('iPod', '5GB'),
        '8541': ('iPod', '5GB'),
        '8697': ('iPod', '5GB'),
        '8709': ('iPod', '10GB'),
        # Second Generation
        '8737': ('iPod', '10GB'),
        '8740': ('iPod', '10GB'),
        '8738': ('iPod', '20GB'),
        '8741': ('iPod', '20GB'),
        # Third Generation
        '8976': ('iPod', '10GB'),
        '8946': ('iPod', '15GB'),
        '9460': ('iPod', '15GB'),
        '9244': ('iPod', '20GB'),
        '8948': ('iPod', '30GB'),
        '9245': ('iPod', '40GB'),
        # Fourth Generation
        '9282': ('iPod', '20GB'),
        '9787': ('iPod (U2 edition)', '20GB'),
        '9268': ('iPod', '40GB'),
        # Photo / Fourth Generation
        'A079': ('iPod photo', '20GB'),
        'A127': ('iPod photo (U2 edition)', '20GB'),
        '9829': ('iPod photo', '30GB'),
        '9585': ('iPod photo', '40GB'),
        '9586': ('iPod photo', '60GB'),
        '9830': ('iPod photo', '60GB'),
        # Shuffle / Fourth Generation
        '9724': ('iPod shuffle', '512MB'),
        '9725': ('iPod shuffle', '1GB'),
        'A133': ('iPod shuffle', '512MB'),
        # Video / Fifth Generation
        'A002': ('iPod video white', '30GB'),
        'A146': ('iPod video black', '30GB'),
        'A003': ('iPod video white', '60GB'),
        'A147': ('iPod video black', '60GB'),
        # Nano / Fifth Generation
        'A350': ('iPod nano white', '1GB'),
        'A352': ('iPod nano black', '1GB'),
        'A004': ('iPod nano white', '2GB'),
        'A099': ('iPod nano black', '2GB'),
        'A005': ('iPod nano white', '4GB'),
        'A107': ('iPod nano black', '4GB'),
        # First Generation Mini
        '9160': ('iPod mini silver', '4GB'),
        '9436': ('iPod mini blue', '4GB'),
        '9435': ('iPod mini pink', '4GB'),
        '9434': ('iPod mini green', '4GB'),
        '9437': ('iPod mini gold', '4GB'),
        # Second Generation Mini
        '9800': ('iPod mini silver', '4GB'),
        '9802': ('iPod mini blue', '4GB'),
        '9804': ('iPod mini pink', '4GB'),
        '9806': ('iPod mini green', '4GB'),
        '9801': ('iPod mini silver', '6GB'),
        '9803': ('iPod mini blue', '6GB'),
        '9805': ('iPod mini pink', '6GB'),
        '9807': ('iPod mini green', '6GB'),
    }
        
def track_to_song(track,force_uri=False):
    song = Song()
    song.set_type(sType.REMOVABLE_FILE)
    try:
        def decode_tag(tag):
            if isinstance(tag, str):
                return tag.decode('utf-8', "replace")
            return tag
        song["ipod_id"] = track.id
        song["title"] = decode_tag(track.title)
        song["album"] = decode_tag(track.album)
        song["artist"] = decode_tag(track.artist)
        song["#duration"] = track.tracklen
        song["genre"] = decode_tag(track.genre)
    
        if track.track_nr!=0:
            song["#track"] = int(track.track_nr)
        if force_uri:
            song["uri"] = force_uri
        else:
            file = gpod.itdb_filename_on_ipod(track)
            #print file
            song["uri"] = "file://"+file
            #print song.get("uri")
            fileinfo = gnomevfs.get_file_info(song.get("uri"))
            song["#size"] = fileinfo.size
        song["tagged"] = True
    except :
        songs = None
        try: print "E:Ipod:Failed to load track:",track.title
        except : print "E:Ipod:Failed to load a track"
        print traceback.format_exc()
        
    return song
    
           
def song_to_track(song):        
    file = song.get_path()
    if not os.path.exists(file):
        return None

    track = gpod.itdb_track_new()
    if song.get_str("title")!="": track.title = str(song.get_str("title"))
    #else: track.title = ""
    if song.get_str("album")!="": track.album = str(song.get_str("album"))

    """elif song.get("type")=="podcast" and song.get_str("podcast_feed_title")!="":
        "" " for podcast the album entry is the name of the feed " ""
        track.album = str(song.get_str("podcast_feed_title"))"""

    #else: track.album = ""
    if song.get_str("artist")!="": track.artist = str(song.get_str("artist"))
    #else: track.artist = ""
    if song.get_str("genre")!="": track.genre = str(song.get_str("genre"))
    """
    if song.sprint("comment") and song["comment"]!=None: track.comment = str(song["comment"])
    else: track.comment = ""
    if song.sprint("composer") and song["composer"]!=None: track.composer = str(song["composer"])
    else: track.composer = ""
    if song.sprint("grouping") and song["grouping"]!=None: track.grouping = str(song["grouping"])
    else: track.grouping = ""
    if song.sprint("category") and song["category"]!=None: track.category = str(song["category"])
    else: track.category = ""
    if song.sprint("description") and song["description"]!=None: track.description = str(song["description"])
    else: track.description = ""
    if song.has_key("subtitle") and song["subtitle"]!=None: track.subtitle = str(song["subtitle"])
    else: track.subtitle = ""

    track.cd_nr = long(0)
    track.cds = long(0)
    """

    if song.get("#track"):
        track.track_nr = int(song.get("#track"))
    if song.get("#duration"):
         track.tracklen = int(song.get("#duration"))


    """ podcast info """
    if song.get_type() in sType.podcast:
        track.podcasturl = str(song.get("podcasturl"))
        track.podcastrss = str(song.get("podcastrss"))
        track.time_released = int(utils.time_unix_to_mac(song.get("#date")))

    #if song.get("#bitrate") :
    #    track.bitrate = int(song.get("#bitrate"))


    if song.get("#size") : 
        track.size = int(song.get("#size"))


    """ For now i always use mp3 file """
    track.filetype = "MPEG audio file"
    track.time_added = long(utils.time_unix_to_mac(time()))
    track.time_modified = track.time_added


    art = song.get_cover(False)
    if art!=const.DEFAULT_COVER:
        gpod.itdb_track_set_thumbnails(track,str(art))
        #if gpod.itdb_track_set_thumbnails(track,str(art)) == 0:
        #    print "Failed to save image thumb for ",song.get_str("title")
    return track

    
    
    
