# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###


# Simple proxy to a Python ConfigParser.
import os
import gtk
# We don't need/want variable interpolation.
from ConfigParser import RawConfigParser as ConfigParser
from helper import helper

_config = ConfigParser()
get = _config.get
def set(section,option,value):
    #print section,option,value
    _config.set(section,option,value)
    helper.config_change(section,option,value)
    
getboolean = _config.getboolean
getint = _config.getint
getfloat = _config.getfloat
write = _config.write
options = _config.options


def write(filename):
    if isinstance(filename, str):
        if not os.path.isdir(os.path.dirname(filename)):
            os.makedirs(os.path.dirname(filename))
        f = file(filename, "w")
    else: f = filename
    _config.write(f)
    f.close()

def init(*rc_files):
    initial = {
        "setting":
        {
          "splash": "false",
          "start_trayicon": "false",
          "fermer_trayicon": "false",
          "use_trayicon": "true",
          "media_organizer_item" : "0",
          "repeat_mode":"false",
          "wikipedia":"en",
          "empty_random":"true",
          "web_font":"Sans 12",
          "web_color_text":"#000000",
          "web_color_link":"#C09665",
          "web_color_bg":"#FFFFFF",
          "web_font":"Sans 12",
          "notification" : "true",
          "compact_playlist" : "false",
          "offline" : "false"
        },
        "dynamic_mode":{
          "expanded":"false",
          "enable":"false",
          "remove_played":"true",
          "track_append":"2",
          "track_upcoming":"10",
          "played_show":"3",
        },
        "library":
        {         
          "location":"~/",
          "watcher":"false",
          "startup_deleted":"false",
          "startup_added":"false",
        },
        "osd":
        {
            "enable": "false",
            "osd_custom_position": "-1 -1",
            "osd_colors": "#ffffff #ffffff #ffffff #2959ac",
            "osd_font": "Sans 18",
            "osd_timeout": "7.5",
            "osd_transparency": "215",
            "osd_center_x": "1",
            "osd_center_y": "0",
        },
        "audioscrobbler":
        {
            "enable":"false",
            "username":"",
            "password":""
        },
        "lyrics":
        {
            "server":"lyrc.com.ar"
        },
        "player":
        {
            "volume":"1.0",
            "play_on_startup":"false",
            "play":"false",
            "time":"",
            "last_played":"",
            "crossfade":"true",
            "crossfade_time":"500",
            "enqueue":"false",
            "click_enqueue":"false",
            "dynamic":"true",
            "vis":"goom",
            "enable_vis":"false"
        },
        "window":
        {
          "width" : "860",
          "height" : "530",
          "x" : "-1",
          "y" : "-1",
          "state" : "widthdrawn",
          "pos_organizer" : "130",
          "pos_global_pane" : "270",
          "pos_cur_playlist" : "500",
          "view":"2"
        },
        "source":
        {
            "iradio":"1",
            "locallibrary":"1",
            "daaplibrary":"1",
            "ipod":"1",
            "lyrics":"1",
            "lastfm":"1",
            "current":"1",
            "podcast":"1",
            "wikipedia":"1",
            "context":"1",            
            "filebrowser":"1",            
            "audiocd":"1",
            "selected_index":"0"
         },
         "filebrowser":{      
            "pane_pos":"200",
            "uri":"file:///home"
            },
    	 "browser":
    	 {
    	   "view":"2",
           "local" : "true",
           "local_last_search":"",
           "local_pos":"120",
           "local_last_selected_artist":"",
           "local_last_selected_album":"",
           "local_last_selected_genre":"",
           "local_sort_tag":"",
           "local_sort_order":"",
           "podcast_local" : "true",
           "podcast_local_last_search":"",
           "podcast_local_pos":"120",
           "podcast_local_last_selected_artist":"",
           "podcast_local_last_selected_album":"",
           "podcast_local_last_selected_genre":"",
           "podcast_local_sort_tag":"",
           "podcast_local_sort_order":"",
           "daap" : "true",
           "daap_last_search":"",
           "daap_pos":"120",
           "daap_last_selected_artist":"",
           "daap_last_selected_album":"",
           "daap_last_selected_genre":"",
           "daap_sort_tag":"",
           "daap_sort_order":"",
           "ipod" : "true",
           "ipod_last_search":"",
           "ipod_pos":"120",
           "ipod_last_selected_artist":"",
           "ipod_last_selected_album":"",
           "ipod_last_selected_genre":"",
           "ipod_sort_tag":"",
           "ipod_sort_order":"",
           "podcast_ipod" : "true",
           "podcast_ipod_last_search":"",
           "podcast_ipod_pos":"120",
           "podcast_ipod_last_selected_artist":"",
           "podcast_ipod_last_selected_album":"",
           "podcast_ipod_last_selected_genre":"",
           "podcast_ipod_sort_tag":"",
           "podcast_ipod_sort_order":"",
           "filesystem_sort_tag":"",
           "filesystem_sort_order":"",
           "radio_sort_tag":"",
           "radio_sort_order":"",
           "favoriteradio_sort_tag":"",
           "favoriteradio_sort_order":"",
           "audiocd_sort_tag":"",
           "audiocd_sort_order":"",
    	 },
         "song_view": {
               "title":"true",
               "artist":"true",
               "album":"true",
               "genre":"false",
               "#duration":"true",
               "#playcount":"false",
               "#lastplayed":"false",
               "date":"false",
               "#date":"true",
               "#track":"true",
               "#bitrate":"false",
               "radio_person":"true",
               "feed":"true"
         },
         "podcast":
         {
           "startup":"true",
           "time_refresh":"120",
           "folder":"~/Podcasts/"
         },
         "iradio":
         {
           "shoutcast_pos":"170"
         },
         "webservice":
         {
           "filter":"bo<###>ost<###>cd1<###>cd2<###>cd3<###>cd 1<###>cd 2<###>cd 3<###> - <###>(<###>)"

         }


    }

    for section, values in initial.iteritems():
        _config.add_section(section)
        for key, value in values.iteritems():
            _config.set(section, key, value)

    _config.read(rc_files)

def state(arg):
    return _config.getboolean("settings", arg)
