#!/usr/bin/env python
# check.py -- check for system requirements
# public domain
NAME = "Listen"

import sys

if __name__ == "__main__":

    print "Checking Python version:",
    print ".".join(map(str, sys.version_info[:2]))
    if sys.version_info <= (2, 4):
        raise SystemExit("%s requires at least Python 2.4."
                         "(http://www.python.org)" % NAME)

    print "Checking for PyGTK >= 2.6:",
    try:
        import pygtk
        pygtk.require('2.0')
        import gtk
        if gtk.pygtk_version < (2, 6) or gtk.gtk_version < (2, 6):
            raise ImportError
    except ImportError:
        raise SystemExit("not found\n%s requires PyGTK 2.6. "
                         "(http://www.pygtk.org)" % NAME)
    else: print "found"

    print "Checking for pyGTK-devel >= 2.6:",
    try:
        import os
        s = "pygtk-codegen-2.0"
        for p in os.environ["PATH"].split(os.path.pathsep):
            p2 = os.path.join(p, s)
            if os.path.exists(p2):
                break
        else: raise ImportError
    except ImportError: raise SystemExit("not found\n%s requires pyGTK-devel" % NAME)
    else: print "found"

    print "Checking for gnome.ui:",
    try: import gnome,gnome.ui
    except ImportError: raise SystemExit("not found\n%s require python-gnome (http://www.gnome.org)" % NAME)
    else: print "found"

    print "Checking for egg.trayicon:",
    try: import egg.trayicon
    except ImportError: raise SystemExit("not found\n%s require gnome-python-extras.\n\t(http://ftp.gnome.org/pub/GNOME/sources/gnome-python-extras)" % NAME)
    else: print "found"

    print "Checking for pygtkmozembed:",
    try: import gtkmozembed
    except ImportError:raise SystemExit("not found\n%s require gnome-python-extras.\n\t(http://ftp.gnome.org/pub/GNOME/sources/gnome-python-extras)" % NAME)
    else: print "found"

    print "Checking for mutagen:",
    try: 
         import mutagen
         if mutagen.version < (1,8): raise ImportError
    except : raise SystemExit("not found\n%s require mutagen >= 1.8.\n\t(http://www.sacredchao.net/quodlibet/wiki/Development/Mutagen)" % NAME)
    else: print "found"

    print "Checking for PyGSt >= 0.10:",
    try:
        import pygst
        pygst.require("0.10")
        import gst
        if gst.pygst_version < (0, 10, 1):
            raise ImportError
    except ImportError: raise SystemExit("not found\n%s requires PyGst 0.10 (http://gstreamer.freedesktop.org)" % NAME)
    else: print "found"


    # Optional

    print "Checking for DBUS:",
    try: import dbus
    except ImportError: print ("not found\n%s dbus recommanded. " % NAME)
    else: print "found"

    print "Checking for python-libgpod:",
    try:
        import gpod
    except ImportError: print ("not found\n%s recommends python-gpod (http://www.gtkpod.org)" % NAME)
    else: print "found"

    print "Checking for python-musicbrainz2:",
    try:
        import musicbrainz2
    except ImportError: print "not found\n, but recommanded"
    else: print "found"

    print "Checking for python-tunepimp > 0.5:",
    try:
        from tunepimp import tunepimp
        dir(tunepimp.tunepimp).index("setMusicDNSClientId")
    except: print  "not found\n, but recommanded"
    else: print "found"

    print "Checking for libsexy:",
    try: import sexy
    except ImportError: print ("not found\n%s recommends python sexy for sexy widget. " % NAME)
    else: print "found"


