/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_icon_list_h__)
#  define __gnome_db_icon_list_h__

#include <libgda/gda-data-model.h>
#include <libgnomeui/gnome-icon-list.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_ICON_LIST            (gnome_db_icon_list_get_type())
#define GNOME_DB_ICON_LIST(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_ICON_LIST, GnomeDbIconList))
#define GNOME_DB_ICON_LIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, GNOME_DB_TYPE_ICON_LIST, GnomeDbIconListClass))
#define GNOME_DB_IS_ICON_LIST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, GNOME_DB_TYPE_ICON_LIST))
#define GNOME_DB_IS_ICON_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_ICON_LIST))

typedef struct _GnomeDbIconList        GnomeDbIconList;
typedef struct _GnomeDbIconListClass   GnomeDbIconListClass;
typedef struct _GnomeDbIconListPrivate GnomeDbIconListPrivate;

struct _GnomeDbIconList {
	GnomeIconList list;
	GnomeDbIconListPrivate *priv;
};

struct _GnomeDbIconListClass {
	GnomeIconListClass parent_class;
};

GType      gnome_db_icon_list_get_type (void);
GtkWidget *gnome_db_icon_list_new (guint icon_width);
void       gnome_db_icon_list_set_model (GnomeDbIconList *list, GdaDataModel *model);

G_END_DECLS

#endif
