/* 
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/
#include "kwlanmaintraywin.h"
#include "kwlanmainwin.h"
#include "kwlanmainsettingsdlg.h"
#include "configuration.h"
#include "globals.h"


#include <kstdaction.h>
#include <kpopupmenu.h>
#include <kaction.h>
#include <qtooltip.h>
#include <kiconloader.h>
#include <qpixmap.h>
#include <klocale.h>
#include <kdebug.h>




/// KwlanMainTrayWin is tray window for main application

KwlanMainTrayWin::KwlanMainTrayWin(QWidget *parent, const char *name)
    : KSystemTray(parent, name)
{
    //actionCollection()->remove( actionCollection()->action( "quit" ) );
    m_quit = KStdAction::quit( this, SIGNAL( quitSelected() ), actionCollection() );
    m_about = KStdAction::aboutApp( this, SIGNAL( aboutSelected() ), actionCollection() );
    m_interfacesMenu = new KPopupMenu();
    m_configureInterfacesMenu = new KPopupMenu();
    m_settingsMenu = new KAction(this,"settings");
    connect (m_interfacesMenu, SIGNAL(activated(int )),SLOT(slotHandleInterfacesMenu( int )));
    connect (m_configureInterfacesMenu, SIGNAL(activated(int )),SLOT(slotHandleConfigureInterfacesMenu( int )));
    connect (m_settingsMenu, SIGNAL(activated()),SLOT(slotSettingsMenu()));

    setPixmap(loadIcon("kwlan"));
    m_tooltip = new KwlanMainToolTip(this);
}

KwlanMainTrayWin::~KwlanMainTrayWin() {
}

void KwlanMainTrayWin::contextMenuAboutToShow( KPopupMenu *r ) 
{
    r->clear();
    r->insertTitle(SmallIcon ("kwlan"), "Kwlan - KDE Connection Manager");
    m_interfacesMenu->clear();
    m_configureInterfacesMenu->clear();
    if (parent())
    {
        int id = 1;
        QStringList interfaces = ((KwlanMainWin *)parent())->getInterfaces();
        for (QStringList::iterator it = interfaces.begin(); it !=interfaces.end();it++)
        {
            m_interfacesMenu->insertItem(*it,id);
            m_interfacesMenu->setItemParameter(id,id);
            m_interfacesMenu->setItemChecked(id, mainConfiguration().readMonitorInterface( *it));
            m_configureInterfacesMenu->insertItem(*it,id);
            m_configureInterfacesMenu->setItemParameter(id,id);
            m_configureInterfacesMenu->setItemChecked(id, mainConfiguration().readConfigureInterface( *it));
            id++;
        }
        r->insertItem(i18n("Monitor interfaces"),m_interfacesMenu);
        r->insertItem(i18n("Configure interfaces"),m_configureInterfacesMenu);
    }
    m_settingsMenu->setText(i18n("Settings"));
    m_settingsMenu->plug(r);
    r->insertSeparator();
    // Now fill int the profiles into profile menu
    m_about->plug( r );
    m_quit->plug( r );
    
}

void KwlanMainTrayWin::slotHandleInterfacesMenu( int id)
{
    if (::debugOutput) kdDebug()<< "Monitor interface " <<m_interfacesMenu->text(id) << endl;
    mainConfiguration().writeMonitorInterface( m_interfacesMenu->text(id), !m_interfacesMenu->isItemChecked(id));
    emit sigMonitorInterface( m_interfacesMenu->text(id),!m_interfacesMenu->isItemChecked(id));
}

void KwlanMainTrayWin::slotHandleConfigureInterfacesMenu( int id)
{
    if (::debugOutput) kdDebug()<< "Configure interface " <<m_configureInterfacesMenu->text(id) << endl;
    mainConfiguration().writeConfigureInterface( m_configureInterfacesMenu->text(id), !m_configureInterfacesMenu->isItemChecked(id));
    emit sigConfigureInterface( m_configureInterfacesMenu->text(id),!m_configureInterfacesMenu->isItemChecked(id));
}

void KwlanMainTrayWin::slotSettingsMenu()
{
    KwlanMainSettingsDlg *settings = new KwlanMainSettingsDlg();
    if (!settings) return;
    settings->show();
    settings->exec();
}

KwlanMainToolTip::KwlanMainToolTip(QWidget *parent): QToolTip(parent) {
}
    
KwlanMainToolTip::~KwlanMainToolTip() {
    
}
        
void KwlanMainToolTip::maybeTip(const QPoint &p) {
    QString tooltip;
    tooltip = QString(i18n("Kwlan - Network manager for KDE"));
    tip(parentWidget()->rect(), tooltip);
}

