#include <qdatetime.h>
#include <kdebug.h>

#include "syndaemon.h"

const unsigned int SynDaemon::KEYMAP_SIZE = 32;
unsigned char* SynDaemon::mKeyboardMask;

SynDaemon::SynDaemon( QObject* parent, int msec ) : QObject( parent ), QThread()
{
    mTerminate = false;
    
    setTime( msec );

    mKeyboardMask = new unsigned char[ KEYMAP_SIZE ];

    // open a connection to the X server 
    mDisplay = XOpenDisplay(NULL);
    
    if ( !mDisplay ) 
        kdDebug() << k_funcinfo << "Can't open display!" << endl;
                            
    // setup keymap
    XModifierKeymap *modifiers;

    for ( unsigned int i = 0; i < KEYMAP_SIZE; i++ )
        mKeyboardMask[i] = 0xFF;

    modifiers = XGetModifierMapping( mDisplay );
    
    for ( int i = 0; i < 8 * modifiers->max_keypermod; i++ )
    {
        KeyCode kc = modifiers->modifiermap[i];
        if ( kc != 0 )
            clearBit( mKeyboardMask, kc );
    }

    XFreeModifiermap( modifiers );
}

SynDaemon::~SynDaemon()
{
    terminate();
    wait();
    delete mKeyboardMask;
}

void SynDaemon::setTime( int msec )
{
    kdDebug() << k_funcinfo << "set timeout to " << msec << " ms!" << endl;
    mTimeOut = msec;
}
void SynDaemon::run()
{
    const unsigned int pollDelay = 20; // 20 ms
    bool typing = false;

    QTime t1;
    
    while ( !mTerminate )
    {
        if ( hasKeyboardActivity() )
        {
            t1.start();

            if ( !typing )
            {
                emit startTyping();
                typing = true;
            }
        }
        else
        {
            if ( typing && ( t1.elapsed() > mTimeOut ) )
            {
                typing = false;
                emit stopTyping();
            }
        }
        
        msleep( pollDelay );
    }

    emit stopTyping();
    kdDebug() << k_funcinfo << "stopped smart mode" << endl;
}

void SynDaemon::clearBit( unsigned char *ptr, int bit )
{
    int byteNum = bit / 8;
    int bitNum = bit % 8;
    ptr[byteNum] &= ~(1 << bitNum ); 
}

void SynDaemon::terminate()
{
    mTerminate = true;
}

bool SynDaemon::hasKeyboardActivity()
{
    static unsigned char oldKeyState[KEYMAP_SIZE];
    unsigned char keyState[KEYMAP_SIZE];
    
    bool result = false;

    XQueryKeymap( mDisplay, (char*)keyState );

    // find pressed keys
    for ( unsigned int i = 0; i < KEYMAP_SIZE; i++ )
    {
        if ( ( keyState[i] & ~oldKeyState[i] ) & mKeyboardMask[i] )
        {
            result = true;
            break;
        }
    }

    // ignore any modifiers
    for ( unsigned int i = 0; i < KEYMAP_SIZE; i++ )
    {
        if ( keyState[i] & ~mKeyboardMask[i] ) 
        {
            result = false;
            break;
        }
    }

    // back up key states...
    for ( unsigned int i = 0; i < KEYMAP_SIZE; i++ )
    {
        oldKeyState[i] = keyState[i];
    }
    
    return result;
}

bool SynDaemon::hasPadButtonActivity()
{
    // FIXME implement me!!!
    return false;
}

#include "syndaemon.moc"

