/***************************************************************************
 *   Copyright (C) 2004 by Stefan Kombrink <katakombi@web.de>              *
 *   Copyright (C) 2004 by Nadeem Hasan <nhasan@kde.org>                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _KSYNAPTICS_H_
#define _KSYNAPTICS_H_

#include <kcmodule.h>

class SynConfigWidget;
class KAboutData;

class KSynaptics: public KCModule
{
  Q_OBJECT

  public:
    KSynaptics( QWidget *parent=0, const char *name=0, const QStringList& = QStringList() );
    ~KSynaptics();

    //! autodetect / load stored settings (once at start-up)
    void load(); 
    //! save current settings
    void save(); 
    //! restores hard-wired default settings
    void defaults();

    int buttons();
    QString quickHelp() const;
    const KAboutData *aboutData() const
    { return m_aboutData; }

  protected:
    void applyConfig();

  private:
    //! info about the module
    KAboutData *m_aboutData;
    //! embedds the dialog
    SynConfigWidget *m_widget;
    //! draws the frame containing active edges and corners
    //myFrame myCSEdgesF;
};

#endif
