/***************************************************************************
                          ProgressDialog.h  -  description
                             -------------------
    begin                : Die Mai 15 15:34:19 CEST 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROGRESSDIALOG_H
#define PROGRESSDIALOG_H

#include <qwidget.h>
#include <kurl.h>

typedef struct RenamedList
{
    KURL src;
    KURL dst;
        
    bool dir;    
    bool error;
};

class KRenameImpl;
class KListView;
class KPopupMenu;
class KPushButton;
class QProgressBar;
class QStringList;
class QStrList;
class QString;
class QTimer;
class QHBoxLayout;
class QVBoxLayout;
class ProgressDialog : public QWidget
{ 
    Q_OBJECT
    public:
        ProgressDialog( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
        ~ProgressDialog();

        void setProgressTotalSteps( int t );
        void setProgress( int p );

        inline bool wasCancelled() const;
        inline void setDestination( const KURL & dir );
        inline void setRenamedFiles( RenamedList* list, unsigned int size ) ;
        inline void setCreatedDirectories( const KURL::List & list );

        void done( int errors, int successfull, bool allowundo );
        void print( QString text, QString pixmap = 0 );
        void error( QString text );
        void warning( QString text );
        
    public slots:
        void show();
        
    private slots:
        void quitAll();
        void restart();
        void again();
        void unAgain();
        void allAgain();
        void openDest();
        void canceled();
        void undo();
        void slotTimer();
        
    private:
        QString count();
        const QString simplify( const QString & text );
        
    protected:
        RenamedList* renamedFiles;
        unsigned int m_size;
        
        KURL m_dest;
        int m_count;
        bool m_canceled;
        KURL::List m_created;
        
        QTimer* m_timer;
        
        KListView* display;
        KPushButton* buttonClose;
        KPushButton* buttonRestart;
        KPushButton* buttonOpenDest;
        KPushButton* buttonUndo;
        KPushButton* buttonCancel;
        KPopupMenu* mnuButton;

        QProgressBar* bar;

        QVBoxLayout* ProgressDialogLayout;
        QHBoxLayout* Layout1;
};


bool ProgressDialog::wasCancelled() const
{ 
    return m_canceled;
}

void ProgressDialog::setDestination( const KURL & dir ) 
{
    m_dest = dir;
}

void ProgressDialog::setRenamedFiles( RenamedList* list, unsigned int size ) 
{
    renamedFiles = list;
    m_size = size;
}
        
void ProgressDialog::setCreatedDirectories( const KURL::List & list ) 
{
    m_created = list;
}

#endif // PROGRESSDIALOG_H
