/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef DEVICEMANAGER_H
#define DEVICEMANAGER_H

#include <kdialogbase.h>


/**
@author Marco Gulino
*/
class KIconView;
class QListViewItem;
class QStringList;
class deviceList;

class DeviceManager : public KDialogBase
{
Q_OBJECT
public:
    DeviceManager(QWidget *parent = 0, const char *name = 0);

    ~DeviceManager();
    int showDeviceConfigDialog(const QString &deviceName, bool newdevice=false);

public slots:
    void updateView();
    void slotRemoveDevice();
    void slotDeviceProperties();
    void slotNewDevice();
    void doubleClickedItem(QListViewItem *item);
    void slotItemRenamed ( QListViewItem * item, int col, const QString & text );
    void selectionChanged ();
    void deviceToggled(bool);
    void deviceChanged(const QString &);

    private:
    deviceList* widgetDevices;
signals:
    void deviceAdded(const QString&);
    void deviceRemoved(const QString&);
    void loadDevice(const QString&);
    void unloadDevice(const QString&);
};


#endif
