/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include <klistview.h>
#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <kconfigdialog.h>
#include <kpushbutton.h>

#include "devicemanager.h"
#include "kmobiletools_cfg.h"
#include "kmobiletools_devices.h"
#include "deviceconfigdialog.h"
#include "deviceList.h"
#include "newdevicewizard.h"

#define COL_DEVNAME 3

DeviceManager::DeviceManager(QWidget *parent, const char *name)
  : KDialogBase(parent, name, true, i18n("Device Manager"), KDialogBase::Close)
{
    widgetDevices=new deviceList(this);
//     iconview=new KIconView(this,"deviceiconview");
    setMainWidget(widgetDevices);
    setInitialSize( QSize(450,300) );
    setModal(false);
/*    setButtonGuiItem(User3, KGuiItem( i18n("Add"), "bookmark_add") );
    setButtonGuiItem(User2, KGuiItem( i18n("Edit"), "editclear") );
    setButtonGuiItem(User1, KGuiItem( i18n("Remove"), "edittrash") );*/
    connect(widgetDevices->addButton, SIGNAL(clicked()), this, SLOT(slotNewDevice() ) );
    connect(widgetDevices->cfgButton, SIGNAL(clicked()), this, SLOT(slotDeviceProperties() ) );
    connect(widgetDevices->remButton, SIGNAL(clicked()), this, SLOT(slotRemoveDevice() ) );
    connect(widgetDevices->deviceListView, SIGNAL(doubleClicked ( QListViewItem *, const QPoint &, int ) ),
            this, SLOT(doubleClickedItem(QListViewItem* ) ) );
    connect(widgetDevices->deviceListView, SIGNAL(itemRenamed ( QListViewItem *, int, const QString &) ),
            this, SLOT(slotItemRenamed ( QListViewItem *, int, const QString &) ) );
    connect(widgetDevices->deviceListView, SIGNAL(selectionChanged()), this, SLOT(selectionChanged()));
    connect(widgetDevices->actButton, SIGNAL(toggled(bool) ), this, SLOT(deviceToggled(bool ) ) );

    updateView();
}


DeviceManager::~DeviceManager()
{
}


#include "devicemanager.moc"


void DeviceManager::updateView()
{
    selectionChanged();
    widgetDevices->deviceListView->clear();
    QStringList sl_devices=KMobileTools::MainConfig::devicelist();
    KListViewItem* cur_item;
    for ( QStringList::Iterator it = sl_devices.begin(); it != sl_devices.end(); ++it ) {
        cur_item= new KListViewItem( /*
                iconview, DeviceConfigInstance(*it)->devicename(), 
                KGlobal::iconLoader()->loadIcon("kmobiletools",KIcon::NoGroup, KIcon::SizeMedium) */
                widgetDevices->deviceListView,
                DeviceConfigInstance(*it)->devicename(),
                KMobileTools::DevicesConfig::engineTypeName(DeviceConfigInstance(*it)->engine() ),
                (DeviceConfigInstance(*it)->loaded() ? i18n("Yes") : i18n("No") ),
                                *it );
        cur_item->setPixmap(0, KMobileTools::DevicesConfig::deviceTypeIcon(*it,KIcon::NoGroup, KIcon::SizeSmall) );
        cur_item->setRenameEnabled(0, true);
    }
}

void DeviceManager::slotRemoveDevice() /// Remove device
{
    if (widgetDevices->deviceListView->selectedItem() == NULL ) return;
    QStringList sl_devices = KMobileTools::MainConfig::devicelist();
    QString deviceName = KMobileTools::DevicesConfig::deviceGroup( widgetDevices->deviceListView->selectedItem()->text(0) );

    /* If the device is not in the list, well, just skip it */
    if ( ! sl_devices.contains(deviceName) ) {
      kdDebug() << "Asked to remove the non-present device " << deviceName << endl;
      return;
    }

    /* Remove the entry from the list of devices */
    QStringList::iterator it; QStringList::iterator end = sl_devices.end();
    while ( (it = sl_devices.find(deviceName)) != end )
      sl_devices.remove(it);

    KMobileTools::DevicesConfig::deletePrefs( deviceName );

    KMobileTools::MainConfig::setDevicelist( sl_devices );
    KMobileTools::MainConfig::writeConfig();

    emit deviceRemoved(deviceName);

    updateView();
}

void DeviceManager::slotDeviceProperties() /// Modify device
{
    if (widgetDevices->deviceListView->selectedItem() == NULL ) return;
    showDeviceConfigDialog( KMobileTools::DevicesConfig::deviceGroup(widgetDevices->deviceListView->selectedItem()->text(0) ) );
}

void DeviceManager::slotNewDevice()
{
    /// Add device button
    QString deviceName=KMobileTools::DevicesConfig::firstFreeGroup();
    if( ! showDeviceConfigDialog(deviceName, true) )
      return;

    QStringList sl_devices = KMobileTools::MainConfig::devicelist();
    sl_devices += deviceName;
    KMobileTools::MainConfig::setDevicelist( sl_devices );
    KMobileTools::MainConfig::writeConfig();
    
    updateView();

    emit deviceAdded(deviceName);
}

int DeviceManager::showDeviceConfigDialog(const QString &deviceName, bool newdevice)
{
    if(newdevice)
    {
        newDeviceWizard *newDeviceConfigDialog=new newDeviceWizard(this, deviceName);
        int ret=newDeviceConfigDialog->exec();
        deviceChanged(deviceName);
        return ret;
    } else
    {
        deviceConfigDialog *cfg_device=new deviceConfigDialog(this, deviceName, DeviceConfigInstance(deviceName));
        int ret=cfg_device->exec();
        deviceChanged(deviceName);
        return ret;
    }
}


void DeviceManager::doubleClickedItem(QListViewItem *item)
{
    if ( item == NULL ) return;
    showDeviceConfigDialog( KMobileTools::DevicesConfig::deviceGroup(item->text(0) ) );
}

void DeviceManager::slotItemRenamed ( QListViewItem * item, int col, const QString & text )
{
    if(col!=0) return;
    KMobileTools::DevicesConfig *wconfig=KMobileTools::DevicesConfig::prefs( item->text(COL_DEVNAME) );
    wconfig->setDevicename( text );
    wconfig->writeConfig();
}


/*!
    \fn DeviceManager::selectionChanged ( )
 */
void DeviceManager::selectionChanged ()
{
    QListViewItem *item=widgetDevices->deviceListView->selectedItem ();
    if(item==NULL)
    {
        widgetDevices->cfgButton->setEnabled(false);
        widgetDevices->remButton->setEnabled(false);
        widgetDevices->actButton->setEnabled(false);
        return;
    }
    widgetDevices->cfgButton->setEnabled(true);
    widgetDevices->remButton->setEnabled(true);
    widgetDevices->actButton->setEnabled(true);
    widgetDevices->actButton->setOn( DeviceConfigInstance(item->text(COL_DEVNAME))->loaded() );
}


/*!
    \fn DeviceManager::deviceToggled(bool)
 */
void DeviceManager::deviceToggled(bool b)
{
    QListViewItem *item=widgetDevices->deviceListView->selectedItem ();
    if(item==NULL) return;
    if ( DeviceConfigInstance(item->text(COL_DEVNAME))->loaded() != b)
    {
        if(b)
            emit  loadDevice( item->text(COL_DEVNAME) );
        else
            emit unloadDevice( item->text(COL_DEVNAME) );
    }
}


/*!
    \fn DeviceManager::deviceChanged(const QString &)
 */
void DeviceManager::deviceChanged(const QString &deviceName)
{
    QString deviceText=DeviceConfigInstance(deviceName)->devicename();
    // Try to find our device in the listview
    QListViewItemIterator it( widgetDevices->deviceListView );
    while ( it.current() ) {
        if(it.current()->text(COL_DEVNAME) == deviceName)
        {
            QListViewItem *item = it.current();
            item->setText(0, deviceText);
            item->setText(1, KMobileTools::DevicesConfig::engineTypeName(DeviceConfigInstance(deviceName)->engine()) );
            item->setText(2, (DeviceConfigInstance(deviceName)->loaded() ? i18n("Yes") : i18n("No") ) );
            item->setPixmap(0, KMobileTools::DevicesConfig::deviceTypeIcon(deviceName,KIcon::NoGroup, KIcon::SizeSmall) );
        }
        ++it;

    }
}
