/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef DEVICECONFIGDIALOG_H
#define DEVICECONFIGDIALOG_H

#include <kconfigdialog.h>
#include "kmobiletools_devices.h"
#include "config.h"

class wizDeviceFirst;
class cfg_at_engine;

#ifdef WITH_GAMMU
class cfg_gammu_engine;
#endif

class genericDeviceOptions;
class cfgFilesystem;

/**
@author Marco Gulino
*/
class deviceConfigDialog : public KConfigDialog
{
Q_OBJECT
public:
    deviceConfigDialog (QWidget *parent, const char *name, KConfigSkeleton *config, DialogType dialogType=IconList, int dialogButtons=Default|Ok|Apply|Cancel|Help, ButtonCode defaultButton=Ok, bool modal=false);

    ~deviceConfigDialog();
    
protected slots:
    void slotOk();
    void slotApply();
    void updateSettings();
    void slotEngineChanged(const QString &);
    void slotPollEnabled(bool poll);
    void at_advancedOptions();
    void fs_selected(int);

private:
    wizDeviceFirst *firstPage;
    cfg_at_engine* at_engine;
#ifdef WITH_GAMMU
    cfg_gammu_engine* gammu_engine;
#endif
    genericDeviceOptions *genOptions;
#ifdef ENABLE_FS
    cfgFilesystem *fsConfig;
#else
    QLabel *fsConfig;
#endif
    int at_selected_connections;
private slots:
    void at_connectionClicked(int index);
public slots:
    void saveSlots();
    void chooseSMSCenter();
};

#endif
