//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kdebluetooth@schaettgen.de                                            *
 *   marco@kmobiletools.org                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "rfcommsocketdevice.h"

#ifdef KBLUETOOTH_NEW

#include <sys/socket.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include "deviceaddress.h"
#include <bluetooth/bluetooth.h>
#include <bluetooth/rfcomm.h>
#include <kdebug.h>
#include <qtimer.h>

namespace KBluetooth {

class RfcommSocketDevicePrivate {
    public:
        RfcommSocketDevicePrivate() {}
        KBluetooth::DeviceAddress m_addr;
        int i_channel;
};

RfcommSocketDevice::RfcommSocketDevice()
    : QObject(), QSocketDevice(Stream )
{
    d=new RfcommSocketDevicePrivate;
    this->d->m_addr = KBluetooth::DeviceAddress::invalid;
}


RfcommSocketDevice::~RfcommSocketDevice()
{
}

bool RfcommSocketDevice::connect(const KBluetooth::DeviceAddress& addr, int channel)
{
    this->d->m_addr = addr;
    this->d->i_channel=channel;

    kdDebug() << QString("RfcommSocketDevice::connect(%1, %2)")
            .arg(QString(addr)).arg(channel) << endl;
    sockaddr_rc rem_addr, loc_addr;
    int s;

    if( (s = ::socket(PF_BLUETOOTH, SOCK_STREAM, BTPROTO_RFCOMM)) < 0 ) {
//         emit error(errno);
        kdDebug() << QString("Can't create socket. %1(%2)")
                .arg(strerror(errno)).arg(errno) << endl;
        return false;
    }

    memset(&loc_addr, 0, sizeof(loc_addr));
    loc_addr.rc_family = AF_BLUETOOTH;
    loc_addr.rc_bdaddr = DeviceAddress::any.getBdaddr();
    if (::bind(s, (struct sockaddr *) &loc_addr, sizeof(loc_addr)) < 0 ) {
//         emit error(errno);
        kdDebug() << QString("Can't bind socket. %1(%2)")
                .arg(strerror(errno)).arg(errno) << endl;
        return false;
    }

    memset(&rem_addr, 0, sizeof(rem_addr));
    rem_addr.rc_family = AF_BLUETOOTH;
    rem_addr.rc_bdaddr = addr.getBdaddr();
    rem_addr.rc_channel = channel;
    if(::connect(s, (struct sockaddr *)&rem_addr, sizeof(rem_addr)) < 0 ){
//         emit error(errno);
        kdDebug() << QString("Can't connect. %1(%2)")
                .arg(strerror(errno)).arg(errno) << endl;
            ::close(s);
            return false;
    }
    kdDebug() << "Connected." << endl;
    setSocket(s, QSocketDevice::Stream );
    //writeBlock("hello world", 12);
    //::write(s, "hello world", 12);
//     emit connected();
    return true;
}

KBluetooth::DeviceAddress RfcommSocketDevice::addr() const { return d->m_addr; }

}
#include "rfcommsocketdevice.moc"

#endif
