/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "pickphonenumberdialog.h"
#include "engineslist.h"

#include <qlayout.h>
#include <kcombobox.h>
#include <klocale.h>
#include <kabc/stdaddressbook.h>
#include <klistview.h>
#include <kabc/addressee.h>
#include <kdebug.h>

#include "kmobiletoolsengine.h"
#include "kmobiletools_devices.h"




bool NameSearchLine::itemMatches(const QListViewItem *item, const QString &s) const
{
    if(item->childCount() == 0) return KListViewSearchLine::itemMatches((QListViewItem*)item->parent(), s);
    return KListViewSearchLine::itemMatches(item,s);
}


PickPhoneNumberDialog::PickPhoneNumberDialog(QWidget *parent, const char *name)
    : KDialogBase(parent, name, true, i18n("Pick Phonenumber"), Ok|Cancel, Ok, true)
{
    m_widget=new ui_PickPhoneNumber(this);
    QVBoxLayout *sl_layout=new QVBoxLayout(m_widget->frameSearchLine);
#if KDE_IS_VERSION( 3, 4, 0 )
    NameSearchLineWidget *slwidget=new NameSearchLineWidget( m_widget->lv_Phone_Numbers, m_widget->frameSearchLine);
#else
    NameSearchLine *slwidget=new NameSearchLine( m_widget->frameSearchLine, m_widget->lv_Phone_Numbers);
#endif
//     NameSearchLine *slwidget=new NameSearchLine( m_widget->frameSearchLine, m_widget->lv_Phone_Numbers );
    sl_layout->addWidget( slwidget );
    m_widget->pbSource->insertItem(i18n("KDE Addressbook"), 0);
    m_widget->pbSource->insertStringList ( EnginesList::instance()->namesList( true ) );
    setMainWidget(m_widget);
    resize(450,600);
    addresseeList=0L;
    connect(m_widget->pbSource, SIGNAL(activated(int)), this, SLOT(slotSourceChanged( int ) ));
    connect(m_widget->lv_Phone_Numbers, SIGNAL(doubleClicked(QListViewItem*, const QPoint&,int)), this, SLOT(doubleClick(QListViewItem*, const QPoint&,int)) );
    connect(m_widget->lv_Phone_Numbers, SIGNAL(clicked(QListViewItem*, const QPoint&,int)), this, SLOT(click(QListViewItem*, const QPoint&,int)) );
    EnginesList *enginelist=EnginesList::instance();
    connect(enginelist, SIGNAL(phonebookUpdated()), this, SLOT(updatePhonebook()) );
    if(name)
    {
        m_widget->pbSource->setCurrentItem( DeviceConfigInstance(name)->devicename() );
        slotSourceChanged( m_widget->pbSource->currentItem() );
    } else slotSourceChanged( 0 );
}


PickPhoneNumberDialog::~PickPhoneNumberDialog()
{
}


#include "pickphonenumberdialog.moc"


/*!
    \fn PickPhoneNumberDialog::slotSourceChanged(int)
 */
void PickPhoneNumberDialog::slotSourceChanged(int index)
{
    if(!index)
        addresseeList=new KMobileTools::ContactPtrList(KABC::StdAddressBook::self()->  allAddressees () );
    else
    {
        kmobiletoolsEngine *engine= EnginesList::instance()->find( m_widget->pbSource->text(index), true );
        if(engine) addresseeList=engine->addresseeList(); else addresseeList=0;
    }
    updateNumbersList();
}


void PickPhoneNumberDialog::updatePhonebook()
{
    kdDebug() << "PickPhoneNumberDialog::updatePhonebook()\n";
    kmobiletoolsEngine *engine= EnginesList::instance()->find( m_widget->pbSource->currentText(), true );
    if(!engine)
    {
        addresseeList=0;
        return;
    }
    addresseeList=engine->addresseeList();
    updateNumbersList();
}
/*!
    \fn PickPhoneNumberDialog::updateNumbersList()
 */
void PickPhoneNumberDialog::updateNumbersList()
{
    m_widget->lv_Phone_Numbers->clear();
    if(!addresseeList) return;
    KABC::Addressee *curItem;
    QPtrListIterator<KABC::Addressee> it(*addresseeList);
    KListViewItem *newItem;
    KABC::PhoneNumber::List numbersList;
    while ( (curItem=it.current()) )
    {
        numbersList=curItem->phoneNumbers();
        ++it;
        if( numbersList.count()==0 ) continue;
        QValueListIterator<KABC::PhoneNumber>pit;
        newItem=new KListViewItem(m_widget->lv_Phone_Numbers, curItem->formattedName ());
        for(pit=numbersList.begin(); pit!=numbersList.end(); ++pit)
            new KListViewItem(newItem, (*pit).label(), (*pit).number(), curItem->formattedName () );
        newItem->setOpen(false);
        newItem->setSelectable(false);
    }
}


/*!
    \fn PickPhoneNumberDialog::doubleClick( QListViewItem *, const QPoint &, int )
 */
void PickPhoneNumberDialog::doubleClick( QListViewItem *item, const QPoint &, int )
{
    if(!item) return;
    if(item->childCount() )
    {
        if(item->isOpen() ) item->setOpen( false); else item->setOpen( true );
        return;
    }
    s_selectedNumbers.clear();
    s_selectedNumbers+= item->text( 1);
    done(Accepted);
}


/*!
    \fn PickPhoneNumberDialog::click( QListViewItem *, const QPoint &, int )
 */
void PickPhoneNumberDialog::click( QListViewItem *item, const QPoint &, int )
{
    if(!item) return;
    if(item->childCount() )
    {
        if(item->isOpen() ) item->setOpen( false); else item->setOpen( true );
        return;
    }
    QListViewItemIterator it( m_widget->lv_Phone_Numbers, QListViewItemIterator::Selected );
    while(it.current() )
    {
        s_selectedNumbers+=(*it)->text(1);
        ++it;
    }
}
