/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include <qstring.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kplugininfo.h>

#include "kmobiletools_devices.h"
#include "engineslist.h"
#include "kmobiletools_cfg.h"

QDict<KMobileTools::DevicesConfig> *KMobileTools::DevicesConfig::m_prefs = 0;

KMobileTools::DevicesConfig *KMobileTools::DevicesConfig::prefs(const QString &groupName)
{
    if (!m_prefs)
    {
        m_prefs = new QDict<KMobileTools::DevicesConfig>();
        m_prefs->setAutoDelete(true);
    }
    KMobileTools::DevicesConfig *devicesPrefs = m_prefs->find(groupName);
    if (devicesPrefs)
    {
/*        devicesPrefs->readConfig();*/
        return devicesPrefs;
    }

    devicesPrefs = new KMobileTools::DevicesConfig(groupName);
    devicesPrefs->readConfig();
    m_prefs->insert(groupName, devicesPrefs);
    return devicesPrefs;
}

bool KMobileTools::DevicesConfig::hasPrefs(const QString &groupName)
{
    KConfig &config = *KGlobal::config();
    return config.hasGroup(groupName);
}

void KMobileTools::DevicesConfig::deletePrefs(const QString &groupName)
{
    KConfig &config = *KGlobal::config();
    config.deleteGroup(groupName);
    if (!m_prefs)
        return;
    m_prefs->remove(groupName);
}

const QString KMobileTools::DevicesConfig::deviceGroup( const QString &devicename)
{
    QStringList validDevices = KMobileTools::MainConfig::devicelist();
    QString cgroup;
    for(int i=0; i<100; i++)
    {
        cgroup="device-%1";
        cgroup=cgroup.arg(i);
        if( KMobileTools::DevicesConfig::prefs( cgroup )->devicename() == devicename) {
	  if ( ! validDevices.contains(cgroup) ) {
	    KMobileTools::DevicesConfig::deletePrefs(cgroup);
	    kdDebug() << "Removed stale group " << cgroup << endl;
	  } else
	    return cgroup;
	}
    }
    return NULL;
}

const QString KMobileTools::DevicesConfig::firstFreeGroup()
{
    QString cgroup;
    for(int i=0; i<100; i++)
    {
        cgroup="device-%1";
        cgroup=cgroup.arg(i);
        if( ! (KMobileTools::DevicesConfig::prefs( cgroup )->devicename().length() ) )
            return cgroup;
    }
    return NULL;
}

const QPixmap KMobileTools::DevicesConfig::deviceTypeIcon(const QString &groupName, KIcon::Group group, int size)
{
    kdDebug() << "deviceTypeIcon(); groupName=" << groupName << ", engine=" << KMobileTools::DevicesConfig::prefs(groupName)->engine()<< endl;
    KPluginInfo *info=EnginesList::instance()->engineInfo(KMobileTools::DevicesConfig::prefs(groupName)->engine() );
    if(!info) return QPixmap();
    kdDebug() << "icon:" << info->icon() << endl;
    return KGlobal::iconLoader()->loadIcon(info->icon(), group, size);
}

const QString KMobileTools::DevicesConfig::engineTypeName(const QString &libName)
{
    KPluginInfo *info=EnginesList::instance()->engineInfo(libName);
    if(!info) return QString::null;
    return info->name();
}

const QString KMobileTools::DevicesConfig::deviceTypeIconPath(const QString &groupName, int groupOrSize)
{
    KPluginInfo *info=EnginesList::instance()->engineInfo(KMobileTools::DevicesConfig::prefs(groupName)->engine() );
    if(!info) return QString::null;
    return KGlobal::iconLoader()->iconPath(info->icon(), groupOrSize);
}
