/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef ENGINELOADER_H
#define ENGINELOADER_H

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>
#include <qthread.h>
#include "weaver.h"

// #include "kmobiletoolsengine.h"

/**
	@author Marco Gulino <marco@kmobiletools.org>
*/

class kmobiletoolsEngine;
class KLibrary;
class DeviceInfos
{
    public:
        const QString rawManufacturer() { return s_manufacturer;}
        const QString model() { return s_model; }
        const QString revision() { return s_revision; }
        const QString imei() { return s_imei; }
        const QString smsCenter() { return s_smsCenter; }
        const QString foundPath() { return s_foundPath; }
        const QStringList smsSlots() { return sl_smsSlots; }
        const QStringList pbSlots() { return sl_pbSlots; }
        const QStringList charsets() { return sl_Charset; }

        void setManufacturer(const QString &manufacturer) { s_manufacturer=manufacturer;}
        void setModel(const QString &model) { s_model=model; }
        void setRevision(const QString &revision) { s_revision=revision; }
        void setImei(const QString &imei) { s_imei=imei; }
        void setSMSCenter(const QString &smsCenter) { s_smsCenter=smsCenter; }
        void setFoundPath(const QString &foundPath) { s_foundPath=foundPath; }
        void setSMSSlots(const QStringList &smsSlots) { sl_smsSlots=smsSlots; }
        void setPbSlots(const QStringList &pbSlots) { sl_pbSlots=pbSlots; }
        void setCharsets(const QStringList &charsets) { sl_Charset=charsets; }
        bool isNull() { return s_imei.isNull(); }
    private:
        QString s_manufacturer, s_model, s_revision, s_imei, s_smsCenter, s_foundPath;
        QStringList sl_smsSlots, sl_pbSlots, sl_Charset;
};
using namespace ThreadWeaver;
class DevicesInfoList : public QObject, public QPtrList<DeviceInfos>
{
Q_OBJECT
    public:
        DevicesInfoList();
        void probeDevices(const QStringList &devicePaths, const QString &engineLib, const QStringList &params, bool fullprobe=true, int usleeptime=0, const QString &imeiToFind=QString::null);
        DeviceInfos *findByPath(const QString &path);
        DeviceInfos *findByIMEI(const QString &imei);
        void setSearchingImei(const QString &imei) { s_searchingIMEI=imei;}
        QString searchingIMEI() { return s_searchingIMEI; }
        void setFound() { b_found=true; }
        bool found() { return b_found; }
    private:
        Weaver *weaver;
        int probeDevicesNumber, probeDevicesDone;
        QStringList sl_devicesLocked, sl_devicePaths;
        QString s_engineLib;
        QStringList sl_params;
        bool b_fullprobe;
        KLibrary *lib;
        kmobiletoolsEngine *engine;
        int i_usleeptime;
        bool b_probing;
        bool b_found;
        QString s_searchingIMEI;

    public slots:
        void slotDeviceFound(Job *job);
        void slotDeviceProbeFinished();
        void invalidLockFile(const QString &lockFile);
        void dump();
    signals:
        void probeFinished();
        void probePercentDone(int);
};


class engineLoader : public ThreadWeaver::Job
{
    Q_OBJECT
public:
    engineLoader (DevicesInfoList* parent, kmobiletoolsEngine *eng, const QString &devicePath, bool fullprobe, const QString &engineLib, const QStringList &params, int usleeptime);
    ~engineLoader();
    DeviceInfos *deviceInfos() { return &p_deviceInfos; }
    private:
        QString libName;
        kmobiletoolsEngine *engine;
        QString devicePath;
        bool fullprobe;
        QString engineLib;
        QStringList params;
        int i_usleeptime;
        DeviceInfos p_deviceInfos;
        DevicesInfoList* p_list;
    protected:
        void run();
    signals:
        void invalidLockFile(const QString &);
};

#endif
