/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "devicemenu.h"

#include <klocale.h>
#include <kglobal.h>
#include <kiconloader.h>
#include "kmobiletools_devices.h"
#include "kmobiletoolsengine.h"

#define ID_LOAD 1
#define ID_UNLOAD 2
#define ID_SWITCHTO 4
#define ID_CONFIGURE 8
#define ID_PBOOK 0x10
#define ID_SMS 0x20

deviceMenu::deviceMenu(bool loaded, kmobiletoolsEngine *engine, QWidget *parent, const char *name)
 : KPopupMenu(parent, name), p_engine(engine)
{
    insertTitle( DeviceConfigInstance(name)->devicename() );
    if(loaded)
        insertItem( KGlobal::iconLoader()->loadIconSet( "connect_no",KIcon::FirstGroup, KIcon::SizeSmall),  i18n("Unload"), ID_UNLOAD );
    else insertItem( KGlobal::iconLoader()->loadIconSet( "connect_creating",KIcon::FirstGroup,  KIcon::SizeSmall), i18n("Load"), ID_LOAD );
    if (!engine)
        insertItem( KGlobal::iconLoader()->loadIconSet( "goto",KIcon::FirstGroup,  KIcon::SizeSmall), i18n("Switch to.."), ID_SWITCHTO );
    else
    {
        insertSeparator();
        insertItem( KGlobal::iconLoader()->loadIconSet( "personal",KIcon::FirstGroup, KIcon::SizeSmall),  i18n("Phonebook"), ID_PBOOK );
        insertItem( KGlobal::iconLoader()->loadIconSet( "mail_get",KIcon::FirstGroup, KIcon::SizeSmall),  i18n("SMS"), ID_SMS );
    }
    insertItem( KGlobal::iconLoader()->loadIconSet( "configure",KIcon::FirstGroup,  KIcon::SizeSmall), i18n("Configure"), ID_CONFIGURE );
    connect(this, SIGNAL(activated ( int )), SLOT(slotItemClicked(int) ) );
}


deviceMenu::~deviceMenu()
{
}


#include "devicemenu.moc"


/*!
    \fn deviceMenu::slotItemClicked(int id)
 */
void deviceMenu::slotItemClicked(int id)
{
    switch( id ){
        case ID_LOAD:
            emit loadDevice(name() );
            break;
        case ID_UNLOAD:
            emit unloadDevice(name() );
            break;
        case ID_SWITCHTO:
            emit switchDevice(name() );
            break;
        case ID_CONFIGURE:
            if(p_engine) emit sendURL( KURL(QString("%1:configure").arg(p_engine->name() ) ) );
            else emit configure( QString("configure:%1").arg(name() ) );
            break;
        case ID_PBOOK:
            emit sendURL( KURL(QString("%1:phonebook").arg(p_engine->name() ) ) );
            break;
        case ID_SMS:
            emit sendURL( KURL(QString("%1:sms").arg(p_engine->name() ) ) );
            break;
    }
}
