/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "contactptrlist.h"
#include <kdebug.h>

using namespace KMobileTools;

ContactPtrList::ContactPtrList()
    : QPtrList<KABC::Addressee>()
{
}

ContactPtrList::ContactPtrList(QValueList<KABC::Addressee> addresseeList)
    : QPtrList<KABC::Addressee>()
{
    QValueList<KABC::Addressee>::iterator it;
    for (it=addresseeList.begin(); it!=addresseeList.end(); ++it)
        append( new KABC::Addressee(*it) );
}


ContactPtrList::~ContactPtrList()
{
}


// #include "contactptrlist.moc"


/*!
    \fn KMobileTools::ContactPtrList::findAddressee(int memslot, int index)
 */
KABC::Addressee* KMobileTools::ContactPtrList::findAddressee(int memslot, const QString &index)
{
    KABC::Addressee *retval=0L;
    for(retval=first(); retval; retval=next() )
        if( retval->custom("KMobileTools","memslot").toInt() == memslot && retval->custom("KMobileTools","index") == index) return retval;
    return 0L;
}


/*!
    \fn KMobileTools::ContactPtrList::findAddressee(const QString &posInfos)
 */
KABC::Addressee* KMobileTools::ContactPtrList::findAddressee(const QString &posInfos)
{
    if( posInfos.contains('-') != 1 ) return 0L;
    int pos=posInfos.find('-');
    int memslot=posInfos.left(pos).toInt();
    if( ! memslot || ! posInfos.mid(pos+1).length() ) return 0L;
    return findAddressee(memslot, posInfos.mid(pos+1));
}
