/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef KMOBILETOOLSAT_ENGINE_H
#define KMOBILETOOLSAT_ENGINE_H

#include <klibloader.h>
#include <kmobiletoolsengine.h>

#include "config.h"
#ifdef HAVE_KCAL
#include "calendar_jobs.h"
#endif

#include "at_jobs.h"
#include "sms_jobs.h"
#include "phonebook_jobs.h"
#include <serialdevice.h>
/*class Device;*/
class ATAbilities;

/**
@author Marco Gulino
*/
using namespace ThreadWeaver;
class kmobiletoolsAT_engine : public kmobiletoolsEngine
{
Q_OBJECT
public:
    kmobiletoolsAT_engine(QObject *parent = 0, const char *name = 0);

    ~kmobiletoolsAT_engine();
//     enum jobTypes
//     { PollStatus=1, PollSMS=2 };

        void setATAbilities( ATAbilities atAbilities );
        ATAbilities getATAbilities() const;
        int availPbSlots();
    static QString getPBMemSlotString(int memslot);
    void queryClose();
    bool pdu();
    QString currentDeviceName() const;
    QString engineLibName() const;
    private:
        /** A collection of all abilities supported by the phone
        */
        ATAbilities atAbilities;
        SerialManager *device;
        bool queue_sms;
        /// @TODO remove this
        QStringList initStrings()
        {
            QStringList retval(DeviceConfigInstance(name())->at_initString() );
            retval+=DeviceConfigInstance(name())->at_initString2();
            return retval;
        }
        kmobiletoolsJob *p_lastJob;
public slots:
    void pollPhoneStatus();
    void processSlot(Job* );
    void getPhoneInfos();
    void initPhone();
    void retrieveAddressBook();
    void retrieveSMSList();
    void slotAddAddressee(QValueList<KABC::Addressee>*);
    void slotDelAddressee(QValueList<KABC::Addressee>*);
    void slotEditAddressee(KABC::Addressee* p_oldAddressee, KABC::Addressee* p_newAddressee);
    void weaverSuspended();
    void resumeDevice();
    void stopDevice();
    void setDevice ( const QString &deviceName);
    DeviceInfos probeDevice(ThreadWeaver::Job *job, bool fullprobe, const QString &deviceName, const QStringList &params) const;
    static void closeDevice(SerialManager *dev)
    {
        if(!dev) return;
        dev->close();
    }
    void closeDevice() { kmobiletoolsAT_engine::closeDevice(device); }
    void slotDelSMS(SMS* sms);
    void slotSendStoredSMS(SMS*);
    void slotStoreSMS(const QString &number, const QString &text);
    void slotSendSMS(const QString &number, const QString &text);
    void probePhone();
    void slotSendSMS(SMS*);
    void slotStoreSMS(SMS*);
//     void invalidLockFile(const QString &);
    void dial(DialActions, const QString & =QString::null );


protected slots:
    void devConnected();

    /*!
        \fn kmobiletoolsAT_engine::encodings()
     */
    QStringList encodings()
    {
        return atAbilities.getCharacterSets();
    }
    void fetchCalendar();
    void switchToFSMode();
};


class kmobiletoolsAT_engineFactory : public KLibFactory
{
   Q_OBJECT
public:
    kmobiletoolsAT_engineFactory();
    virtual ~kmobiletoolsAT_engineFactory();
    virtual kmobiletoolsAT_engine* createObject( QObject *parent, const char *name, const char *classname, const QStringList &args );

private:
};

#endif
