/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "editaddressee.h"

#include "kmobiletoolsengine.h"

#include <klocale.h>
#include <kpushbutton.h>
#include <qbuttongroup.h>
#include <knuminput.h>
#include <klineedit.h>
#include <qradiobutton.h>
#include <kcombobox.h>
#include <klistview.h>
#include <qptrlist.h>
#include <kmessagebox.h>

editAddressee::editAddressee(int phoneManufacturer, int pbslots, int index, QWidget *parent, const char *name)
    : KDialogBase(parent, name, true, i18n("Add New Contact"), Ok | Cancel)
{
    setupWidgets(phoneManufacturer, pbslots, index);
}

editAddressee::editAddressee(KABC::Addressee *addressee, int phoneManufacturer, int pbslots, int index, QWidget *parent, const char *name)
    : KDialogBase(parent, name, true, i18n("Edit Contact"), Ok | Cancel)
{
    setupWidgets(phoneManufacturer, pbslots, index);
    if(!addressee) done(QDialog::Rejected);

    int abMemSlot=addressee->custom("KMobileTools","memslot").toInt();
    for(int i=0; i<mainWidget->cb_memslot->count(); i++ )
    {
        if(abMemSlot==kmobiletoolsEngine::PB_SIM && mainWidget->cb_memslot->text(i)==PB_SIM_TEXT) mainWidget->cb_memslot->setCurrentItem(i);
        if(abMemSlot==kmobiletoolsEngine::PB_Phone && mainWidget->cb_memslot->text(i)==PB_PHONE_TEXT) mainWidget->cb_memslot->setCurrentItem(i);
        if(abMemSlot==kmobiletoolsEngine::PB_DataCard && mainWidget->cb_memslot->text(i)==PB_DATACARD_TEXT) mainWidget->cb_memslot->setCurrentItem(i);
    }
    QValueListIterator<KABC::PhoneNumber> it;
    QValueList<KABC::PhoneNumber> list=addressee->phoneNumbers();
    for(it=list.begin(); it!=list.end(); ++it)
        new KListViewItem( mainWidget->lv_numbers, (*it).number(), (*it).label() );
    mainWidget->txt_cname->setText( addressee->formattedName() );
}


editAddressee::~editAddressee()
{
}

void editAddressee::setupWidgets( int phoneManufacturer,  int pbslots, int  )
{
    mainWidget=new editAddressee_ui(this);
    setMainWidget(mainWidget);
    switch( phoneManufacturer ){
        case kmobiletoolsEngine::Motorola:
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Cell)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Pref)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Work)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Home)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Fax)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Pager)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Msg)   );
            break;
        case kmobiletoolsEngine::SonyEricsson:
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Cell)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Pref)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Work)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Home)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Fax)   );
            break;
        case kmobiletoolsEngine::Nokia:
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Cell)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Pref)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Work)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Home)   );
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Fax)   );
break;
        default:
            mainWidget->cb_type->insertItem(KABC::PhoneNumber::typeLabel(KABC::PhoneNumber::Pref)   );
    }
    connect(mainWidget->b_add, SIGNAL(clicked()), this, SLOT(slotAddClicked() ) );
    connect(mainWidget->b_del, SIGNAL(clicked()), this, SLOT(slotDelClicked() ) );
    connect(mainWidget->txt_cname, SIGNAL(textChanged(const QString &)), this, SLOT(slotCheckIsOk() ) );
    slotCheckIsOk();
    if(pbslots & kmobiletoolsEngine::PB_SIM) mainWidget->cb_memslot->insertItem( PB_SIM_TEXT );
    if(pbslots & kmobiletoolsEngine::PB_Phone) mainWidget->cb_memslot->insertItem( PB_PHONE_TEXT );
    if(pbslots & kmobiletoolsEngine::PB_DataCard) mainWidget->cb_memslot->insertItem( PB_DATACARD_TEXT );
    resize(500,400);
}


#include "editaddressee.moc"

void editAddressee::done(int r)
{
    QListViewItemIterator it( mainWidget->lv_numbers );
    addressee=new KABC::Addressee();
    addressee->setNameFromString( mainWidget->txt_cname->text() );
//     if(mainWidget->index_2->isChecked() ) addressee->insertCustom("KMobileTools","index", QString::number(mainWidget->i_index->value() ) );
//     else addressee->insertCustom("KMobileTools","index",QString("0") );
    while ( it.current() ) {
        QValueList<int> typelist=KABC::PhoneNumber::typeList();
        QValueListIterator<int> nit;
        for ( nit = typelist.begin(); nit != typelist.end(); ++nit )
            if(KABC::PhoneNumber::typeLabel(*nit) ==  it.current()->text(1) ) 
                addressee->insertPhoneNumber(KABC::PhoneNumber(it.current()->text(0), *nit) );
        ++it;
    }
    addressee->insertCustom("KMobileTools","memslot",QString::number(pbSlot() ) );
    KDialogBase::done(r);
}


/*!
    \fn editAddressee::slotDelClicked()
 */
void editAddressee::slotDelClicked()
{
    if ( ! (mainWidget->lv_numbers->selectedItem () ) ) return;
    delete mainWidget->lv_numbers->selectedItem ();
    slotCheckIsOk();
}


/*!
    \fn editAddressee::slotAddClicked()
 */
void editAddressee::slotAddClicked()
{
    new KListViewItem( mainWidget->lv_numbers, mainWidget->txt_number->text(), mainWidget->cb_type->currentText() );
    slotCheckIsOk();
}

void editAddressee::slotCheckIsOk()
{
    if( (mainWidget->lv_numbers->childCount() ) &&
         mainWidget->txt_cname->text().length() )
        enableButton(Ok, true);
    else enableButton(Ok, false);
}



/*!
    \fn editAddressee::pbSlot()
 */
int editAddressee::pbSlot()
{
    if( mainWidget->cb_memslot->currentText() == PB_SIM_TEXT ) return kmobiletoolsEngine::PB_SIM;
    if( mainWidget->cb_memslot->currentText() == PB_PHONE_TEXT) return kmobiletoolsEngine::PB_Phone;
    if( mainWidget->cb_memslot->currentText() == PB_DATACARD_TEXT ) return kmobiletoolsEngine::PB_DataCard;
    return -1;
}
