/***************************************************************************
                          kpmailaccount.h  -  description
                             -------------------
    begin                : Die Feb 25 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _KPMAILACCOUNT_H_
#define _KPMAILACCOUNT_H_
 
#include <qstring.h>

#include "kpmailurl.h"
 
class KConfig;

class KPMailAccount
{

public:

  KPMailAccount();
  virtual ~KPMailAccount();

  void setName (QString name);

   /**
     * Sets the mailbox url.
     * It uses a KPMailUrl to specify the
     * protocol, host, username, password, port and path (depending on
     * protocol type).  KPMailAccount recognizes four protocols:
     *
     * <UL>
     * <LI>mbox</LI> Unix style mailbox files
     * <LI>pop3</LI> POP3
     * <LI>imap4</LI> IMAP4
     * <LI>maildir</LI> Mailboxes in maildir format
     * <LI>mh</LI> Mailboxes in MH format
     * <LI>nttp</LI> USENET newsgroups
     * </UL>
     *
     * Some examples:
     * <PRE>
     * mbox:/var/spool/mail/granroth
     * </PRE>
     *
     * This would monitor a local file called '/var/spool/mail/granroth'
     *
     * <PRE>
     * pop3://granroth:password@host.net:1234
     * </PRE>
     *
     * This would monitor POP3 mailbox 'granroth' on server 'host.net'
     * using 1234 as the port and 'password' as the password.
     *
     * <PRE>
     * imap4://granroth:password@host.net/Mail/mailbox
     * </PRE>
     *
     * This would monitor IMAP4 mailbox 'Mail/mailbox' on server 'host.net'
     * with 'granroth' as the user and 'password' as the password.
     */  
  void setUrl  (KPMailURL url);

  void setPollInterval(int interval);
  void setActive( bool active );
  void setNumberOfEmails( int num );

  KPMailURL&  url();
  QString     name();
  int         pollInterval();
  int         numberOfEmails();
  bool        isActive();
  bool        isAutocheckEnabled();

  KPMailAccount* duplicate();

  bool save(KConfig* cfg, QString groupKey);
  bool load(KConfig* cfg, QString groupKey);

protected:

  // store this
  QString   m_name;
  KPMailURL m_url;
  int       m_pollInterval;
  bool      m_active;

  int       m_numEmails;

  // protocol dependend data:
  QString   m_simpleURL;
};

typedef QPtrList<KPMailAccount> KPMailAccountList;

#endif



