/***************************************************************************
                          kpmailaccount.cpp  -  description
                             -------------------
    begin                : Die Feb 25 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include <kconfig.h>

#include "kpmailaccount.h"


KPMailAccount::KPMailAccount()
{
  m_active=true;
  m_name="";
  m_pollInterval = -1;
  m_numEmails = 0;
}

KPMailAccount::~KPMailAccount()
{
}

void KPMailAccount::setName(QString name)
{
  m_name=name;
}

void KPMailAccount::setUrl( KPMailURL url )
{
  m_url = url;
}

void KPMailAccount::setPollInterval(int interval)
{
  m_pollInterval = interval;
}

KPMailURL& KPMailAccount::url()
{
  return m_url;
}


QString KPMailAccount::name()
{
  return m_name;
}

int KPMailAccount::pollInterval()
{
  return m_pollInterval;
}

void KPMailAccount::setActive( bool active ) {
  m_active=active;
}

bool KPMailAccount::isAutocheckEnabled() {
  return ( m_active && m_pollInterval>0 );
}

bool KPMailAccount::isActive( ) {
  return m_active;
}

KPMailAccount* KPMailAccount::duplicate() {
  KPMailAccount* acc = new KPMailAccount();
  acc->setUrl         ( url()          );
  acc->setName        ( name()         );
  acc->setActive      ( isActive()     );
  acc->setPollInterval( pollInterval() );
  return acc;
}


bool KPMailAccount::save(KConfig* cfg, QString groupKey)
{
  cfg->setGroup(groupKey);
  cfg->writeEntry("name",m_name);
  cfg->writeEntry("url",m_url.url());
  cfg->writeEntry("pollInterval",m_pollInterval);
  cfg->writeEntry("active",m_active);
  cfg->writeEntry("lastEmailCount",m_numEmails);
  return true;
}


bool KPMailAccount::load(KConfig* cfg, QString groupKey)
{
  cfg->setGroup(groupKey);
  m_name         = cfg->readEntry("name","???");
  m_url          = KPMailURL( cfg->readEntry("url","") );
  m_pollInterval = cfg->readNumEntry("pollInterval",5*60);
  m_active       = cfg->readBoolEntry("active",true);
  m_numEmails    = cfg->readNumEntry("lastEmailCount",0);
  return true;
}


void KPMailAccount::setNumberOfEmails( int num ) {
  m_numEmails = num;
}

int KPMailAccount::numberOfEmails() {
  return m_numEmails;
}
