/***************************************************************************
                          kpkabcontactreader.cpp  -  description
                             -------------------
    begin                : Sam Jan 18 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kickpim.h"
#include "kpkabcontact.h"
 
#include "kpkabcontactreader.h"

KPKabContactReader::KPKabContactReader()
{
  LogService::construct("KPKabContactReader");

  m_addrBook = StdAddressBook::self();
  // m_addrBook->load();
  // StdAddressBook::setAutomaticSave(false);

  // tell everybody that contacts are ready for display
  emit contactsChanged(this);

  connect( m_addrBook, SIGNAL( addressBookChanged  (AddressBook*) ),
           this,       SLOT  ( onAddressBookChanged(AddressBook*) ) );

  m_itor = m_addrBook->begin();
}

KPKabContactReader::~KPKabContactReader()
{
  LogService::destruct("KPKabContactReader");
  disconnect( this, SLOT  ( onAddressBookChanged(AddressBook*) ) );
  m_addrBook = 0;
}

void KPKabContactReader::reload()
{
  m_addrBook->load();
}

KPContact* KPKabContactReader::first()
{
  if (!m_addrBook) return 0;
  
  m_itor = m_addrBook->begin();

  // skip empty addresses
  while (m_itor!=m_addrBook->end() && ((Addressee)*m_itor).isEmpty())
  {
    LogService::logWarn(LogService::CAT_CONTACTS,"KPKabContactReader: Skipping an empty addressee");
    ++m_itor;
  }
  if (m_itor==m_addrBook->end()) return 0;  

  KPContact* contact = createContact( m_itor );
  m_itor++;
  return contact;
}

KPContact* KPKabContactReader::createContact( AddressBook::Iterator& itor )
{  
  if (itor == m_addrBook->end()) return 0;
        
  Addressee& addr = *itor;
  if (addr.isEmpty()) return 0; // shouldn't happen!
  
  KPKabContact* contact = new KPKabContact(addr);
  return contact;
}
  
KPContact* KPKabContactReader::next()
{
  if (!m_addrBook) return 0;

  // skip empty addresses
  while (m_itor!=m_addrBook->end() && ((Addressee)*m_itor).isEmpty())
  {
    LogService::logWarn(LogService::CAT_CONTACTS,"KPKabContactReader: Skipping an empty addressee");
    ++m_itor;
  }
  if (m_itor==m_addrBook->end()) return 0;

  KPContact* contact = createContact( m_itor );
  m_itor++;
  return contact;
}

void KPKabContactReader::onAddressBookChanged ( AddressBook* book )
{
  LogService::logInfo(LogService::CAT_CONTACTS, "KPKabContactReader: The AddressBook '"+book->identifier()+"' has been changed." );
  emit contactsChanged(this);
}
