/***************************************************************************
                          kpaddressinfopopup.cpp  -  description
                             -------------------
    begin                : Mit Jan 15 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <iostream>
 
#include <klistview.h>
#include <klocale.h>
#include <kglobalsettings.h>
#include <kabc/addressee.h>

#include "kickpim.h"
#include "kickpimcontactviewitem.h"
  
#include "kpdynamictip.h"

using namespace KABC;
using namespace std;

KPDynamicTip::KPDynamicTip( QWidget* parent ) : QToolTip( parent )
{
  FUNC_CALL(KPDynamicTip::KPDynamicTip)

  m_colTitleBack = KGlobalSettings::activeTitleColor().name();
  m_colTitleText = KGlobalSettings::activeTextColor().name();  
}

KPDynamicTip::~KPDynamicTip()
{
  FUNC_CALL(KPDynamicTip::~KPDynamicTip)
}

void KPDynamicTip::mayBeTipAddressView( const QPoint& p ) {
  if (!active) return;

  KListView* listView = dynamic_cast<KListView*>(parentWidget()->parent());
  KickPimContactViewItem* item  = (KickPimContactViewItem*) ( listView->itemAt( listView->viewport()->mapFrom(listView,p) ) );
  if ( !item ) return;

  QString text = "";

  if ( item->isDistributionList() && item->distributionList() )
  {
    text += "<tr><td bgcolor=\""+m_colTitleBack+"\">";
    text += "<font color=\""+m_colTitleText+"\"><b>";
    text += "["+item->distributionList()->name()+"]";
    text += "</font></b>";
    text += "</td></tr>";

    text += "<tr><td>";
    QStringList mailList = item->distributionList()->emails();
    if (!mailList.isEmpty())
    {
      text += mailList.join("<br>");
    }
    text += "</td></tr>";
  }
  else if ( item->contact() )
  {
    text += "<tr><td bgcolor=\""+m_colTitleBack+"\">";
    text += "<font color=\""+m_colTitleText+"\"><b>";
    text += KickPIM::rep()->displayName(item->contact());
    text += "</font></b>";
    text += "</td></tr>";             

    // phone
    QStringMap phoneMap = item->contact()->phoneNumbers();
    if (phoneMap.count()>0)
    {
      text += "<tr><td>";
      text+="<b>"+i18n("Phone")+"</b><br>";
      QStringMap::iterator itor = phoneMap.begin();
      int count=0;
      while (itor != phoneMap.end())
      {          
        text += itor.data();
        ++count;
        ++itor;
        if (itor!=phoneMap.end()) text+="<br>";
      }
      text += "</td></tr>";
    }

    // emails
    QStringList mailList = item->contact()->emailAddresses();
    if (!mailList.isEmpty())
    {
      text += "<tr><td>";

      text = text + "<b>" + i18n("Email") + "</b><br>";

      text+=mailList.join("<br>");

      text += "</td></tr>";        
    }

    // birthday
    QDate birthday = item->contact()->birthday();
    if( birthday.isValid() )
    {
      text += "<tr><td>";

      text = text + "<b>" + i18n("Birthday") + ":</b><br>";
      QDate today = QDate().currentDate();

      int year = today.year();
      if( today.dayOfYear() < birthday.dayOfYear() )  year--;

      QString birthdate = birthday.toString(Qt::LocalDate);
      text += birthdate+", ";
      text += i18n("age: %n year","age: %n years",year - birthday.year());

      text += "</td></tr>";
    }
  }
  if (!text.isEmpty()) tip( listView->itemRect(item), "<qt><table>"+text+"</table></qt>" );
}

void KPDynamicTip::maybeTip(const QPoint& p)
{
  // FUNC_CALL(KPDynamicTip::maybeTip)

  if (!parentWidget()) return;

  QString text;
  KListView* listView = dynamic_cast<KListView*>(parentWidget()->parent());
  if (listView && listView->name()==QString("AddressView"))
  {      
    mayBeTipAddressView( p );
  }
}


bool KPDynamicTip::active = true;

bool KPDynamicTip::isActive( ) {
  return active;
}

void KPDynamicTip::setActive( bool act ) {
  active = act;
}
