/***************************************************************************
                          kpcontact.h  -  description
                             -------------------
    begin                : Fre Jan 17 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPCONTACT_H
#define KPCONTACT_H

#include <qstring.h>
#include <qmap.h>
#include <qptrlist.h>
#include <qstringlist.h>
#include <qdatetime.h>
#include <qobject.h>

class KPContactAddress;

typedef QMap<QString, QString>          QStringMap;
typedef QMap<QString, KPContactAddress> QAddressMap;

/**
  *@author Bert Speckels
  */

class KPContact : public QObject
{

  Q_OBJECT
  
public: 
  KPContact(bool autoInsert=false);
  virtual ~KPContact();

  virtual bool isEmpty() const = 0;

  virtual void changed() = 0;  

  //
  // GET
  //
  
  /** Stringmap of names.
   *  stored in keys: "formattedName", "realName", "familyName", "givenName", "nickName", "organizsationName"
   */
  virtual QStringMap names()          const = 0;

  /** Stringmap of addresses.
   *  like "job", "home" ...
   */
  virtual QAddressMap addresses()    const = 0;

  /** Stringmap of email addresses. */
  virtual QStringList emailAddresses() const = 0;
  
  /** Stringmap if phone numbers. */
  virtual QStringMap phoneNumbers() const = 0;

  /** Stringmap of webpage addresses. */
  virtual QStringMap webpageURLs() const = 0;

  /** birthday. */
  virtual QDate birthday() const = 0;

  /** anniversary. */
  virtual QDate anniversary() const = 0;
  
  /** Stringlist of categories */
  virtual QStringList categories() const = 0;

  /** Note for the contact. */
  virtual QString note() const = 0;

  //
  // SET
  //


  virtual void setName(QString name, QString key) = 0;
  
  virtual bool setNote(QString& note) = 0;

  virtual void clearEmailAddresses() = 0;
  virtual void addEmailAddress(QString emailAddr, bool preferred = false) = 0;

  virtual void clearPhoneNumbers() = 0;
  virtual void addPhoneNumber(QString number, QString key) = 0;

  virtual void setBirthday    ( QDate date ) = 0;
  virtual void setAnniversary ( QDate date ) = 0;

  virtual void setCategories ( QStringList list ) = 0;  

  
  /** Let the user edit all contact properties in an address-db dependent way. */
  virtual bool edit();

  /** Remove the contact from the address-db */
  virtual bool remove() = 0;

  
};


class KPContactList : public QPtrList<KPContact>
{
  public:
    KPContactList();
    ~KPContactList();

    virtual int compareItems(QPtrCollection::Item item1,QPtrCollection::Item item2);
};

class KPContactAddress
{
  
public:

  KPContactAddress() { };
  virtual ~KPContactAddress() { };

  QString street()        { return m_street; };
  QString locality()      { return m_locality; };
  QString region()        { return m_region; }
  QString postalCode()    { return m_postalCode; }
  QString postOfficeBox() { return m_postOfficeBox; };
  QString country()       { return m_country; }  

  void setStreet        (QString s) { m_street        = s; };
  void setLocality      (QString s) { m_locality      = s; };
  void setRegion        (QString s) { m_region        = s; }
  void setPostalCode    (QString s) { m_postalCode    = s; }
  void setPostOfficeBox (QString s) { m_postOfficeBox = s; };
  void setCountry       (QString s) { m_country       = s; }

  QString formattedAddress(QString newLine = "\n", bool withCountry = false);
    
private:

  QString m_street;
  QString m_locality;
  QString m_region;
  QString m_postalCode;
  QString m_postOfficeBox;  
  QString m_country;  
};

#endif
