/***************************************************************************
                          kickpimoptions.h  -  description
                             -------------------
    begin                : Sam Nov 9 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KICKPIMOPTIONS_H
#define KICKPIMOPTIONS_H

#include <qpoint.h>
#include <qsize.h>
#include <qstring.h>
#include <qfont.h>
#include <qdatetime.h>

#include <kglobalaccel.h>

#include "mailing/kpmailaccount.h"

/**
  *@author Bert Speckels
  */

class KickPimOptions
{
public:
  enum { ADDR_FORMATTED,    ADDR_SURNAME,          ADDR_FORENAME,      ADDR_MAX                              };
  enum { ADDR_ACTION_CARD,  ADDR_ACTION_MAIL,      ADDR_ACTION_EDIT,   ADDR_ACTION_MAX };
  enum { BIRTHDAY, ANNIVERSARY, FEATURE_MAX };
  enum { INFO_APPLET=1, INFO_GENERAL=2, INFO_MENU=4, INFO_REMINDER=8, INFO_CARD=16,
         INFO_CONTACTS=32, INFO_EVENTS=64, INFO_MAILS=128 };
    
  KickPimOptions   ( QObject* owner );
  ~KickPimOptions  ( );

  void deactivateInfo (int info);
  bool isInfoActive   (int info);
  
  void load();
  void save();

  QString codePosition   ( QPoint& pos );
  QString codeSize       ( QSize& size );
    
  QPoint  decodePosition ( const QString& pos );
  QSize   decodeSize     ( const QString& pos );

public:
  /***
   ** general
   ***/

  // features
  bool showSidebar;
  bool showInfo;
  bool showContacts;
  bool showBirthdays;
  bool showAnniversaries;
  bool showEvents;
  bool showEmails;
  bool showCalendar;
  bool showContactSearch;
  bool showContactCategories;
  bool multipleSelection;
  bool enableTooltips;
  QString contactCategory;

  //int  maxNumBirthdays;

  // addresslist
  int  displayMode;
  int  defaultAction;

  /***
   ** reminders
   ***/

  bool remindAnniversaries;
  bool remindEvents;
  int  remindEventFuture;
  int  remindEventPast;
  int  remindAnniFuture;
  int  remindAnniPast;

  bool listAnniLimit;
  int  listAnniFuture;

  QDateTime lastReminded;

  //
  // MailAccounts
  //

  bool              mailCheckEnabled;
  KPMailAccountList mailAccounts;
  bool              mailNotifyPopup;
  bool              mailNotifyBeep;
  QString           mailNotifySoundFile;
  QString           mailNotifyAppPath;


  /***
   **  Help and Informations
   ***/

  int  infoFlag;

  /***
   ** fonts
   ***/

  QFont fontNormal;
  QFont fontBold;
  QFont fontSmall;
  QFont fontBig;  
  
  /***
   ** window positions
   ***/                              
  QPoint remindWindowPos;
  QSize  remindWindowSize;

  /***
   ** Debugging
   ***/
  int logLevel;
  int logCategories;

  KGlobalAccel*  globalAccel;
};

#endif
