/***************************************************************************
                          kickpimoptions.cpp  -  description
                             -------------------
    begin                : Sam Nov 9 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kickpim.h"
#include "kickpimoptions.h"

#include <klocale.h>
#include <kconfig.h>
#include <kglobalsettings.h>
#include <iostream>

using namespace std;

KickPimOptions::KickPimOptions(QObject* owner)
{
  LogService::construct( "KickPimOptions" );

  /***
   ** General   
   ***/
   
  // features
  showSidebar       = true;
  showInfo          = true;
  showContacts      = true;
  showBirthdays     = true;
  showAnniversaries = true;
  showEvents        = true;
  showEmails        = true;
  showCalendar      = true;
  multipleSelection = true;
  showContactSearch = true;
  showContactCategories = true;
  enableTooltips    = true;
  //maxNumBirthdays   = 0;
  contactCategory = "";
  remindWindowPos.setX(0);
  remindWindowPos.setY(0);
  remindWindowSize.setWidth (360);
  remindWindowSize.setHeight(240);

  // addresslist
  displayMode       = ADDR_FORMATTED;
  defaultAction     = ADDR_ACTION_CARD;

  /***
   ** Informations and Help
   ***/

  infoFlag = 0;

  /***
   ** reminders
   ***/

  remindEvents         = true;
  remindEventFuture    = 24*60; // minutes
  remindEventPast      = 12*60; // minutes

  remindAnniversaries  = true;
  remindAnniFuture     = 7;     // days
  remindAnniPast       = 3;     // days

  listAnniLimit        = false;
  listAnniFuture       = 30;    // days

  logLevel             = 0;
  logCategories        = 65535;

  /***
   ** Mail Accounts
   ***/

  mailCheckEnabled     = true;
  

  /***
   ** global accels
   ***/

  globalAccel = new KGlobalAccel(owner);

  /***
   ** fonts
   ***/

  fontNormal = KGlobalSettings::generalFont();
  fontBold   = KGlobalSettings::generalFont();
  fontSmall  = KGlobalSettings::generalFont();
  fontBig    = KGlobalSettings::generalFont();

  fontBold.setBold(true);
  fontSmall.setPointSize( fontSmall.pointSize() - 1 );
  fontBig.setBold(true);fontBig.setPointSize( fontSmall.pointSize()+4 );
           
}

KickPimOptions::~KickPimOptions()
{
  LogService::destruct("KickPimOptions");
}

QString KickPimOptions::codePosition ( QPoint& pos )
{
  QString s = QString::number(pos.x())+"/"+QString::number(pos.y());
  return s;
}

QPoint KickPimOptions::decodePosition ( const QString& code )
{
  QPoint position;
  int index = code.find("/");
  position.setX( code.left(index).toInt() );
  position.setY( code.right(code.length()-index-1).toInt() );

  return position;
}

QString KickPimOptions::codeSize ( QSize& size )
{
  QString s = QString::number(size.width())+"x"+QString::number(size.height());
  return s;
}

QSize KickPimOptions::decodeSize ( const QString& code )
{
  QSize size;
  int index = code.find("x");
  size.setWidth( code.left(index).toInt() );
  size.setHeight( code.right(code.length()-index-1).toInt() );

  return size;
}

void KickPimOptions::deactivateInfo(int info)
{
  infoFlag = infoFlag | info;
}

bool KickPimOptions::isInfoActive    (int info)
{
  return (infoFlag & info) == 0;
}


const QString MAILACCOUNT_GROUP_TITLE = "EmailAccount";


/** Loads data from the kickpimrc file.
 *
 * The file kickpimrc is a KConfig file in which KickPIM
 * stores the following data:
 * - Display state of features
 * - State of the email checker
 * - Settings of the reminders
 * - Window positions
 * - Short keys
 * - Email accounts
 *
 *
 */
void KickPimOptions::load()
{
  LogService::call("KickPimOptions","load");

  KConfig* cfg = new KConfig( "kickpimrc", false );

  cfg->setGroup("Features");

    showSidebar        = cfg->readBoolEntry("showSidebar",true);
    showInfo           = cfg->readBoolEntry("showInfo",true);
    showContacts       = cfg->readBoolEntry("showContacts",true);
    showBirthdays      = cfg->readBoolEntry("showBirthdays",true);
    showAnniversaries  = cfg->readBoolEntry("showAnniversaries",true);
    showEvents         = cfg->readBoolEntry("showEvents",true);
    showEmails         = cfg->readBoolEntry("showEmails",true);
    showCalendar       = cfg->readBoolEntry("showCalendar",true);
    showContactSearch  = cfg->readBoolEntry("showContactSearch",true);
    showContactCategories = cfg->readBoolEntry("showContactCategories",true);
    enableTooltips     = cfg->readBoolEntry("enableTooltips",true);
    multipleSelection  = cfg->readBoolEntry("multipleSelection",true);
    contactCategory    = cfg->readEntry("contactCategory","");

  cfg->setGroup("Email");

    mailCheckEnabled = cfg->readBoolEntry( "mailCheckEnabled", true);
    mailNotifyPopup  = cfg->readBoolEntry( "mailNotifyPopup",  false);
    mailNotifyBeep   = cfg->readBoolEntry( "mailNotifyBeep",   false );
    mailNotifySoundFile = cfg->readEntry( "mailNotifySoundFile", "" );
    mailNotifyAppPath   = cfg->readEntry( "mailNotifyAppPath",   "" );

  cfg->setGroup("Address-List");

    displayMode        = cfg->readNumEntry("addrlistDisplay",ADDR_FORMATTED);
    defaultAction      = cfg->readNumEntry("addrlistDefaultAction",ADDR_ACTION_CARD);

  cfg->setGroup("Reminder");

    remindEvents         = cfg->readBoolEntry ("remindEvents"       ,true);
    remindEventFuture    = cfg->readNumEntry  ("remindEventFuture"  ,24*60);
    remindEventPast      = cfg->readNumEntry  ("remindEventPast"    ,12*60);

    remindAnniversaries  = cfg->readBoolEntry ("remindAnniversaries",true);
    remindAnniFuture     = cfg->readNumEntry  ("remindAnniFuture"   ,7);
    remindAnniPast       = cfg->readNumEntry  ("remindAnniPast"     ,3);

    listAnniLimit        = cfg->readBoolEntry ("listAnniLimit"      ,false);
    listAnniFuture       = cfg->readNumEntry  ("listAnniFuture"     ,30);

    lastReminded         = cfg->readDateTimeEntry("lastReminded");
    
  cfg->setGroup("WindowPositions");

    remindWindowPos  = decodePosition( cfg->readEntry("remindWindowPos") );
    remindWindowSize = decodeSize    ( cfg->readEntry("remindWindowSize") );

  cfg->setGroup("Help");

    infoFlag = cfg->readNumEntry("infoFlag",0);

  cfg->setGroup("Debug");
    logLevel      = cfg->readLongNumEntry( "logLevelMax", 0 );
    logCategories = cfg->readLongNumEntry( "logLevelCategories", 65535 );

  cfg->setGroup("Global Keys");

    globalAccel->readSettings(cfg);
    globalAccel->updateConnections();

  cfg->setGroup("Email");

    int num = cfg->readNumEntry("numAccounts",0);

    mailAccounts.clear();
    for (int count=0;count<num;count++) {
      KPMailAccount* acc = new KPMailAccount();
      acc->load( cfg, MAILACCOUNT_GROUP_TITLE+QString::number(count+1) );
      mailAccounts.append(acc);
    }


  delete cfg;
}

/** save configuration options */
void KickPimOptions::save()
{
  LogService::call("KickPimOptions","save");

  KConfig* cfg = new KConfig( "kickpimrc" );

  cfg->setGroup("Features");

    // features
    cfg->writeEntry( "showSidebar",       showSidebar );
    cfg->writeEntry( "showInfo",          showInfo );
    cfg->writeEntry( "showContacts",      showContacts );
    cfg->writeEntry( "showContactSearch", showContactSearch );
    cfg->writeEntry( "showContactCategories", showContactCategories );
    cfg->writeEntry( "showBirthdays",     showBirthdays );
    cfg->writeEntry( "showAnniversaries", showAnniversaries );
    cfg->writeEntry( "showEvents",        showEvents );
    cfg->writeEntry( "showEmavoid rollback (bool bDeep = true) ils",        showEmails );
    cfg->writeEntry( "showCalendar",      showCalendar );
    cfg->writeEntry( "enableTooltips",    enableTooltips );
    cfg->writeEntry( "multipleSelection", multipleSelection );    
    cfg->writeEntry( "contactCategory",   contactCategory );

  cfg->setGroup("Email");

    cfg->writeEntry( "mailCheckEnabled",  mailCheckEnabled );
    cfg->writeEntry( "mailNotifyPopup",   mailNotifyPopup );
    cfg->writeEntry( "mailNotifyBeep",    mailNotifyBeep );
    cfg->writeEntry( "mailNotifySoundFile", mailNotifySoundFile );
    cfg->writeEntry( "mailNotifyAppPath",   mailNotifyAppPath );

  cfg->setGroup("Address-List");
  
    //cfg->writeEntry( "maxNumBirthdayEntries", maxNumBirthdays );

    // addresslist
    cfg->writeEntry( "addrlistDisplay", displayMode );
    cfg->writeEntry( "addrlistDefaultAction", defaultAction );

  cfg->setGroup("Reminder");
    
    cfg->writeEntry  ("remindEvents"       ,remindEvents);
    cfg->writeEntry  ("remindEventFuture"  ,remindEventFuture);
    cfg->writeEntry  ("remindEventPast"    ,remindEventPast);

    cfg->writeEntry  ("remindAnniversaries",remindAnniversaries);
    cfg->writeEntry  ("remindAnniFuture"   ,remindAnniFuture);
    cfg->writeEntry  ("remindAnniPast"     ,remindAnniPast);

    cfg->writeEntry  ("listAnniLimit"      ,listAnniLimit);
    cfg->writeEntry  ("listAnniFuture"     ,listAnniFuture);
    
    cfg->writeEntry  ("lastReminded"       ,lastReminded);

  cfg->setGroup("WindowPositions");
    
    cfg->writeEntry("remindWindowPos", codePosition(remindWindowPos));
    cfg->writeEntry("remindWindowSize",codeSize    (remindWindowSize));

  cfg->setGroup("Help");

    cfg->writeEntry("infoFlag",infoFlag);

  cfg->setGroup("Debug");
    cfg->writeEntry( "logLevelMax",        logLevel );
    cfg->writeEntry( "logLevelCategories", logCategories );
    
  cfg->setGroup("Global Keys");
  
    globalAccel->updateConnections();
    globalAccel->writeSettings(cfg);
    
  //
  // Mail accounts
  //
  cfg->setGroup("Email");

    cfg->writeEntry("numAccounts",mailAccounts.count());     

  KPMailAccount* acc  = mailAccounts.first();
  int count=0;
  while ( acc )
  {
    acc->save( cfg, MAILACCOUNT_GROUP_TITLE+QString::number(count+1) );
    acc = mailAccounts.next();
    count++;
  }
  while ( count<100 )
  {
    cfg->deleteGroup( MAILACCOUNT_GROUP_TITLE+QString::number(count+1), true );
    count++;
  }
  
  cfg->sync();
  
  delete cfg;
}
